//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mIcons.H                                            //
// Desc:   Stock icon bitmaps                                  //
// Date:   Feb, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MICONS_H_
#define _MICONS_H_

//-------------------------------------------------------------//
// Builtin stock symbols                                       //
//-------------------------------------------------------------//

int      GetStockSymSize( void );
uchar *  GetStockSymMap( int which );

//-------------------------------------------------------------//
// Builtin stock icons                                         //
//-------------------------------------------------------------//

enum mStockIconTypes
{
  siSTOPSIGN,
  siEXCLAIMATIONMARK,
  siQUESTIONMARK,
  siWINDOW,
  siCLOCK,
  siFLOPPYDISK,
  siPRINTER,
  siBOLT,
};

int      GetStockIconSize( void );
uchar *  GetStockIconMap( int which );
void     ChgStockColor( int which, int oldclr, int newclr );

//-------------------------------------------------------------//
// Type 1 Icon File - All icons are same type and size         //
//-------------------------------------------------------------//

class mIconType1File
{
   protected:

      char    filesig[4];    // signature - "AHS"
      char    filecon[4];    // content - "ICN"
      char    filetyp[2];    // type - "1"
      char    filever[2];    // version - "1"
      ushort  icount;        // number of icons
      ushort  iwidth;        // width in pixels
      ushort  iheight;       // height in pixels
      ushort  idepth;        // bits per pixel - 8 or 24
      ulong   ibmaps;        // set when loaded
      ulong   iresv1;        // reserved field
      ulong   iresv2;        // reserved field

   public:

      mIconType1File( )
      {
         strcpy( filesig, "AHS" );
         strcpy( filecon, "ICN" );
         strcpy( filetyp, "1" );
         strcpy( filever, "1" );
         icount = 0;
         iwidth = 0;
         iheight = 0;
         idepth = 0;
         ibmaps = iresv1 = iresv2 = 0L;
      }

      mIconType1File( uint c, uint w, uint h, uint d )
      {
         strcpy( filesig, "AHS" );
         strcpy( filecon, "ICN" );
         strcpy( filetyp, "1" );
         strcpy( filever, "1" );
         icount = c;
         iwidth = w;
         iheight = h;
         idepth = d;
         ibmaps = iresv1 = iresv2 = 0L;
      }

      mIconType1File( char *icnpath, int memtype );
     ~mIconType1File( );

      ushort  count( void )  { return icount; }
      ushort  width( void )  { return iwidth; }
      ushort  height( void ) { return iheight; }
      ushort  depth( void )  { return idepth; }
      uchar  *map( int which );
      void    draw( mPoint iorg, int which );
      int     fcreate( char *fn, uchar *bmaps[] );
      int     fsave( char *fn );
};

//-------------------------------------------------------------//
// Type 2 Icon File - Complex icons                            //
//-------------------------------------------------------------//

class mIconType2Image
{
   protected:

      ushort   iwidth;       // width in pixels
      ushort   iheight;      // height in pixels
      ushort   idepth;       // bits per pixel - 8 or 24
      ulong    iresv;        // reserved field
      ulong    ibmaps;       // set when loaded

   public:

      mIconType2Image( )
      {
         iwidth = 0;
         iheight = 0;
         idepth = 0;
         iresv = 0L;
         ibmaps = 0L;
      }
      mIconType2Image( mImage *im );
      mIconType2Image( int w, int h, int d, uchar *pxls );
      ~mIconType2Image( );

      ushort   width( void )       { return iwidth; }
      ushort   height( void )      { return iheight; }
      ushort   depth( void )       { return idepth; }
      uchar   *map( int row );
      mImage  *image( void );
      void     draw( mPoint iorg );
      int      read( FILE *fp, int memtype );
      int      save( FILE *fp, long compress );
};

class mIconType2File
{
   protected:

      char              filesig[4];    // signature - "AHS"
      char              filecon[4];    // content - "ICN"
      char              filetyp[2];    // type - "2"
      char              filever[2];    // version - "1"
      ushort            icount;        // number of icons
      ulong             resv1;         // reserved field
      ulong             resv2;         // reserved field
      mIconType2Image **ihdrs;         // image headers

   public:

      mIconType2File( )
      {
         strcpy( filesig, "AHS" );
         strcpy( filecon, "ICN" );
         strcpy( filetyp, "2" );
         strcpy( filever, "1" );
         icount = 0;
         resv1 = resv2 = 0L;
         ihdrs = 0;
      }
      mIconType2File( char *icnpath, int memtype );
      mIconType2File( mImage **images, int nimages );
      ~mIconType2File( );

      ushort   count( void )         { return icount; }
      ushort   width( int which );
      ushort   height( int which );
      ushort   depth( int which );
      uchar   *map( int which, int row );
      mImage  *image( int which );
      void     draw( mPoint org, int which );
      void     set_compressed( int state );
      int      get_compressed( void );
      int      fsave( char *fn );
};

#endif
