//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   HpFont.H                                            //
// Desc:   Definitions of HP Soft Font data structures         //
// Date:   Feb, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MHPFONT_H_
#define _MHPFONT_H_

//........ macro to swap bytes in a 2-byte word

#define REV_WRD( w )  ( ((w>>8) & 0x00FF) | ((w<<8) & 0xFF00) )

//........ constants for categorizing escape sequences

const int eFONTDESC = 1;        // define font descriptor
const int eCHARDESC = 2;        // define char descriptor
const int eCHARCODE = 3;        // specify current char code
const int eUNKNOWN  = 4;        // anything else

//........ font descriptor data structure

struct font_desc
{
    unsigned short fd_size;        // font descriptor size
             char  resv_1;         // reserved
    unsigned char  font_type;      // font type
             short resv_2;         // reserved
    unsigned short bl_dist;        // baseline dist (D)
    unsigned short cell_width;     // cell width (D)
    unsigned short cell_height;    // cell height (D)
    unsigned char  orient;         // orientation
    unsigned char  proportional;   // 0=fixed, 1=proportional
    unsigned short sym_set;        // symbol set
    unsigned short pitch;          // pitch (QD)
    unsigned short height;         // height (QD)
    unsigned short xheight;        // x height (QD)
             char  wid_typ;        // width type
    unsigned char  style;          // style
             char  stroke_weight;  // stroke weight
    unsigned char  typeface;       // typeface
             char  resv_3;         // reserved
    unsigned char  serif_style;    // serif style
             short resv_4;         // reserved
             char  ul_dist;        // underline dist (D)
    unsigned char  ul_height;      // underline height (D)
    unsigned short txt_height;     // text height (QD)
    unsigned short txt_width;      // text width  (QD)
             short resv_5;         // reserved
             short resv_6;         // reserved
    unsigned char  pitch_ext;      // pitch extended  (D/1024)
    unsigned char  height_ext;     // height extended (D/1024)
             short resv_7;         // reserved
             short resv_8;         // reserved
             short resv_9;         // reserved
             char  font_name[16];  // font name
};

//........ character descriptor data structure

struct char_desc
{
    unsigned char  format;         // 4 for LaserJet family
             char  continue_flag;  // 0 normally
    unsigned char  desc_size;      // 14 for LaserJet family
    unsigned char  desc_class;     // 1=bitmap, 2=compressed
    unsigned char  orient;         // should match font_dec
             char  resv_1;         // reserved
             short left_ofs;       // ref pt to bm left (D)
             short top_ofs;        // ref pt to bm top  (D)
    unsigned short char_width;     // bitmap width in pixels
    unsigned short char_height;    // bitmap height in pixels
             short delta_x;        // ref pt delta (QD)
    //............................... bitmap data follows here
};

//-------------------------------------------------------------//
//                       class mHpFont                         //
//-------------------------------------------------------------//

class mHpFont : public mBitFont
{
   public:

      mHpFont( char *path, int chmin, int chmax );
      virtual ~mHpFont( );

   private:

      void setfontmetrics( font_desc& fd );
      void setcharmetrics( mCharacter&, char_desc& fc );
};

#endif
