//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mGxEdit.H                                           //
// Desc:   Various classes and controls for graphics editing   //
// Date:   Dec, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MGXEDIT_H_
#define _MGXEDIT_H_

//-------------------------------------------------------------//

mPoint SubDiv( mRect area, mPoint pt, int xdiv, int ydiv );

//-------------------------------------------------------------//

// a pixel grid editor class

class mWnCtlPxlGrid;

// type for a callable edit function
typedef void (*mPxEditor)( mWnCtlPxlGrid& pxg, mMsg& msg );

class mWnCtlPxlGrid : public mWnControl
{
   protected:

      mPoint     gorg;    // grid origin
      mPoint     gcnt;    // grid size in cells
      mPoint     gsiz;    // grid size in pixels
      mPoint     gcur;    // current cell indexes
      mArray     *img;    // grid pixel value array
      mBrush     pxbr;    // cell fill brush;
      int        grid;    // grid state - on or off
      int        fclr;    // fill color - brush fg or bg
      int        xclr;    // color replaced by press event
      int        rcur;    // current image row index
      uchar     *row;     // current image row pointer
      mPxEditor  editor;  // edit function

   private:

      void setrow( int r );

   public:

      mWnCtlPxlGrid( mRect r, int nx, int ny );
      mWnCtlPxlGrid( );
      virtual ~mWnCtlPxlGrid( );

      virtual void  draw( void );
      virtual void  move( mPoint pt );
      virtual void  resize( int dx, int dy );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );

      void   drawgrid( void );
      void   drawimg( void );
      void   flush( void );
      mRect  cellrect( mPoint cell );
      mPoint cellindx( mPoint posn );
      int    isvalid( mPoint cell );
      int    cellx( int ix );
      int    celly( int iy );

      mArray   *getimage( void )   { return img; }
      mPoint    getorigin( void )  { return gorg; }
      mPoint    getcount( void )   { return gcnt; }
      mPoint    getsize( void )    { return gsiz; }
      mPoint    getcurrent( void ) { return gcur; }
      mBrush    getbrush( void )   { return pxbr; }
      mPxEditor geteditor( void )  { return editor; }
      int       getgrid( void )    { return grid; }
      int       getpixel( mPoint cell );

      void setgrid( int state )       { grid = state ? 1 : 0; }
      void setbrush( mBrush br )      { pxbr = br; }
      void seteditor( mPxEditor edt ) { editor = edt; }
      void setpixel( mPoint cell, int clr );
};

//-------------------------------------------------------------//

// a color selector control

class mWnCtlClrPick : public mWnControl
{
   protected:

      int   orient;      // horz/vert
      int   bgnindex;    // lowest index
      int   curindex;    // current index
      int   endindex;    // highest index
      int  *colors;      // color map (optional)

      int whichclr( mPoint p );

   public:

      mWnCtlClrPick( mRect r, mFont *fnt, char *lbl, int layout,
                     int ibgn, int iend, int *map );
      mWnCtlClrPick( );
      virtual ~mWnCtlClrPick( );

      virtual void  draw( void );
      virtual mRect extent( void );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );

      int  getpick( void )      { return curindex; }
      void setpick( int pick )  { curindex = pick; }
};

//-------------------------------------------------------------//

// a color selector control

class mWnCtlLRClrPick : public mWnControl
{
   protected:

      int   orient;      // horz or vert
      int   bgnindex;    // lowest index
      int   lcuindex;    // current left index
      int   rcuindex;    // current right index
      int   endindex;    // highest index
      int  *colors;      // color map (optional)

      int whichclr( mPoint p );

   public:

      mWnCtlLRClrPick( mRect r, mFont *fnt, char *lbl, int layout,
                     int ibgn, int iend, int *map );
      mWnCtlLRClrPick( );
      virtual ~mWnCtlLRClrPick( );

      virtual void  draw( void );
      virtual mRect extent( void );
      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );

      int  getlpick( void )      { return lcuindex; }
      void setlpick( int pick )  { lcuindex = pick; }
      int  getrpick( void )      { return rcuindex; }
      void setrpick( int pick )  { rcuindex = pick; }
};

#endif
