//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mGtypes.H                                           //
// Desc:   Basal graphics object types                         //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MGTYPES_H_
#define _MGTYPES_H_

// forward declarations
struct mPoint;
struct mRect;
struct mShape;
struct mQuilt;

//-------------------------------------------------------------//
//                         mPoint                              //
//-------------------------------------------------------------//

struct mPoint
{
      short x;
      short y;

      mPoint( )
      {
         x = y = 0;
      }
      mPoint( mPoint& p )
      {
         x = p.x; y = p.y;
      }
      mPoint( short xp, short yp )
      {
         x = xp; y = yp;
      }
      ~mPoint( )
      {
      }

      void set( short xp, short yp )
      {
         x = xp;  y = yp;
      }

      // Point-Rect Operators
      int   operator %  ( mRect& r );

      // Point-Point Operators
      mPoint& operator =  ( mPoint& p );
      int     operator == ( mPoint& p );
      int     operator != ( mPoint& p );
      mPoint  operator +  ( mPoint& p );
      mPoint& operator += ( mPoint& p );
      mPoint  operator -  ( mPoint& p );
      mPoint& operator -= ( mPoint& p );
      mPoint  operator *  ( mPoint& p );
      mPoint& operator *= ( mPoint& p );

      // Point-Constant Operators
      mPoint  operator +  ( short c );
      mPoint& operator += ( short c );
      mPoint  operator -  ( short c );
      mPoint& operator -= ( short c );
      mPoint  operator *  ( short c );
      mPoint& operator *= ( short c );
};


//-------------------------------------------------------------//
//                           mRect                             //
//-------------------------------------------------------------//

//  mRect is the basic definition of a rectangular region.

struct mRect
{
      short xmin;
      short ymin;
      short xmax;
      short ymax;

      mRect( );
      mRect( mRect& a );
      mRect( mPoint& p1, mPoint& p2 );
      mRect( short x1, short y1, short x2, short y2 );
      ~mRect( );

      // Member Function(s)
      void   set( short x1, short y1, short x2, short y2 );
      void   normalize( void );
      short  delx( void )  { return xmax - xmin; }
      short  dely( void )  { return ymax - ymin; }
      short  minx( void )  { return xmin; }
      short  midx( void )  { return (xmin+xmax)>>1; }
      short  maxx( void )  { return xmax; }
      short  miny( void )  { return ymin; }
      short  midy( void )  { return (ymin+ymax)>>1; }
      short  maxy( void )  { return ymax; }
      mPoint minpt( void ) { return mPoint(xmin,ymin); }
      mPoint midpt( void ) { return mPoint(midx(),midy()); }
      mPoint maxpt( void ) { return mPoint(xmax,ymax); }
      mRect  center( void );

      // Rect-Rect Operators
      mRect& operator =  ( mRect& r );
      int    operator == ( mRect& r );
      int    operator != ( mRect& r );
      int    operator %  ( mRect& r );
      mRect  operator |  ( mRect& r );
      mRect& operator |= ( mRect& r );
      mRect  operator &  ( mRect& r );
      mRect& operator &= ( mRect& r );

      // Rect-Point Operators
      mRect  operator +  ( mPoint& p );
      mRect& operator += ( mPoint& p );
      mRect  operator -  ( mPoint& p );
      mRect& operator -= ( mPoint& p );
      mRect  operator >>  ( mPoint& p );
      mRect& operator >>= ( mPoint& p );
      mRect  operator <<  ( mPoint& p );
      mRect& operator <<= ( mPoint& p );

      // Rect-Constant Operators
      mRect  operator +   ( short c );
      mRect& operator +=  ( short c );
      mRect  operator -   ( short c );
      mRect& operator -=  ( short c );
      mRect  operator >>  ( short c );
      mRect& operator >>= ( short c );
      mRect  operator <<  ( short c );
      mRect& operator <<= ( short c );
};


//-------------------------------------------------------------//
//                          mShape                             //
//-------------------------------------------------------------//

// mShape is a base class for areal types such as polygons

struct mShape
{
      short   np;
      mPoint *pt;

      mShape( );
      mShape( mShape& s );
      mShape( short npts );
      mShape( short npts, mPoint pts[] );
      ~mShape( );

      // Member Function(s)
      mRect  bounding_rect( void );
      short  minx( void );
      short  maxx( void );
      short  miny( void );
      short  maxy( void );

      // Shape-Shape Operator(s)
      mShape& operator = ( mShape& s );

      // Shape-Point Operator(s)
      mShape& operator += ( mPoint& p );
      mShape& operator -= ( mPoint& p );

      // Shape-Constant Operator(s)
      mShape& operator += ( short c );
      mShape& operator -= ( short c );
};


//-------------------------------------------------------------//
//                          mQuilt                             //
//-------------------------------------------------------------//

//  mQuilt represents the rectangular decomposition of
//  overlapping mRects, such as two Windows on the display.

struct mQuilt
{
      short   nr;
      mRect  *rt;

      mQuilt( );
      mQuilt( mRect& r );
      mQuilt( mQuilt& q );
      mQuilt( mRect& r1, mRect& r2 );
      ~mQuilt( );

      void compute_quilt( mRect& r1, mRect& r2 );
      void modify_quilt( int (*cmp)(mRect,mRect), mRect r );

      mQuilt& operator  = ( mQuilt& q );
      mQuilt& operator += ( mQuilt& q );
      mQuilt& operator += ( mRect r );
      mQuilt& operator += ( mPoint p );
      mQuilt& operator -= ( mPoint p );
      mRect   operator [] ( int which );

      // all rects outside r
      void    notR( mRect r );
      // all rects outside or overlapping r
      void    notRO( mRect r );
      // all rects inside r
      void    andR( mRect r );
      // all rects inside or overlapping r
      void    andRO( mRect r );
};

#endif
