//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mGdiFont.H                                          //
// Desc:   Font class for graphics subsystem font support      //
// Date:   Dec, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MGDIFONT_H_
#define _MGDIFONT_H_

//-------------------------------------------------------------//
//                       class mGdiFont                        //
//-------------------------------------------------------------//

class mGdiFont : public mFont
{
   protected:

      mPoint justp( mPoint p, int dx, int dy );
      mPoint justp( mRect r, int dx, int dy );

   public:

      mGdiFont( );
      virtual ~mGdiFont( );

      // parameter read functions
      virtual short  charwidth( short c );
      virtual short  stringwidth( char *str, short xclude=0 );
      virtual mPoint stringsize( char *str, short xclude=0 );
      virtual mRect  stringrect( mPoint pnt, char *str, short xclude=0 );

      // text drawing functions - point based
      virtual mPoint drawchar( mPoint p, short c );
      virtual mPoint drawstring( mPoint p, char *str );
      virtual mPoint drawbdrstr( mPoint p, char *str, mPen pn, int ioset=rgnOUTSET );
      virtual mPoint drawhilostr( mPoint p, char *str, mPen pn, short toggle );

      // text drawing functions - rect based
      virtual mPoint drawchar( mRect r, short c );
      virtual mPoint drawstring( mRect r, char *str );
      virtual mPoint drawbdrstr( mRect r, char *str, mPen pn, int ioset=rgnOUTSET );
      virtual mPoint drawhilostr( mRect r, char *str, mPen pn, short toggle );
};

#endif
