//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mGattr.H                                            //
// Desc:   Graphics related attribute classes                  //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MGATTR_H_
#define _MGATTR_H_

//-------------------------------------------------------------//
//                          mPen                               //
//-------------------------------------------------------------//

struct mPen
{
   uchar pfg;     // foreground color
   uchar pbg;     // background color
   uchar pst;     // pen style
   uchar pxy;     // pen diameter

   mPen( )
   {
      pfg=0;  pbg=15; pst=0; pxy=1;
   }
   mPen( int fg )
   {
      pfg=fg; pbg=15; pst=0; pxy=1;
   }
   mPen( int fg, int bg )
   {
      pfg=fg; pbg=bg; pst=0; pxy=1;
   }
   mPen( int fg, int bg, int st, int xy )
   {
      pfg=fg; pbg=bg; pst=st; pxy=xy;
   }
   ~mPen( )
   {
   }
   void invert( void );
};

//-------------------------------------------------------------//
//                           mBrush                            //
//-------------------------------------------------------------//

struct mBrush
{
   uchar bfg;     // foreground color
   uchar bbg;     // background color
   uchar bst;     // brush style
   uchar pad;     // unused

   mBrush( )
   {
      bfg=15; bbg=0;  bst=1; pad=0;
   }
   mBrush( int fg )
   {
     bfg=fg; bbg=0;  bst=1; pad=0;
   }
   mBrush( int fg, int bg )
   {
      bfg=fg; bbg=bg; bst=1; pad=0;
   }
   mBrush( int fg, int bg, int st )
   {
      bfg=fg; bbg=bg; bst=st; pad=0;
   }
   ~mBrush( )
   {
   }
   void invert( void );
};

//-------------------------------------------------------------//
//                           mRgb                              //
//-------------------------------------------------------------//

struct mRgb
{
   uchar red;
   uchar grn;
   uchar blu;
   uchar tag;

   mRgb( )
   {
      red=0; grn=0; blu=0; tag=0;
   }
   mRgb( int r, int g, int b )
   {
      red=r; grn=g; blu=b; tag=0;
   }
   ~mRgb( )
   {
   }
};

//-------------------------------------------------------------//
//                           mPalette                          //
//-------------------------------------------------------------//

struct mPalette
{
   int      ncolors;
   int      pmax;
   mRgb   * colors;

   mPalette( )
   {
      ncolors = 0;
      pmax    = 0;
      colors  = 0;
   }
   mPalette( int nclrs )
   {
      colors  = new mRgb [nclrs];
      pmax    = 0;
      ncolors = (colors==0) ? 0 : nclrs;
   }
   ~mPalette( )
   {
      if( ncolors > 0 ) delete [] colors;
   }
};

//-------------------------------------------------------------//
//                         Default Pens                        //
//-------------------------------------------------------------//

mPen DefaultPen( void );
mPen DefaultOutsetPen( void );
mPen DefaultGhostedOutsetPen( void );
mPen DefaultInsetPen( void );
mPen DefaultTextPen( void );
mPen DefaultGhostedTextPen( void );
mPen DefaultWnTitlePen( void );
mPen DefaultWnBorderPen( void );
mPen DefaultHighlightPen( void );

void SetDefaultPen( mPen pn );
void SetDefaultOutsetPen( mPen pn );
void SetDefaultGhostedOutsetPen( mPen pn );
void SetDefaultInsetPen( mPen pn );
void SetDefaultTextPen( mPen pn );
void SetDefaultGhostedTextPen( mPen pn );
void SetDefaultWnTitlePen( mPen pn );
void SetDefaultWnBorderPen( mPen pn );
void SetDefaultHighlightPen( mPen pn );

mPen MakePen( int clr );

//-------------------------------------------------------------//
//                         Default Brushes                     //
//-------------------------------------------------------------//

mBrush DefaultBrush( void );
mBrush DefaultBackgroundBrush( void );
mBrush DefaultWhiteBrush( void );
mBrush DefaultWnBorderBrush( void );
mBrush DefaultWnTitleBrush( void );
mBrush DefaultWnControlBrush( void );
mBrush DefaultWnClientBrush( void );
mBrush DefaultHighlightBrush( void );

void SetDefaultBrush( mBrush br );
void SetDefaultBackgroundBrush( mBrush br );
void SetDefaultWhiteBrush( mBrush br );
void SetDefaultWnBorderBrush( mBrush br );
void SetDefaultWnTitleBrush( mBrush br );
void SetDefaultWnControlBrush( mBrush br );
void SetDefaultWnClientBrush( mBrush br );
void SetDefaultHighlightBrush( mBrush br );

void SetMonoPens( void );
void SetMonoBrushes( void );
void SetDefaultPenThickness( int t );

mBrush MakeBrush( int clr );

#endif
