//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mFont.H                                             //
// Desc:   Font and Character classes                          //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MFONT_H_
#define _MFONT_H_

//-------------------------------------------------------------//
//                       class mCharacter                      //
//-------------------------------------------------------------//

class mCharacter
{
   public:

      short   ascii_val;    // character's ascii value
      short   left_ofs;     // ref-pt to left edge dist
      short   top_ofs;      // ref-pt to top edge dist
      short   delta_x;      // ref-pt to next ref-pt dist
      short   bm_width;     // bitmask width
      short   bm_height;    // bitmask height
      char   *bitmap;       // character's bitmask

   public:

      mCharacter( );
      virtual ~mCharacter( );
      short    ascii( void )    { return ascii_val; }
      short    width( void )    { return delta_x;   }
      short    height( void )   { return bm_height; }
};


//-------------------------------------------------------------//
//                       class mFont                           //
//-------------------------------------------------------------//

class mFont
{
   public:

      short       fstatus;   // status of font

   protected:

      // font physical properties
      short       fstyle;    // style of font
      short       cell_w;    // cell width in pixels
      short       cell_h;    // cell height in pixels
      short       ascent;    // ascent dist in pixels
      short       descent;   // descent dist in pixels
      ushort      pitch;     // default pitch in pixels
      short       min_ch;    // min ASCII char code
      short       max_ch;    // max ASCII char code

      // text drawing parameters
      short       txclr;     // drawing color
      short       txdir;     // drawing direction
      short       txrot;     // character rotation
      short       txsp;      // intercharacter spacing
      short       txhjust;   // horizontal justification
      short       txvjust;   // vertical justification

   public:

      mFont(  );
      virtual ~mFont( );

      // parameter read functions
      short   getascent( void )    { return ascent; }
      short   getdescent( void )   { return descent; }
      short   getpitch( void )     { return pitch; }
      short   getcellw( void )     { return cell_w; }
      short   getcellh( void )     { return cell_h; }
      short   getminch( void )     { return min_ch; }
      short   getmaxch( void )     { return max_ch; }
      short   gettxcolor( void )   { return txclr; }
      short   gettxdir( void )     { return txdir; }
      short   gettxrot( void )     { return txrot; }
      short   gettxsp( void )      { return txsp; }
      short   gettxhjust( void )   { return txhjust; }
      short   gettxvjust( void )   { return txvjust; }

      // parameter set functions
      void    settxcolor( short clr )    { txclr = clr; }
      void    settxdir( short dir )      { txdir = dir; }
      void    settxrot( short rot )      { txrot = rot; }
      void    settxsp( short sp )        { txsp = sp; }
      void    settxhjust( short hjust )  { txhjust = hjust; }
      void    settxvjust( short vjust )  { txvjust = vjust; }

      // size functions
      virtual short  charwidth( short c ) = 0;
      virtual short  stringwidth( char *str, short xclude=0 ) = 0;
      virtual mPoint stringsize( char *str, short xclude=0 ) = 0;
      virtual mRect  stringrect( mPoint pnt, char *str, short xclude=0 ) = 0;

      // text drawing functions - point based
      virtual mPoint drawchar( mPoint p, short c ) = 0;
      virtual mPoint drawstring( mPoint p, char *str ) = 0;
      virtual mPoint drawbdrstr( mPoint p, char *str, mPen pn, int ioset=rgnOUTSET ) = 0;
      virtual mPoint drawhilostr( mPoint p, char *str, mPen pn, short toggle ) = 0;

      // text drawing functions - rect based
      virtual mPoint drawchar( mRect r, short c ) = 0;
      virtual mPoint drawstring( mRect r, char *str ) = 0;
      virtual mPoint drawbdrstr( mRect r, char *str, mPen pn, int ioset=rgnOUTSET ) = 0;
      virtual mPoint drawhilostr( mRect r, char *str, mPen pn, short toggle ) = 0;
};

#endif
