//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mfiles.H                                            //
// Desc:   Drive/Dir/File utility classes and functions        //
// Date:   Mar, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MFILES_H_
#define _MFILES_H_

//..................class mNameList

class mNameList
{
   protected :

      short     namecount;
      short     namesize;
      char  * * namelist;
      char    * namedata;

   public :

      mNameList( int cnt, int siz );
      virtual ~mNameList( );

      int count( void )
      {
         return namecount;
      }
      int size( void )
      {
         return namesize;
      }
      char * name( int which )
      {
         return ((which >= 0) && (which < namecount)) ?
                namelist[which] : 0;
      }
      char * operator [] ( int which )
      {
         return ((which >= 0) && (which < namecount)) ?
                namelist[which] : 0;
      }
      char * * names( void )
      {
         return namelist;
      }
      void sort( int order=0 );

      friend mNameList  operator +  ( mNameList& s1, mNameList& s2 );
      friend mNameList& operator += ( mNameList& s1, mNameList& s2 );
      friend mNameList  operator -  ( mNameList& s1, mNameList& s2 );
      friend mNameList& operator -= ( mNameList& s1, mNameList& s2 );
};

//..................class mDriveList

class mDriveList : public mNameList
{
   protected :

      long      drivemask;

   public :

      mDriveList( );
      virtual ~mDriveList( )
      {
      }

      long flags( void )
      {
         return drivemask;
      }
      int exists( int driveletter )
      {
         int d = toupper( driveletter );
         if( (d >= 'A') && (d <= 'Z') )
            return ( (1L << (d-'A')) & drivemask ) ? 1 : 0;
         return 0;
      }
};

//..................class mDirectoryList

class mDirectoryList : public mNameList
{
   protected :

      char *dspec;   // spec passed to constructor

   public :

      mDirectoryList( char *spec );
      virtual ~mDirectoryList( );
      char * dirspec( void )
      {
         return dspec;
      }
};

//..................class mFileList

class mFileList : public mNameList
{
   protected :

      char *fspec;   // spec passed to constructor
      char *froot;   // drive-directory
      char *fpath;   // space for a full path

   public :

      mFileList( char *spec );
      virtual ~mFileList( );
      char * filespec( void )
      {
         return fspec;
      }
      char * fileroot( void )
      {
         return froot;
      }
      char * filepath( int which );
      char * filename( int which );
      char * fileextn( int which );
};

#endif
