//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mEvtMgr.H                                           //
// Desc:   The event manager                                   //
// Date:   Jan, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MEVTMGR_H_
#define _MEVTMGR_H_

//-------------------------------------------------------------//
//                      class mEventManager                    //
//-------------------------------------------------------------//

// The event manager class

class mEventManager : public mQueue
{
   protected:

      mDevice *head;     // pointers to device chain
      mDevice *tail;

   public:

      mEventManager( );
     ~mEventManager( );

      // attach and detach a device
      mEventManager& operator << ( mDevice& device );
      mEventManager& operator >> ( mDevice& device );

      // enqueue and dequeue an event
      mEventManager& operator << ( mEvent& event );
      mEventManager& operator >> ( mEvent& event );

      void flush( void );   // flush all pending events
      int  count( void );   // get pending event count
      int  poll( void );    // poll all attached devices
};

#endif
