//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mEvent.H                                            //
// Desc:   Event related classes                               //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MEVENT_H_
#define _MEVENT_H_


// type/value/flags "wildcard" value
const short ANYKEY = 0x1111;


//-------------------------------------------------------------//
//                       struct mKey                           //
//-------------------------------------------------------------//

struct mKey            // key definition
{
   short  keytype;     // key type
   short  keyvalue;    // key value
   short  keyflags;    // shift/ctl/alt state
   mKey( );
   mKey( short kt, short kv, short kf );
   virtual ~mKey( ) { }
   int    operator == ( mKey& k );
   void   set( short kt, short kv, short kf );
};


//-------------------------------------------------------------//
//                       struct mEvent                         //
//-------------------------------------------------------------//

struct mEvent         // event definition
{
   int    devtype;    // device type
   int    hook;       // spare member
   ulong  time;       // event time stamp
   mPoint posn;       // a cursor position
   mKey   key;        // event's key

   mEvent( );
   mEvent( int dtype, int ktype, int kval, int kflags );
   virtual ~mEvent( ) { }
   int keymatch( mKey& k ) { return k == key; }
   mMsg message( void ) { return mMsg( mEVT, 0, (void *) this ); }
};

#endif
