//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mError.H                                            //
// Desc:   Generic error handler                               //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MERROR_H_
#define _MERROR_H_

//-------------------------------------------------------------//
//                         mError                              //
//-------------------------------------------------------------//

struct mError
{
   char  elevel;
   char  etype;
   int   evalue;
   int   eretv;
   char *emsg;

   mError( int etyp, int elvl, int eval, char *msg )
   {
      elevel = elvl;
      etype  = etyp;
      evalue = eval;
      eretv  = OKAY;
      emsg   = msg;
   }

   mError( char *msg )
   {
      elevel = 0;
      etype  = 0;
      evalue = 0;
      eretv  = OKAY;
      emsg   = msg;
   }

   virtual ~mError( ) { }
};

//-------------------------------------------------------------//
//                       mErrorLog                             //
//-------------------------------------------------------------//

class mErrorLog
{
   protected:

      char *errfile;
      char *emsgbuf;

   public:

      mErrorLog( char *logname );
     ~mErrorLog( );

      void operator << ( char *msg );
      void operator << ( mError& err );
      void errormsg( char *msg );
      void errormsg( char *msg, int val );
      void errormsg( char *msg, void *ptr );
      void errormsg( char *msg, mRect r );
      void errormsg( char *msg, mPoint p );
};


#endif
