//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mDither.H                                           //
// Desc:   Dithering classes                                   //
// Date:   Nov, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MDITHER_H_
#define _MDITHER_H_

//..................dither types

enum mDitherTypes
{
   ditNone,
   ditOrdered,
   ditThresholded,
   ditErrDiffused,
   ditClrThresholded,
   ditClrErrDiffused
};

//..................miscellaneous functions

int closest_rgb( mRgb x, mRgb *pal, int npal );
int graylevel( mRgb x );

//..................dither base class

class mDither
{
   public:
      int type;

   public:
      mDither( ) { type = ditNone; }
      virtual ~mDither( ) { }
      virtual void dither( unsigned char *px, int npx ) = 0;
};

//..................error diffusion dither (bilevel)

class mDiffusionDither : public mDither
{
   protected:
      int threshold;
      int ewidth;
      int on_value;
      int off_value;
      int *err1;
      int *err2;

   public:
      mDiffusionDither( );
      mDiffusionDither( int t, int maxwidth,
                        int von=1, int voff=0 );
      ~mDiffusionDither( );
      virtual void dither( unsigned char *pxls, int npxls );
      void reset( void );
};


class mColorDiffusionDither : public mDither
{
   protected:
      int  ndevcolors;      // number of device colors
      mRgb *devcolors;      // device colors
      int  nimgcolors;      // number of image colors
      mRgb *imgcolors;      // image colors
      int *rerr1, *rerr2;   // red error accumulators
      int *gerr1, *gerr2;   // green error accumulators
      int *berr1, *berr2;   // blue error accumulators
      int  ewidth;          // error array sizes

   private:
      int  bestdevclr( int r, int g, int b );

   public:
      mColorDiffusionDither( );
      mColorDiffusionDither( int maxw, mRgb *img, int nimg,
                             mRgb *dev, int ndev );
      ~mColorDiffusionDither( );

      virtual void dither( unsigned char *pxls, int npxls );
      void rgbdither( unsigned char *pxls, mRgb *clrs,
                                int npxls );
      void reset( void );
};

#endif
