//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mDisplay.H                                          //
// Desc:   Generic graphics display                            //
// Date:   Nov, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MDISPLAY_H_
#define _MDISPLAY_H_

// Various constants

const int fillpatterncnt = 32;

const int linepatterncnt = 8;

enum mPaletteStyles
{
   pAntique,
   pBordeaux,
   pBrass,
   pCrystal,
   pDesert,
   pDorian,
   pGold,
   pLeather,
   pMeadow,
   pMoss,
   pMountain,
   pOcean,
   pPewter,
   pReef,
   pSky,
   pSunset,
   pTomcat,
   pWood,
   pEgaBlue,
   pUser
};

enum LineStyles
{
   lSolid,
   lWideDotted,
   lCloseDotted,
   lShortDashed,
   lLongDashed,
   lShortDotDash,
   lLongDotDash,
   lDotDotDash
};

enum mRomFontMaps
{
   map8x8lo = 3,
   map8x8hi = 4,
   map8x14  = 2,
   map8x16  = 6
};

char *GetRomFontMap( int which );

struct mImageSave
{
   mRect  area;
   void   *bits;
   mImageSave( );
   mImageSave( mRect r );
  ~mImageSave( );
};

class mGdMgr  //......................graphics display manager
{
   protected:

     static mRect      dispR;      // display extent
     static mRect      viewR;      // viewport in screen coords
     static mRect      clipR;      // cliprect in viewport coords
     static mRect      charR;      // intrinsic char extent
     static mPoint     charAD;     // intrinsic char ascent/descent
     static mPalette * pal;        // active color palette
     static char     * palname;    // palette name
     static int        palid;      // palette index
     static int        nclrs;      // max simultaneous colors
     static int        wmode;      // active pixel write mode
     static int        count;      // instance count
     static int        orient;     // landscape or portrait
     static int        trueblit;   // true "blit" flag

   public:

     static int        status;     // OKAY or FAILED

     mGdMgr( int palno=pPewter );
    ~mGdMgr( );

     // parameter set functions.............................
     static void       setcharrect( mRect cr )   { charR = cr; }
     static void       setviewport( mRect vr );
     static void       setcliprect( void );
     static void       setcliprect( mRect cr );
     static void       setwrtmode( int wrtmode );
     static void       setpalette( int palno );
     static void       setcustompalette( mPalette& custpal );
     static void       setrgb( int clr, mRgb rgb );
     static void       setorient( int orientation );

     // parameter query functions...........................
     static mRect      getdisprect( void )   { return dispR; }
     static int        getdispwidth( void )  { return dispR.delx()+1; }
     static int        getdispheight( void ) { return dispR.dely()+1; }
     static mRect      getcharrect( void )   { return charR; }
     static int        getcharwidth( void )  { return charR.delx()+1; }
     static int        getcharheight( void ) { return charR.dely()+1; }
     static mRect      getviewrect( void )   { return viewR; }
     static int        getviewwidth( void )  { return viewR.delx()+1; }
     static int        getviewheight( void ) { return viewR.dely()+1; }
     static mPoint     getvieworigin( void ) { return mPoint(viewR.xmin,viewR.ymin); }
     static mRect      getcliprect( void )   { return clipR; }
     static int        getclipwidth( void )  { return clipR.delx()+1; }
     static int        getclipheight( void ) { return clipR.dely()+1; }
     static mPoint     getcliporigin( void ) { return mPoint(clipR.xmin,clipR.ymin); }
     static mPalette * getpalette( void )    { return pal; }
     static int        getpalid( void )      { return palid; }
     static int        getwrtmode( void )    { return wmode; }
     static int        getmaxcolors( void )  { return nclrs; }
     static mPen       getmaxpen( void )     { return mPen(nclrs-1,nclrs-1); }
     static int        getorient( void )     { return orient; }
     static char     * getpalname( void )    { return palname; }
     static int        instances( void )     { return count; }

     // drawing primitives..................................
     static void       drawpixel( mPoint p, int clr );
     static void       drawline( mPoint p1, mPoint p2, mPen pn );
     static void       drawrect( mRect r, mPen pn );
     static void       drawpolygon( mShape s, mPen pn );
     static void       drawellipse( mRect r, mPen pn );
     static void       drawmask( mPoint p, char *mask, int w, int h, int clr );
     static void       drawbmap( mPoint p, uchar *pixels, int w, int h );
     static void       drawbmap( mPoint p, uchar *pixels,
                                 int w, int h, char i );
     static void       drawbmap( mPoint p, uchar *pixels,
                                 uchar *vmask, int w, int h );
     static void       drawray( mPoint p, int r1, int r2, int a, mPen pn );
     static void       drawarc( mPoint p, int r, int a1, int a2, mPen pn );
     static void       drawbezier( mShape s, int nsegs, mPen pn );

     // filling primitives..................................
     static void       fillrect( mRect r, mBrush br );
     static void       fillpolygon( mShape s, mBrush br );
     static void       fillellipse( mRect r, mBrush br );

     // text primitives.....................................
     static mPoint textcell( void )
     {
        return mPoint( charR.delx()+1, charR.dely()+1 );
     }
     static int textcellwidth( void )
     {
        return charR.delx()+1;
     }
     static int textcellheight( void )
     {
        return charR.dely()+1;
     }
     static mPoint textcellascdsc( void )
     {
        return charAD;
     }
     static void   drawstring( mRect r, char *str, int clr, int jst=jXYRECT );
     static void   drawstring( mPoint p, char *str, int clr, int jst=jXYTEXT );
     static int    stringwidth( char *str );
     static mPoint stringsize( char *str );
     static mRect  stringrect( char *str );

     // other primitives....................................
     static int          readpixel( mPoint p );
     static int          gettrueblit( void )      { return trueblit; }
     static void         blitrect( mRect r, int dx, int dy );
     static void         scrollrect( mRect r, int dx, int dy, int clr );
     static void         scrollrect( mRect r, int dx, int dy, mBrush br );
     static void         framerect( mRect r, int ul_clr, int lr_clr );
     static void         frameellipse( mRect r, int ul_clr, int lr_clr );
     static void         erasedisplay( mBrush br );
     static mImageSave * saverect( mRect r );
     static void         restorerect( mImageSave * sav );
     static void         readscreen( mRect r, char *bufr );
     static void         writescreen( mRect r, char *bufr );
     static void         readscreen( mRect r, char **scan, int xofs );
     static void         writescreen( mRect r, char **scan, int xofs );

     // Mn/CPP coord to Graphics Host coord.................
     friend int     mapX( int x );
     friend int     mapY( int y );
     friend mPoint  mappoint( mPoint p );
     friend mRect   maprect( mRect r );
};

#endif
