//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mDevices.H                                          //
// Desc:   Device classes                                      //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MDEVICES_H_
#define _MDEVICES_H_

//-------------------------------------------------------------//
//                       miscellaneous                         //
//-------------------------------------------------------------//

void pause( int nticks );
int  NewTimerID( void );

//-------------------------------------------------------------//
//                       class mDevice                         //
//-------------------------------------------------------------//

// device types

enum mDeviceTypes
{
   devNULL   = 0,    // none
   devKEYBRD = 1,    // keyboard
   devMOUSE  = 2,    // mouse
   devTIMER  = 4,    // timer
   devPEN    = 8,    // pen
};

// Virtual base class for devices

class mDevice
{
   public:

     int       status;     // INSTALLED or FAILED
     int       type;
     mDevice  *prev;      // device chain links
     mDevice  *next;

     mDevice( );
     virtual ~mDevice( );

     void devdisable( void )
        { if( status==INSTALLED ) status = DISABLED; }
     void devenable( void )
        { if( status==DISABLED )  status = INSTALLED; }

     virtual int     poll( int eventmask ) = 0;
     virtual mEvent& read( void ) = 0;
};


//-------------------------------------------------------------//
//                      class mMsDevice                        //
//-------------------------------------------------------------//

// Mouse key types

enum mMsKeyTypes
{
   msNULL      = 0x0000,
   msPRESS     = 0x0001,
   msRELEASE   = 0x0002,
   msDBLCLICK  = 0x0004,
   msDRAG      = 0x0008
};

// Mouse event values

enum mMsKeyValues
{
   msLEFTBUTTON    = 0x0001,
   msRIGHTBUTTON   = 0x0002,
   msMIDDLEBUTTON  = 0x0004,
   msXCHANGE       = 0x0010,
   msYCHANGE       = 0x0020
};

// Mouse device

class mMsDevice : public mDevice
{
   protected:

     int    csrID;       // current cursor ID
     int    polled;      // flag - we've been polled
     int    DCint;       // double-click tick interval
     int    lastb;       // last button flags
     int    lastx;       // last screen-relative x cursor posn
     int    lasty;       // last screen-relative y cursor posn
     int    lastvx;      // last viewport-relative x cursor posn
     int    lastvy;      // last viewport-relative y cursor posn
     int    lastdx;      // last x cursor change
     int    lastdy;      // last y cursor change
     long   lastLpress;  // time of last left button press
     long   lastMpress;  // time of last middle button press
     long   lastRpress;  // time of last right button press
     mEvent theEvt;      // the pending event

   public:

     mMsDevice( );
    ~mMsDevice( );

     void    setcursor( int cursorID );
     void    setcursor( void *msk, int xh, int yh );
     int     getcursor( void ) { return csrID; }
     void    hidecursor( void );
     void    showcursor( void );
     void    flush( void );
     void    reduce( void );
     void    limitcursor( mRect r );
     void    limitcursor( mPoint p );
     void    positioncursor( mPoint p );
     int     querybuttons( void ) { return theEvt.key.keyvalue; }
     mPoint  querycursor( void );
     mPoint  querydelta( void );
     mPoint  queryprevcursor( void );

     void    setdcinterval( int i ) { DCint = i; }
     int     getdcinterval( void )  { return DCint; }

     virtual int     poll( int eventmask );
     virtual mEvent& read( void );

     int installed( void ) { return status; }
     void reset( void );
};


//-------------------------------------------------------------//
//                      class mKbDevice                        //
//-------------------------------------------------------------//

// keyboard key types

enum mKbKeyTypes
{
   kbNULL     = 0x0000,   // no event
   kbALPHANUM = 0x0001,   // normal key press
   kbKEYPAD   = 0x0002,   // keypad key
   kbFUNCTION = 0x0004,   // function key
   kbCONTROL  = 0x0008,   // ctl/alt/shift state change
   kbOTHER    = 0x0010    // anything else
};

// keyboard key values

enum mKbKeyValues
{
    // control state changes
    kbCTRLON    = 0x0001,
    kbCTRLOFF   = 0x0002,
    kbALTON     = 0x0003,
    kbALTOFF    = 0x0004,
    kbLSHIFTON  = 0x0005,
    kbLSHIFTOFF = 0x0006,
    kbRSHIFTON  = 0x0005,
    kbRSHIFTOFF = 0x0006,
    kbINSON     = 0x0007,
    kbINSOFF    = 0x0008,
    // miscellaneous
    kbENTER     = 0x1C0D,
    kbESCAPE    = 0x011B,
    kbTAB       = 0x0F09,
    kbSHIFTTAB  = 0x0F00,
    kbBACKSPACE = 0x0E08,
    // keypad keys
    kbUP        = 0x4800,
    kbDOWN      = 0x5000,
    kbLEFT      = 0x4B00,
    kbRIGHT     = 0x4D00,
    kbPGUP      = 0x4900,
    kbPGDN      = 0x5100,
    kbHOME      = 0x4700,
    kbEND       = 0x4F00,
    kbINSERT    = 0x5200,
    kbDEL       = 0x5300,
    kbCTRLHOME  = 0x7700,
    kbCTRLEND   = 0x7500,
    kbCTRLRIGHT = 0x7400,
    kbCTRLLEFT  = 0x7300,
    // function keys
    kbF1  =   0x3B00,
    kbF2  =   0x3C00,
    kbF3  =   0x3D00,
    kbF4  =   0x3E00,
    kbF5  =   0x3F00,
    kbF6  =   0x4000,
    kbF7  =   0x4100,
    kbF8  =   0x4200,
    kbF9  =   0x4300,
    kbF10 =   0x4400,
    // shift-function keys
    kbSHIFTF1 = 0x5400,
    kbSHIFTF2 = 0x5500,
    kbSHIFTF3 = 0x5600,
    kbSHIFTF4 = 0x5700,
    kbSHIFTF5 = 0x5800,
    kbSHIFTF6 = 0x5900,
    kbSHIFTF7 = 0x5A00,
    kbSHIFTF8 = 0x5B00,
    kbSHIFTF9 = 0x5C00,
    kbSHIFTF10 = 0x5D00,
    // control-function keys
    kbCTRLF1  = 0x5E00,
    kbCTRLF2  = 0x5F00,
    kbCTRLF3  = 0x6000,
    kbCTRLF4  = 0x6100,
    kbCTRLF5  = 0x6200,
    kbCTRLF6  = 0x6300,
    kbCTRLF7  = 0x6400,
    kbCTRLF8  = 0x6500,
    kbCTRLF9  = 0x6600,
    kbCTRLF10 = 0x6700,
    // alt-function keys
    kbALTF1  = 0x6800,
    kbALTF2  = 0x6900,
    kbALTF3  = 0x6A00,
    kbALTF4  = 0x6B00,
    kbALTF5  = 0x6C00,
    kbALTF6  = 0x6D00,
    kbALTF7  = 0x6E00,
    kbALTF8  = 0x6F00,
    kbALTF9  = 0x7000,
    kbALTF10 = 0x7100,
    // alt-alpha keys
    kbALTA = 0x1E00,
    kbALTB = 0x3000,
    kbALTC = 0x2E00,
    kbALTD = 0x2000,
    kbALTE = 0x1200,
    kbALTF = 0x2100,
    kbALTG = 0x2200,
    kbALTH = 0x2300,
    kbALTI = 0x1700,
    kbALTJ = 0x2400,
    kbALTK = 0x2500,
    kbALTL = 0x2600,
    kbALTM = 0x3200,
    kbALTN = 0x3100,
    kbALTO = 0x1800,
    kbALTP = 0x1900,
    kbALTQ = 0x1000,
    kbALTR = 0x1300,
    kbALTS = 0x1F00,
    kbALTT = 0x1400,
    kbALTU = 0x1600,
    kbALTV = 0x2F00,
    kbALTW = 0x1100,
    kbALTX = 0x2D00,
    kbALTY = 0x1500,
    kbALTZ = 0x2C00
};

// keyboard flag masks

enum mKbFlagMasks
{
    kbRSHIFT  = 0x01,
    kbLSHIFT  = 0x02,
    kbCTRLKEY = 0x04,
    kbALTKEY  = 0x08,
    kbSCRLOCK = 0x10,
    kbNUMLOCK = 0x20,
    kbCAPLOCK = 0x40,
    kbINS     = 0x80
};

// Keyboard device

class mKbDevice : public mDevice
{
   protected:

     char    extended;   // if set, use extended kb reads
     char    polled;     // flag - poll has occurred
     char    ctlpress;   // flag - ctl/alt/shift press
     char    insstate;   // insert state
     mEvent  theEvt;     // pending kb event

   public:

     mKbDevice( );
    ~mKbDevice( );

     virtual int     poll( int eventmask );
     virtual mEvent& read( void );

     int installed( void )        { return status; }
     int insert( void )           { return insstate; }
     void set_extended( int ext ) { extended = ext; }
     int  get_extended( void )    { return extended; }
};


//-------------------------------------------------------------//
//                      class mTmDevice                        //
//-------------------------------------------------------------//

// timer "key" types

enum mTmKeyTypes
{
   tmNULL     = 0x0000,   // no event
   tmALARM    = 0x0001    // timer expired
};

#define MAXCLIENTS 8

class mTmDevice : public mDevice
{
   protected:

     int     polled;               // flag - poll has occurred
     mEvent  theEvt;               // pending tm event
     int     iden[MAXCLIENTS];     // client identifier
     uint    nticks[MAXCLIENTS];   // length of timer interval
     long    tzero[MAXCLIENTS];    // timer start time

   public:

     mTmDevice( );
    ~mTmDevice( );

     virtual int     poll( int eventmask );
     virtual mEvent& read( void );

     void set( unsigned int nt, int id );
     void cancel( int id );
};


//-------------------------------------------------------------//
//                      stock keys                             //
//-------------------------------------------------------------//

mKey& StockKey( int which );

const int STOCKmsPRESS    =  0;
const int STOCKmsRELEASE  =  1;
const int STOCKmsDBLCLICK =  2;
const int STOCKmsDRAG     =  3;
const int STOCKkbESCAPE   =  4;
const int STOCKkbENTER    =  5;
const int STOCKkbUP       =  6;
const int STOCKkbDOWN     =  7;
const int STOCKkbLEFT     =  8;
const int STOCKkbRIGHT    =  9;
const int STOCKkbHOME     = 10;
const int STOCKkbEND      = 11;
const int STOCKkbPGUP     = 12;
const int STOCKkbPGDN     = 13;
#endif
