//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mDate.H                                             //
// Desc:   Date handling                                       //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MDATE_H_
#define _MDATE_H_

enum NumericDateOrders
{
   dMDY,
   dYMD,
   dDMY,
};

//-------------------------------------------------------------//
//                     Date Primitives                         //
//-------------------------------------------------------------//

char *   mDayOfWeek( int whichday, int abbreviate );
char * * mDaysOfWeek( void );
char *   mMonthOfYear( int whichmonth, int abbreviate );
char * * mMonthsOfYear( void );
char *   mSuffixedNumber( int number );
char *   mNumberSuffix( int number );
int      mDaysInMonth( int month );
int      mDaysInMonth( int month, int year );
int      mDaysInYear( int year );
int      mWeekDay( int year, int month, int day );
int      mDayOfYear( int year, int month, int day );
long     mEllapsedDays( int year, int month, int day );
void     mParseDateFormat( char * fmt, char * str,
                           int yr, int mo, int da );
int      mParseDateString( char * str, int * yr, int * mo,
                           int * da, int order=dMDY );

//-------------------------------------------------------------//
//                       class mDate                           //
//-------------------------------------------------------------//

class mDate
{
   public:

      short yr;
      short mo;
      short da;

   protected:

      char * tmp;

   public:

      mDate( );
      mDate( mDate& d );
      mDate( int y, int m, int d );
      virtual ~mDate( );

      //.....miscellaneous
      int isformatted( void ) { return tmp ? 1 : 0; }

      //.....formatted dates
      char * date( void );
      char * date( char * fmt );

      //.....numeric computation
      int  dayofweek( void );
      int  dayofyear( void );
      int  daysinyear( void );
      long dayofcentury( void );
      long dayofepoch( void );
      long operator - ( mDate& d );

      //.....assignment
      mDate& operator = ( mDate& d );

      //.....date comparison
      int operator == ( mDate& d );
      int operator <  ( mDate& d );
      int operator <= ( mDate& d );
      int operator >  ( mDate& d );
      int operator >= ( mDate& d );
};

//-------------------------------------------------------------//
//                       System Date                           //
//-------------------------------------------------------------//

mDate& mSystemDate( int recalc=0 );

#endif
