//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mCtlTxt.H                                           //
// Desc:   Control text label class                            //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MCTLTXT_H_
#define _MCTLTXT_H_

enum mControlTextTypes
{
   CTLTXT    = 0,
   HILOTXT   = 1,
   MATHTXT   = 2,
};

//-------------------------------------------------------------//

// Base class for control text labels.
// Note that pen.pst holds a text style, not a line style.

class mControlText
{
   protected:

      short  txt_type;
      mRect  bounds;   // bounding rectangle
      char  *text;
      mFont *font;
      mPen   pen;
      int    hjust;    // string horiz just

   public:

      mControlText( );
      mControlText( mRect r, char *txt, mFont *fnt, mPen pn );
      mControlText( mPoint p, char *txt, mFont *fnt, mPen pn );
      virtual ~mControlText( );

      virtual void draw( void );
      void erase( int clr );
      void move( mPoint p );
      void settext( char *txt );

      void    setfont( mFont *fnt )  { font = fnt; }
      void    setpen( mPen pn )      { pen = pn; }
      void    setbounds( mRect r )   { bounds = r; }
      void    setjust( int jst )     { hjust = jst; }

      char  * gettext( void )        { return text; }
      mFont * getfont( void )        { return font; }
      mPen    getpen( void )         { return pen; }
      mRect   getbounds( void )      { return bounds; }
      int     getjust( void )        { return hjust; }
};

//-------------------------------------------------------------//

// Text labels with highlighted chars, e.g., menu items

class mHiloCtlTxt : public mControlText
{
   protected:

      int toggle;   // char to signal switches

   public:

      mHiloCtlTxt( );
      mHiloCtlTxt( mRect r, char *txt, mFont *fnt, mPen pn, int tog );
     ~mHiloCtlTxt( ) { };

      virtual void draw( void );

      int gettoggle( void )      { return toggle; }
};

//-------------------------------------------------------------//

// Text items using a math font context

class mMathCtlTxt : public mControlText
{
   protected:

      mMathFontContext  * mfnt;
      mPoint              size;

   public:

      mMathCtlTxt( );
      mMathCtlTxt( mRect r, char *txt, mFont *lgfnt, mFont *smfnt,
                   mPen pn );
      virtual ~mMathCtlTxt( );
      virtual void draw( void );
      virtual void settext( char *txt );
};

#endif
