//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mCtlSym.H                                           //
// Desc:   Control symbol classes                              //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MCTLSYM_H_
#define _MCTLSYM_H_

enum mControlSymbolTypes
{
   CTLSYM        = 0,
   BOXSYM        = 1,
   DIAMONDSYM    = 2,
   CHECKBOXSYM   = 3,
   ARROWSYM      = 4,
   DBLARROWSYM   = 5,
   SCALESYM      = 6,
   DIVIDERSYM    = 7,
   MASKSYM       = 8,
   ICONSYM       = 9,
   ENTERSYM      = 10,
   XCTLSYM       = 11,
};

void SetCtlSymMonoColors( int style );

//-------------------------------------------------------------//

// Virtual base class for control symbols/labels

class mControlSymbol
{
   protected:

      short  sym_type;
      mRect  bounds;

   public:

      mControlSymbol( mRect r ) { bounds = r; sym_type = CTLSYM; }
      mControlSymbol( void ) { sym_type = CTLSYM; }
      virtual ~mControlSymbol( ) { }

      mRect getbounds( void )     { return bounds; }
      void  setbounds( mRect r )  { bounds = r; }

      virtual void draw( void ) = 0;
      virtual void move( mPoint p ) { bounds += p; }
      virtual void erase( int clr ) { mGdMgr::fillrect( bounds, clr ); }
};

//-------------------------------------------------------------//

// Box symbols, such as system menu button

#define csWIDEBOX    1
#define csTALLBOX    2
#define csSQUAREBOX  3

class mBoxCtlSym : public mControlSymbol
{
   protected:

      int type;

   public:

      mBoxCtlSym( mRect r, int bxtype );
      mBoxCtlSym( void );
      virtual ~mBoxCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Diamond symbol

class mDiamondCtlSym : public mControlSymbol
{
   public:

      mDiamondCtlSym( mRect r ) : mControlSymbol( r )
                   {  fixup(); sym_type = DIAMONDSYM;  }
      mDiamondCtlSym( void ) : mControlSymbol() { sym_type = DIAMONDSYM; }
      virtual ~mDiamondCtlSym( ) { }

      virtual void draw( void );
      void         fixup( void );
};

//-------------------------------------------------------------//

// Check box marker symbol

class mCheckBoxCtlSym : public mControlSymbol
{
   public:

      mCheckBoxCtlSym( mRect r );
      mCheckBoxCtlSym( void );
      virtual ~mCheckBoxCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Arrow symbols, such as win max/min buttons

class mArrowCtlSym : public mControlSymbol
{
   protected:

      int dir;

   public:

      mArrowCtlSym( mRect r, int adir );
      mArrowCtlSym( void );
      virtual ~mArrowCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Double Arrow symbols, such as win restore button

class mDblArrowCtlSym : public mControlSymbol
{
   protected:

      int dir;

   public:

      mDblArrowCtlSym( mRect r, int adir );
      mDblArrowCtlSym( void );
      virtual ~mDblArrowCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Scale with major/minor tick marks

class mScaleCtlSym : public mControlSymbol
{
   protected:

      int dir;           // orientation - H or V
      int majdiv;        // number of major subdivisions
      int mindiv;        // number of minor subdivisions

   public:

      mScaleCtlSym( mRect r, int adir, int nmaj, int nmin );
      mScaleCtlSym( void );
      virtual ~mScaleCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Menu divider lines

class mDividerCtlSym : public mControlSymbol
{
   protected:

      short type;

   public:

      mDividerCtlSym( mRect r, int dir = DIR_HORZ );
      mDividerCtlSym( void );
      virtual ~mDividerCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Single-color icons

class mMaskCtlSym : public mControlSymbol
{
   public:

      uchar *mask;
      int    color;

   public:

      mMaskCtlSym( mRect r, uchar *msk, int clr );
      mMaskCtlSym( mPoint p, int w, int h, uchar *msk, int clr );
      mMaskCtlSym( void );
      virtual ~mMaskCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Multi-color icons

class mIconCtlSym : public mControlSymbol
{
   public:

      uchar *pxls;
      uchar *vmask;
      int    ignore_clr;

   public:

      mIconCtlSym( mRect r, uchar *px, int iclr = -2 );
      mIconCtlSym( mPoint p, int w, int h, uchar *px, int iclr = -2 );
      mIconCtlSym( mPoint p, int w, int h, uchar *px, uchar *vmsk );
      mIconCtlSym( void );
      virtual ~mIconCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// Bent Arrow (Enter or Return) Symbol

class mEnterCtlSym : public mControlSymbol
{
   public:

      mEnterCtlSym( mRect r );
      mEnterCtlSym( void );
      virtual ~mEnterCtlSym( ) { }

      virtual void draw( void );
};

//-------------------------------------------------------------//

// "X" Symbol

class mXCtlSym : public mControlSymbol
{
   public:

      mXCtlSym( mRect r );
      mXCtlSym( void );
      virtual ~mXCtlSym( ) { }

      virtual void draw( void );
};

#endif
