//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mCtlRgn.H                                           //
// Desc:   Control Region class definitions                    //
// Date:   Dec, 1991                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MCTLRGN_H_
#define _MCTLRGN_H_

// type of control regions
enum mControlRegionTypes
{
   CTLRGN     = 0,
   RGNBDR     = 1,
   RGNRECT    = 2,
   RGNDIAMOND = 3,
   RGNBOX     = 4,
   RGNTILE    = 5,
   RGNHEXAGON = 6,
   RGNSLOT    = 7,
};


//-------------------------------------------------------------//
//                         miscellaneous                       //
//-------------------------------------------------------------//

mRect GetRegionExtent( mRect r, int bdrtype );

//-------------------------------------------------------------//
//                     mControlRegion base class               //
//-------------------------------------------------------------//

// This is an abstract base class for the "Control Region"
// type.  This type consists of a geometric shape (e.g., rect)
// with a border pen and a fill brush.

class mControlRegion
{
   protected:

      short   rgn_type;     // type of control region
      mPen    bdrpen;       // pen for border
      mBrush  fillbrush;    // brush for fill
      mRect   bounds;       // bounding rectangle
      short   state;        // state - inset or outset

   public:

      mControlRegion( mRect bnd );
      mControlRegion( void );
      virtual ~mControlRegion( ) { }

      virtual void  fillint( void );
      virtual void  drawbdr( void );
      virtual void  draw( );
      virtual void  invert( void );
      virtual void  press( void );
      virtual void  erase( int );
      virtual void  move( mPoint p );
      virtual int   ptinborder( mPoint p );
      virtual int   ptinregion( mPoint p );
      virtual mRect interior( int which=0 );

      short   getstate( void )       { return state; }
      mPen    getpen( void )         { return bdrpen; }
      mBrush  getbrush( void )       { return fillbrush; }
      mRect   getbounds( void )      { return bounds; }

      void    setpen( mPen pn )      { bdrpen = pn; }
      void    setbrush( mBrush br )  { fillbrush = br; }
      void    setbounds( mRect b )   { bounds = b; }
};


//-------------------------------------------------------------//
//                     mRgnRect class                          //
//-------------------------------------------------------------//

// a rectangular region

class mRgnRect : public mControlRegion
{
   public:

      mRgnRect( mRect r ) : mControlRegion( r ) { rgn_type = RGNRECT; }
      mRgnRect( void ) : mControlRegion()       { rgn_type = RGNRECT; }
      virtual ~mRgnRect( ) { }
};


//-------------------------------------------------------------//
//                     mRgnSlot class                          //
//-------------------------------------------------------------//

// a rectangular slot

class mRgnSlot : public mControlRegion
{
   public:

      mRgnSlot( mRect r );
      mRgnSlot( void ) : mControlRegion()       { rgn_type = RGNSLOT; }
      virtual ~mRgnSlot( ) { }
};


//-------------------------------------------------------------//
//                     mRgnBorder class                        //
//-------------------------------------------------------------//

// a bordered region

class mRgnBorder : public mControlRegion
{
   protected:

      short ridgethk;

   public:

      mRgnBorder( mRect r ) : mControlRegion( r )
         { ridgethk=5; rgn_type = RGNBDR; }
      mRgnBorder( mRect r, short thk ) : mControlRegion( r )
         { ridgethk=thk; rgn_type = RGNBDR; }
      mRgnBorder( void ) : mControlRegion() { rgn_type = RGNBDR; }
      virtual ~mRgnBorder( ) { }

      virtual void  fillint( void );
      virtual void  drawbdr( void );
      virtual mRect interior( int which=0 );
};


//-------------------------------------------------------------//
//                     mRgnDiamond class                       //
//-------------------------------------------------------------//

// a bordered diamond - requires a square rectangle

class mRgnDiamond : public mControlRegion
{
   public:

      mRgnDiamond( mRect r ) : mControlRegion( r )
                  { fixup(); rgn_type = RGNDIAMOND; }
      mRgnDiamond( void ) : mControlRegion()  { rgn_type = RGNDIAMOND; }
      virtual ~mRgnDiamond( ) { }

      virtual void fillint( void );
      virtual void drawbdr( void );
      virtual void draw( void );
      virtual void invert( void );
      virtual void press( void );
      virtual void erase( int clr );
      virtual int  ptinborder( mPoint p );
      virtual int  ptinregion( mPoint p );
      void         fixup( void );
};


//-------------------------------------------------------------//
//                       mRgnBox class                         //
//-------------------------------------------------------------//

// a grooved box - used to visually enclose groups of controls

class mRgnBox : public mControlRegion
{
   public:

      mRgnBox( mRect r ) : mControlRegion( r )
         { rgn_type = RGNBOX; }
      mRgnBox( void ) : mControlRegion() { rgn_type = RGNBOX; }
      virtual ~mRgnBox( ) { }

      virtual void  fillint( void );
      virtual void  drawbdr( void );
      virtual mRect interior( int which=0 );
      virtual void  press( void );
};


//-------------------------------------------------------------//
//                       mRgnTile class                        //
//-------------------------------------------------------------//

// multiple tiles in a single rectangular region

class mRgnTile : public mControlRegion
{
   protected :

      short  nrgn;
      mRect *rgn;

      void inith( mRect r, int tsum, int nt, int *tw );
      void initv( mRect r, int tsum, int nt, int *tw );

   public :

      mRgnTile( );
      mRgnTile( mRect r, int layout, int nt, int *tw );
      virtual ~mRgnTile( );

      virtual void  fillint( void );
      virtual void  drawbdr( void );
      virtual void  move( mPoint p );
      virtual void  press( void );
      virtual int   ptinregion( mPoint p );
      virtual mRect interior( int which=0 );
};


//-------------------------------------------------------------//
//                      mRgnHexagon class                      //
//-------------------------------------------------------------//

class mRgnHexagon : public mControlRegion
{
   protected :

      mPoint  origin;
      short   radius;

   public :

      mRgnHexagon( mPoint org, int rad );
      mRgnHexagon( void );
      virtual ~mRgnHexagon( ) { }

      virtual void draw( void );
};

#endif
