//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mCalendr.H                                          //
// Desc:   File-Based Calendar Info                            //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MCALENDR_H_
#define _MCALENDR_H_

//-------------------------------------------------------------//
//                           mCalHeader                        //
//-------------------------------------------------------------//

struct mCalHeader
{
   unsigned short id;         // 0x4341 = 'CA'
   unsigned short ver;        // 10
   unsigned short maxdates;   // date table size
   unsigned short cntdates;   // slots in use
   unsigned short nlines;     // lines per entry
   unsigned short nchars;     // chars per line

   mCalHeader( );
  ~mCalHeader( );

   int read( FILE * f );
   int write( FILE * f );
};

//-------------------------------------------------------------//
//                           mCalFile                          //
//-------------------------------------------------------------//

class mCalFile
{
   protected:

      int           stat;           // file status
      char *        cpath;          // currently open file
      FILE *        cfile;          //     "      "    "
      mCalHeader    calhdr;         // header from file
      long *        datelist;       // date list from file
      int           curindx;        // index into datelist
      mDate         curdate;        // date instance from index
      char * *      curtext;        // text for curdate

      void readentry( int which );
      void writeentry( int which );

   public:

      mCalFile( char * filepath );
     ~mCalFile( );

      int status( void )
      {
         return stat;
      }
      mDate& date( void )
      {
         return curdate;
      }
      int nchars( void )
      {
         return calhdr.nchars;
      }
      int nlines( void )
      {
         return calhdr.nlines;
      }
      char * title( void )
      {
         return curdate.date();
      }
      char ** lines( void )
      {
         return curtext;
      }
      char * get( int which );
      void put( int which, char * txt );

      int test( int yr, int mo, int da );
      int find( int yr, int mo, int da );
      int save( void );
      int del( void );
};

#endif
