//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mBitFont.H                                          //
// Desc:   Intrinsic Bitmapped Font Class                      //
// Date:   Dec, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MBITFONT_H_
#define _MBITFONT_H_

//-------------------------------------------------------------//
//                       class mBitFont                        //
//-------------------------------------------------------------//

class mBitFont : public mFont
{
   protected:

      short       ch_cnt;    // allocated Character cnt
      mCharacter  *ch;       // allocated Character array

   public:

      mBitFont( int chmin, int chmax );
      virtual ~mBitFont( );

      // parameter read functions
      mCharacter *   getchr( short which );
      virtual short  charwidth( short c );
      virtual short  stringwidth( char *str, short xclude=0 );
      virtual mPoint stringsize( char *str, short xclude=0 );
      virtual mRect  stringrect( mPoint pnt, char *str, short xclude=0 );

      // text drawing functions - point based
      virtual mPoint drawchar( mPoint p, short c );
      virtual mPoint drawstring( mPoint p, char *str );
      virtual mPoint drawbdrstr( mPoint p, char *str, mPen pn, int ioset=rgnOUTSET );
      virtual mPoint drawhilostr( mPoint p, char *str, mPen pn, short toggle );

      // text drawing functions - rect based
      virtual mPoint drawchar( mRect r, short c );
      virtual mPoint drawstring( mRect r, char *str );
      virtual mPoint drawbdrstr( mRect r, char *str, mPen pn, int ioset=rgnOUTSET );
      virtual mPoint drawhilostr( mRect r, char *str, mPen pn, short toggle );

   protected:

      void drawhilo( mPoint q, mCharacter *cp, mPen pn, int high );
};

#endif
