//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mArray.H                                            //
// Desc:   Memory storage classes                              //
// Date:   Nov, 1992                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MARRAY_H_
#define _MARRAY_H_

//-------------------------------------------------------------//
//                      various constants                      //
//-------------------------------------------------------------//

enum mArrayTypes
{
   arrNONE  = 0x0000,
   arrANY   = 0x000F,
   arrCNV   = 0x0001,
   arrDSK   = 0x0002,
   arrEMS   = 0x0004,
   arrXMS   = 0x0008
};

enum mArrayStatus
{
   arrOKAY,
   arrNOMEM,
   arrNODRVR,
   arrNODISK
};

//-------------------------------------------------------------//
//                    the base class                           //
//-------------------------------------------------------------//

class mArray
{
   public:
      int status;     // array status code
      int flags;      // for the app's use

   protected:
      int rowcnt;     // row count
      int colcnt;     // column count
      int itmbytes;   // bytes per item
      int rowbytes;   // bytes per row

   public:
      mArray( int nrows, int ncols, int nbytes )
      {
         status = arrOKAY;
         flags = 0;
         rowcnt = nrows;
         colcnt = ncols;
         itmbytes = nbytes;
         rowbytes = itmbytes * colcnt;
      }
      virtual ~mArray( )
      {
      }
      virtual void put( unsigned char *data, int row ) = 0;
      virtual unsigned char *get( int row ) = 0;
      virtual void cpy( unsigned char *dest, int row ) = 0;
      virtual void cpy( unsigned char *dest, int row,
                        int col, int cnt ) = 0;
      int  width( void )     { return colcnt; }
      int  height( void )    { return rowcnt; }
      int  depth( void )     { return itmbytes; }
      void depth( int ib )   { itmbytes = ib; }
      int  scanbytes( void ) { return rowbytes; }
};

//-------------------------------------------------------------//
//                  conventional memory                        //
//-------------------------------------------------------------//

class mCnvArray : public mArray
{
   protected:
      unsigned char **rowptrs;

   public:
      mCnvArray( int nrows, int ncols, int nbytes );
      virtual ~mCnvArray( );
      virtual void put( unsigned char *data, int row );
      virtual unsigned char *get( int row );
      virtual void cpy( unsigned char *dest, int row );
      virtual void cpy( unsigned char *dest, int row,
                        int col, int cnt );
};

#ifdef __HIGHC__
// EMS and XMS memory not supported in protected mode
#else
#ifdef __WATCOMC__
// EMS and XMS memory not supported in protected mode
#else
#ifdef DOS386
// EMS and XMS memory not supported in protected mode
#else
#ifdef DOS16RM
// EMS and XMS memory not supported in protected mode
#else

//-------------------------------------------------------------//
//                     ems memory                              //
//-------------------------------------------------------------//

class mEmsArray : public mArray
{
   protected:
      int handle;     // EMS handle
      int npages;     // number of alloc'd pages
      int phypage;    // physical page used
      int blkcnt;     // rows per 16K page
      int blklen;     // padded row length
      char *pgframe;  // pointer to physical page

   public:
      mEmsArray( int nrows, int ncols, int nbytes );
      virtual ~mEmsArray( );
      virtual void put( unsigned char *data, int row );
      virtual unsigned char *get( int row );
      virtual void cpy( unsigned char *dest, int row );
      virtual void cpy( unsigned char *dest, int row,
                        int col, int cnt );
};

//-------------------------------------------------------------//
//                     xms memory                              //
//-------------------------------------------------------------//

class mXmsArray : public mArray
{
   protected:
      unsigned handle;     // xms handle
      int blklen;          // padded row length
      char *buffer;        // cnv mem buffer
      XMSmovestruct c2x;   // for move to xms
      XMSmovestruct x2c;   // for move to cnv

   public:
      mXmsArray( int nrows, int ncols, int nbytes );
      virtual ~mXmsArray( );
      virtual void put( unsigned char *data, int row );
      virtual unsigned char *get( int row );
      virtual void cpy( unsigned char *dest, int row );
      virtual void cpy( unsigned char *dest, int row,
                        int col, int cnt );
};

#endif
#endif
#endif
#endif

//-------------------------------------------------------------//
//                     disk memory                             //
//-------------------------------------------------------------//

class mDskArray : public mArray
{
   protected:
      FILE *fstor;      // file pointer
      int blklen;       // padded row length
      char *buffer;     // cnv mem buffer

   public:
      mDskArray( int nrows, int ncols, int nbytes );
      virtual ~mDskArray( );
      virtual void put( unsigned char *data, int row );
      virtual unsigned char *get( int row );
      virtual void cpy( unsigned char *dest, int row );
      virtual void cpy( unsigned char *dest, int row,
                        int col, int cnt );
};

//-------------------------------------------------------------//
//                    related functions                        //
//-------------------------------------------------------------//

mArray *create_marray( int rows, int cols, int bytes, int type );

#endif
