//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   mAnimatn.H                                          //
// Desc:   Animation stuff                                     //
// Date:   Dec, 1993                                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#ifndef _MANIMATN_H_
#define _MANIMATN_H_

//-------------------------------------------------------------//
//                         class mBackDrop                     //
//-------------------------------------------------------------//

class mBackDrop
{
   public:

      mRect     saveR;
      mRect     restR;
      int       err;
      int       wid;
      int       hgt;
      int       siz;
      char *    save;
      char * *  savep;
      char *    rest;
      char * *  restp;

      mBackDrop( mRect& ar );
     ~mBackDrop( );

      void xshift( int ncols );
      void yshift( int nrows );

      void copys2r( void );

      void savetop( int nrows );
      void savebot( int nrows );
      void saveleft( int ncols );
      void saveright( int ncols );

      void resttop( int rrows );
      void restbot( int rrows );
      void restleft( int ncols );
      void restright( int ncols );
};

//-------------------------------------------------------------//
//                         class mMaskOb                       //
//-------------------------------------------------------------//

class mMaskOb
{
   public:

      mPoint  origin;
      int     width;
      int     height;
      uchar * fgmask;
      uchar * bgmask;
      uchar * vismask;
      int     fgcolor;
      int     bgcolor;

   mMaskOb( mPoint& org, int w, int h, uchar * fgm,
            uchar *bgm, int fgc, int bgc );
  ~mMaskOb( );
   void draw( void );
   void move( int dx, int dy )
   {
      origin.x += dx;
      origin.y += dy;
   }
   void move( mPoint& p )
   {
      origin = p;
   }
   mRect rect( void )
   {
      return mRect( origin.x,         origin.y,
                    origin.x+width-1, origin.y+height-1 );
   }
};

//-------------------------------------------------------------//
//                         class mIconOb                       //
//-------------------------------------------------------------//

class mIconOb
{
   public:

      mPoint  origin;
      int     width;
      int     height;
      uchar * mask;
      uchar * vismask;

   mIconOb( mPoint& org, int w, int h, uchar * msk, uchar * vmsk );
  ~mIconOb( );
   void draw( void );
   void move( int dx, int dy )
   {
      origin.x += dx;
      origin.y += dy;
   }
   void move( mPoint& p )
   {
      origin = p;
   }
   mRect rect( void )
   {
      return mRect( origin.x,         origin.y,
                    origin.x+width-1, origin.y+height-1 );
   }
};

//-------------------------------------------------------------//
//                         Dragging                            //
//-------------------------------------------------------------//

typedef void (*mPatch)( mRect& oldR, mRect& newR, mRect& orgR );

void mInitDragRect( mRect& iR, mPatch patch );
void mInitDragRect( mRect& iR, char * under );
void mInitDragRect( mMaskOb * mskob, mPatch patch );
void mInitDragRect( mIconOb * icnob, mPatch patch );
void mDragRect( int dx, int dy );
void mTermDragRect( void );
void mLimitDrag( mWindow * wn, mPoint& mp, mRect& dgr );
void mLimitDrag( mWindow * wn );

//-------------------------------------------------------------//
//                         random stuff                        //
//-------------------------------------------------------------//

mRect mRandomRect( mRect& area, mRect& sample );

#endif
