//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp9.Cpp                                         //
// Desc:   Sample Program 9 - Spin Buttons                     //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.H"

//----------------------------------------------------------
// data for a "planet" spin button

static char *planets[] =
{
   "Mercury",
   "Venus",
   "Earth",
   "Mars",
   "Jupiter",
   "Saturn",
   "Uranus",
   "Neptune",
   "Pluto",
};

#define NPLANETS ( sizeof(planets) / sizeof(char *) )

static int cur_planet = 0;

char * planet_selector( int which, void * ctldata )
{
   switch( which )
   {
      case mNEXT :
           cur_planet++;
           if( cur_planet >= NPLANETS ) cur_planet = 0;
           break;
      case mPREVIOUS :
           cur_planet--;
           if( cur_planet < 0 ) cur_planet = NPLANETS-1;
           break;
   }
   return planets[cur_planet];
}

//----------------------------------------------------------
// data for a "temperature" spin button

static int  cur_temp = 32;

static char temp_str[8];

char * temperature_selector( int which, void *ctldata )
{
   switch( which )
   {
      case mNEXT :
           if( cur_temp < 212 )
              cur_temp++;
           break;
      case mPREVIOUS :
           if( cur_temp > 32 )
              cur_temp--;
           break;
   }
   sprintf( temp_str, "%3d", cur_temp );
   return temp_str;
}

//-------------------------------------------------------------//

int main( void )
{
    SetDefaultPalette( pBordeaux );
    mWindowManager WM;

    // Create the window
    mWindow wn( "Spin Buttons", 0, &WM.systemfont(),
                 400, 250, wBDRSIZABLE );

    // create the controls
    wn <<  *( new mWnCtlSpinBut( mRect( 100, 50, 250, 75 ),
                                 WM.getsysfont(),
                                 "Planet",
                                 planet_selector ) );

    wn <<  *( new mWnCtlSpinBut( mRect( 100, 125, 250, 150 ),
                                 WM.getsysfont(),
                                 "Temperature (F)",
                                 temperature_selector ) );

    // attach the window
    WM << wn;

    // process the window
    WM.run();

    return 0;
}
