//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp8.Cpp                                         //
// Desc:   Sample Program 8 - Scrollable List                  //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.h"

//-------------------------------------------------------------//

char *items[] =
{
   "Aspen",
   "Boulder",
   "Castlerock",
   "Denver",
   "Eldora",
   "Fort Collins",
   "Grand Junction",
   "Keystone",
   "Leadville",
   "Montrose",
   "Nederland",
   "Ouray",
   "Steamboat",
   "Telluride",
   "Vail",
   "Ward",
};

#define NITEMS ( sizeof(items) / sizeof(char *) )

//-------------------------------------------------------------//

// This task draws the current item's text beside the control

int list_task( mMsg& msg, mWnControl& ctl )
{
   if( (msg.verb == mENDDRAW) || (msg.verb == msPRESS) ||
       (msg.verb == msDBLCLICK) )
   {
      mWnCtlTextList *lst = (mWnCtlTextList *) ((void *) &ctl);
      mWnControl *apr = ctl.prev;
      mFont *fnt = ctl.getwind()->getwnfont();
      mRect r = apr->getnodes()->rgn->interior();
      mGdMgr::fillrect( r, 5 );
      fnt->drawstring( r, lst->getcuritemtext() );
   }
   return 0;
}

//-------------------------------------------------------------//

int main( void )
{
    SetDefaultPalette( 8 );
    mWindowManager WM;

    // Create the window
    mWindow wn( "Scrollable List Control", 0, &WM.systemfont(),
                 400, 250, wBDRSIZABLE );

    // create an aperture to display list selection
    mRect r( 215, 170, 350, 195 );
    mWnCtlAperture apr( r );

    // create the list control
    mRect rList( 50,  50, 175, 200 );
    mRect rSBar( 177,  50, 197, 200 );
    mWnCtlTextList lst( rList, rSBar, &WM.systemfont(), items, NITEMS );
    lst.setstyle( xPOSTDRAW, 1 );
    lst.settask( list_task );

    // attach the controls - note that the list task
    // assumes the implied order of attachment here...
    wn << apr << lst;

    // attach the window
    WM << wn;

    // process the window
    WM.run();

    return 0;
}
