//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp7.Cpp                                         //
// Desc:   Sample Program 7 - Edit Field Validation            //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.H"

//-------------------------------------------------------------//

int field_task( mMsg& msg, mWnControl& ctl )
{
    // get pointer to the field
    mWnCtlField *fld = (mWnCtlField *) ((void *) &ctl);

    // ENTER, ESCAPE, etc. causes a mTERM message.
    // The key value is saved in parameter 0.
    if( (msg.verb == mTERM) && (msg.param[0] == kbENTER) )
    {
       mWindowManager *wm = fld->getwind()->getwnmgr();
       char  buf[16];
       // apply_mask returns nonzero on success
       if( apply_mask( buf, fld->get(), "###-###-####" ) )
       {
          fld->put( buf );
          // This forces a redraw
          (*fld) << mMsg(mCONTROL,mEND);
       }
       else
       {
           *wm << *notify( &wm->systemfont(), "Error!",
                           "Field format is invalid" );
           // ALWAYS RETURN NONZERO FROM A TASK WHEN
           // IT OPENS A NEW WINDOW, AS IS DONE HERE!!!
           return 1;
       }
    }
    return 0;
}

//-------------------------------------------------------------//

int main( void )
{
    SetDefaultPalette( 8 );
    mWindowManager WM;

    // Create the window
    mWindow wn( "Edit Field Validation", 0, &WM.systemfont(),
                 400, 250, wBDRSIZABLE );

    // Create an edit field
    mRect r( 190, 150, 300, 170 );
    mWnCtlField fld( r,                  // display aperture
                     &WM.systemfont(),   // font
                     "Telephone",        // field label
                     12 );               // number of chars

    // set the task
    fld.settask( field_task );

    // attach the control
    wn << fld;

    // attach the window
    WM << wn;

    // process the window
    WM.run();

    return 0;
}
