//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp4.Cpp                                         //
// Desc:   Sample Program 4 - Advanced Menu Example            //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.h"

//-------------------------------------------------------------//

// A typical main menu definition.

char *main_menu_labels[] =
{
   "~F~iles",                  // The tilda ( ~ ) is a "toggle"
   "~E~dit",                   // character that turns character
   "~O~ptions",                // highlighting on and off within
   "~Q~uit"                    // a string.
};

mKey main_menu_keys[] =
{
   mKey( kbALPHANUM, 'F', 0 ),    // These are the accelerator
   mKey( kbALPHANUM, 'E', 0 ),    // key definitions for each
   mKey( kbALPHANUM, 'O', 0 ),    // menu item.
   mKey( kbALPHANUM, 'Q', 0 ),
};

#define NMAIN ( sizeof(main_menu_labels) / sizeof(char *) )
mMenuDef main_menu( main_menu_labels,  // array of labels
                    main_menu_keys,    // array of accel keys
                    NMAIN,             // number of items
                    '~' );             // the toggle character

//-------------------------------------------------------------//

// An Edit Submenu

char *edit_menu_labels[] =
{
   "~A~dd",
   "~C~hange...",
   "~D~elete",
   "~U~ndo"
};

mKey edit_menu_keys[] =
{
   mKey( kbALPHANUM, 'A', 0 ),
   mKey( kbALPHANUM, 'C', 0 ),
   mKey( kbALPHANUM, 'D', 0 ),
   mKey( kbALPHANUM, 'U', 0 ),
};

#define NEDIT ( sizeof(edit_menu_labels) / sizeof(char *) )
mMenuDef edit_menu( edit_menu_labels,
                    edit_menu_keys,
                    NEDIT,
                    '~' );

// An Edit Submenu SubMenu

char *esub_menu_labels[] =
{
   "~O~ne",
   "~M~any",
   "~A~ll"
};

mKey esub_menu_keys[] =
{
   mKey( kbALPHANUM, 'O', 0 ),
   mKey( kbALPHANUM, 'M', 0 ),
   mKey( kbALPHANUM, 'A', 0 ),
};

#define NESUB ( sizeof(esub_menu_labels) / sizeof(char *) )
mMenuDef esub_menu( esub_menu_labels,
                    esub_menu_keys,
                    NESUB,
                    '~' );

//-------------------------------------------------------------//

// A task for the esub_menu submenu.  This just notifies
// the user of his choice.

static char m[80];
static char *t = "Note:";

int esub_menu_task( mMsg& msg, mWnControl& ctl )
{
   int item = msg.param[0];
   if( (msg.verb == mSELECT) && (item > 0) )
   {
       sprintf( m, "You selected item %d", item );
      (*ctl.getwind()->getwnmgr()) <<
      (*notify( ctl.getwind()->getwnfont(), t, m ));
      return 1;
   }
   return 0;
}

//-------------------------------------------------------------//

// A task for the main menu control.  This is called for
// every event processed by the menu control.  You would
// normally want to do something only when the user selects
// an item, which is indicated by the message verb.

int my_main_menu_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mSELECT )
   {
      int item = msg.param[0];
      // in this example, only "Quit" does something
      switch( item )
      {
         case 1 : // Files
         case 2 : // Edit
         case 3 : // Options
                  break;
         case 4 : // Quit
                  mWindowManager *wm = ctl.getwind()->getwnmgr();
                  (*wm) << mMsg( mMANAGER, mCLOSE );
                  return 1;
      }
   }
   return 0;
}

//-------------------------------------------------------------//

int main( void )
{
    // instantiate a window manager
    mWindowManager WM;

    // instantiate a window
    mWindow wn( "Menu Example",      // window title
                &main_menu,          // pointer to menu def
                &WM.systemfont(),    // pointer to a font
                400, 250,            // window initial dimensions
                wBDRSIZABLE );       // window border type

    // set the task for the main menu control
    wn.getwnmenu()->settask( my_main_menu_task );

    // "attach" the window to the window manager
    WM << wn;

    // get window's main menu
    mWnCtlBarMenu *mm = wn.getwnmenu();

    // now build submenu hierarchy
    mWnCtlBoxMenu *edit = new mWnCtlBoxMenu( &WM.systemfont(),
                                             &edit_menu );
    mm->setpulldown( edit, 2 );
    mWnCtlBoxMenu *esub = new mWnCtlBoxMenu( &WM.systemfont(),
                                             &esub_menu );
    edit->setpulldown( esub, 2 );
    esub->settask( esub_menu_task );

    // process the window
    WM.run();

    return 0;
}
