//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp3.Cpp                                         //
// Desc:   Sample Program 3 - Multiple Windows                 //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.h"

int main( void )
{
    // instantiate a window manager
    mWindowManager *WM = new mWindowManager;

    // instantiate some windows
    mWindow wn1( "Window 1",         // window title
                0,                   // pointer to menu def
                &WM->systemfont(),   // pointer to a font
                400, 250,            // window initial dimensions
                wBDRSIZABLE );       // window border type
    wn1.setwnorigin( mPoint(50, 150) );

    mWindow wn2( "Window 2",
                0,
                &WM->systemfont(),
                400, 250,
                wBDRSIZABLE );
    wn2.setwnorigin( mPoint(100, 100) );

    mWindow wn3( "Window 3",
                0,
                &WM->systemfont(),
                400, 250,
                wBDRSIZABLE );
    wn3.setwnorigin( mPoint(150, 50) );

    // "attach" the windows to the window manager
    *WM << wn1 << wn2 << wn3;

    // process the window
    WM->run();

    // if created with new, the window manager must be explicitly
    // deleted to force a required destructor call.
    delete WM;

    return 0;
}
