//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP24.CPP                                        //
// Desc:   Toolbar Example...                                  //
// Vers:   Menuet/C++ 1.x                                      //
//-------------------------------------------------------------//
// NOTE: This example tries to link in many of the built-in    //
//       dialogs and files may become too large to run in real //
//       mode DOS applications.  It is recommended that only 1 //
//       or 2 of the built-in dialogs are linked in at a time  //
//       to avoid memory problems.                             //
//-------------------------------------------------------------//

#include "mstdhdr.h"

//...............text for warning dialog
static char *warning_title = "WARNING!";
static char *warning_text[] =
{
   "This is the warning dialog.",
   "A Notify Dialog is a special",
   "case of this dialog.",
};
static mTextPg warning_tp( warning_title, warning_text, 3 );

//...............text for query dialog
static char *query_title = "QUERY!";
static char *query_text[] =
{
   "This is a Query Dialog.",
   "Is that Okay?",
};
static mTextPg query_tp( query_title, query_text, 2 );

//...............values for file dialog
static char file_filename[128] = "";
static char file_filepath[128] = "*.*";
static char *file_filetypes[] =
{
   "*.*", "*.cpp", "*.h", "*.obj", "*.exe", "*.bak"
};
static int file_nfiletypes = 6;

//...............special fonts
mFont *lgFnt = 0;
mFont *smFnt = 0;

//-------------------------------------------------------------------------//
// Callback task for the dialog icons...                                   //
//-------------------------------------------------------------------------//
static int DialogIconTask( mMsg& msg, mWnControl& ctl )
{
   if ( msg.verb == mENDEXECUTE )
   {
      mWindowManager *wm = ctl.getwind()->getwnmgr();
      mFont *sysfnt = &wm->systemfont();
      switch( ctl.tag )
      {
         case 0  :  // Clock
            *wm << *create_clock_window( sysfnt );
            return 1;
         case 1  :  // Calculator 1
            *wm << *create_calc_window( sysfnt );
            return 1;
         case 2  :  // Calculator 2
            *wm << *create_scientific_calc_window( lgFnt, smFnt, 0 );
            return 1;
         case 3  :  // Calendar 1
            *wm << *create_calendar_window( lgFnt, smFnt, 0 );
            return 1;
         case 4  :  // Nothing Currently
            return 1;
         case 5  :  // File Box
            *wm << *create_file_window( sysfnt, "File Dialog",
                                  file_filepath, file_filename,
                                  file_filetypes, file_nfiletypes,
                                  0, 0 );
            return 1;
         case 6  :  // Palette Selector
            *wm << *create_palette_window( sysfnt );
            return 1;
         case 7  :  // Palette Editor
            *wm << *create_paledit_window( sysfnt );
            return 1;
         case 8  :  // Eyes
            *wm << *create_eyes_window( *wm );
            return 1;
         case 9  :  // Query
            *wm << *create_query_window( sysfnt, &query_tp, 0 );
            return 1;
         case 10 :  // Warning
            *wm << *create_warning_window( sysfnt, &warning_tp );
            return 1;
      }
   }
   return 0;
}

//-------------------------------------------------------------------------//
// Initialize the toolbars for the main window                             //
//-------------------------------------------------------------------------//
static void init_toolbars( mWindow *win )
{
   // Open the icon file: MNSAMP24.ICN
   mIconType1File *iconf = new mIconType1File( "MNSAMP24.ICN", arrCNV );
   if ( iconf == NULL )
      return;
   int iwidth  = iconf->width();
   int iheight = iconf->height();

   // add the toolbars to the window
   win->addtoolbar( mTlbTOP, iheight+6 );
   win->addtoolbar( mTlbBOTTOM, 20 );
   win->addtoolbar( mTlbLEFT, iwidth+7 );

   // get pointers to the toolbar controls
   mWnCtlToolBar *ttb = (mWnCtlToolBar *)win->getsyscontrol( wcTOOLBAR );
   mWnCtlToolBar *btb = (mWnCtlToolBar *)ttb->next;
   mWnCtlToolBar *ltb = (mWnCtlToolBar *)btb->next;

   // Add the icons to the top toolbar
   mRect tbe( ttb->extent() );
   int dim = tbe.dely();
   mRect cr( tbe.xmin+1, tbe.ymin+1, tbe.xmin+dim-1, tbe.ymin+dim-1 );
   mWnCtlButton *but;
   for( int i=0; i<11; i++ )
   {
      but = new mWnCtlButton( cr, 0, 0 );
      but->tag = i;
      but->settask( DialogIconTask );
      cr >>= 2;
      but->getnodes()->sym = new mIconCtlSym( cr, iconf->map( i ) );
      cr <<= 2;
      *ttb << *but;
      cr += mPoint( dim, 0 );
   }

   // Add the icons to the left toolbar
   tbe = ltb->extent();
   dim = tbe.delx();
   cr.xmin = tbe.xmin + 1;
   cr.ymin = tbe.ymax - dim + 2;
   cr.xmax = cr.xmin + dim - 3;
   cr.ymax = cr.ymin + dim - 3;
   for( i=0; i<7; i++ )
   {
      but = new mWnCtlButton( cr, 0, 0 );
      cr >>= 2;
      but->getnodes()->sym = new mIconCtlSym( cr, iconf->map( 11+i ) );
      cr <<= 2;
      *ltb << *but;
      cr -= mPoint( 0, dim-2 );
   }
}

//-------------------------------------------------------------------------//
// Main 'C++' routine...                                                   //
//-------------------------------------------------------------------------//
int main( void )
{
   mWindowManager *WM = new mWindowManager;
   mFont *sysfnt = &WM->systemfont();

   // load the special fonts
   lgFnt = new mHpFont( "SYS15L.HP", 32, 127 );
   smFnt = new mHpFont( "SYS08N.HP", 32, 127 );

   mWindow *wn = new mWindow( "Toolbars, icons, and Dialogs", 0,
                           sysfnt, 420, 346, wBDRFIXED, wcSYSMENU );
   wn->setstyle( yDESTROY, 1 );
   init_toolbars( wn );

   *WM << *wn;

   WM->run();

   delete WM;

   return 0;
}
