//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP23.CPP                                        //
// Desc:   Music Package Test                                  //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.h"

char *song_titles[] =
{
   "Star Trek",
   "Good, Bad, Ugly",
   "Bach's Toccata",
   "Entertainer",
   "New World",
   "Bike For Two",
   "Polovetzian",
   "Danny Boy",
   "Good King",
   "Santa Lucia",
   "Star Wars",
};

char *sound_effects_titles[] =
{
   "Alarm",
   "Bleep",
   "Telephone",
   "Random Pitch",
   "Random Pitch Count",
   "Tick",
   "For Horn",
   "Car Horn",
   "Bird",
   "Falling",
   "Thud",
};

int SongButtonTask( mMsg& msg, mWnControl& ctl )
{
   if ( msg.verb == mENDEXECUTE )
   {
      mWnCtlTextComboBox *cb = (mWnCtlTextComboBox *)ctl.prev;
      int song_index = cb->getcuritem();
      mSong *song = mGetTheme( song_index );
      song->play();
   }
   return 0;
}

int SoundButtonTask( mMsg& msg, mWnControl& ctl )
{
   if ( msg.verb == mENDEXECUTE )
   {
      mWnCtlTextComboBox *cb = (mWnCtlTextComboBox *)ctl.prev;
      int sound_index = cb->getcuritem();
      SoundEffect( sound_index );
   }
   return 0;
}

int main( void )
{
   mWindowManager *WM = new mWindowManager;
   mFont *sysfnt = &WM->systemfont();

   mWindow *wn = new mWindow( "Music Package Sample", 0, sysfnt,
                              460, 160, wBDRFIXED, wcSYSMENU );

   mRect r( 20, 80, 260, 100 );
   mWnCtlTextComboBox *cb = new mWnCtlTextComboBox( r, sysfnt,
                "Songs", song_titles, 11, butUPDOWN|butVERTICAL );
   *wn << *cb;
   r.set( 80, 45, 180, 65 );
   mWnCtlButton *but = new mWnCtlButton( r, sysfnt, "Play" );
   but->settask( SongButtonTask );
   *wn << *but;

   r.set( 290, 80, 440, 100 );
   cb = new mWnCtlTextComboBox( r, sysfnt, "Sound Effects",
                sound_effects_titles, 11, butUPDOWN|butVERTICAL );
   *wn << *cb;
   r.set( 315, 45, 415, 65 );
   but = new mWnCtlButton( r, sysfnt, "Play" );
   but->settask( SoundButtonTask );
   *wn << *but;

   *WM << *wn;

   WM->run();

   delete WM;

   return 0;
}
