//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp22.Cpp                                        //
// Desc:   Sample Program 22 - Custom Edit Cursors             //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.H"

//..............Custom Text Cursor class derived from mTxCursor
class mCustomTxCursor : public mTxCursor
{
   protected:
      int wid;           // width of cursor

   public:
      mCustomTxCursor( int w, int h, int i );
      virtual ~mCustomTxCursor( ) { }

      virtual void draw( void );
      void setwid( int w );
      // all other members are taken from mTxCursor class
};

mCustomTxCursor::mCustomTxCursor( int w, int h, int i ) :
                 mTxCursor( h, i )
{
   wid = w;
}

void mCustomTxCursor::draw( void )
{
   // set the pixel write mode to XOR
   int m = mGdMgr::getwrtmode();
   mGdMgr::setwrtmode( wXOR );

   int clr = mGdMgr::getmaxcolors() - 1;
   if ( ins )   //..........insert mode
   {            //..........draw the lines
      mPoint p1( posn.x, posn.y );
      mPoint p2( posn.x, posn.y + hgt - 1 );
      mGdMgr::drawline( p1, p2, clr );
      p2.set( posn.x + wid - 1, posn.y );
      mGdMgr::drawline( p1, p2, clr );
   }
   else         //..........overwrite mode
   {            //..........draw the box
      mRect r( posn.x, posn.y, posn.x + wid - 1, posn.y + hgt - 1 );
      mGdMgr::fillrect( r, mBrush( clr ) );
   }

   // reset the pixel write mode
   mGdMgr::setwrtmode( m );
   // change the visibility flag
   vis = 1 - vis;
}

void mCustomTxCursor::setwid( int w )
{
   hide();
   wid = w;
   show();
}

int main( void )
{
   // Start the app
   SetDefaultPalette( 8 );
   mWindowManager *WM = new mWindowManager;
   mFont *sysfnt = &WM->systemfont();

   // free the old cursor
   mTxCursor *tc = WM->gettxtcsr();
   if ( tc )
      delete tc;

   // set up the new text cursor
   mCustomTxCursor *ntc = new mCustomTxCursor( 8, 8, 0 );
   WM->settxtcsr( ntc );

   // create the windows and controls
   mWindow *wn = new mWindow( "MNSAMP22", 0, sysfnt,
                              400, 250, wBDRSIZABLE );
   wn->setstyle( yDESTROY, 1 );

   mRect r( 190, 150, 300, 170 );
   mWnCtlField *fld1 = new mWnCtlField( r, sysfnt, "Your name", 40 );
   r -= mPoint( 0, 30 );
   mWnCtlField *fld2 = new mWnCtlField( r, sysfnt, "Telephone", 12 );

   // put them all together
   *wn << *fld1 << *fld2;
   *WM << *wn;

   // run the app
   WM->run();

   // clean up
   delete WM;

   return 0;
}
