//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP21.CPP                                        //
// Desc:   NoteBook control example...                         //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mStdHdr.H"

#define TOGGLE '~'

char *HelpTabLabels[] =
{
    "Preface", "Ack.", "Intro", "End"
};

char *hlp_titles[] =
{
   "~Preface~",      "~Acknowledgements~",
   "~Introduction~", "~The End~"
};

char *hlp1[]=
{
   "Once upon a time, in",
   "a place far far away,",
   "Something very strange",
   "happened."
};

char *hlp2[] =
{
   "I would like to thank",
   "Everyone who helped me",
   "win this award and special",
   "thanks to my dog, Elvis."
};

char *hlp3[] =
{
   "This is an incredible",
   "book for our times.  Every-",
   "one having a chance should",
   "read it."
};

char *hlp4[] =
{
   "Well",
   "That's",
   "all",
   "Folks"
};

#define NPAGES 4

mWnCtlText *title, *txt0, *txt1, *txt2, *txt3;

//---------------------------------------------------------------------------//
// Task to handle a keyboard key                                             //
//---------------------------------------------------------------------------//
int KeyTask( mMsg& msg, mWnControl& ctl )
{
   if ( msg.verb == mEXECUTE )
   {
      mWnCtlBook *book = (mWnCtlBook *)ctl.getdata();
      if ( ctl.tag == 0 )
         *book << mMsg( mCONTROL, mPREVIOUS );
      else
         *book << mMsg( mCONTROL, mNEXT );
   }

   return( 0 );
}

void addbookcontrols( mWnCtlBook *bk, mFont *fnt )
{
   mPoint p;
   mRect r;
   mWnCtlText *tc;

   //............... page 1
   p.set( 50, 20 );
   tc = new mWnCtlText( p, fnt, "" );
   delete tc->getnodes()->txt;
   r.set( 20, 120, 260, 140 );
   tc->getnodes()->txt = new mHiloCtlTxt( r, hlp_titles[0], fnt,
                                          mPen( 0, 3 ), TOGGLE );
   bk->addcontrol( 1, tc );
   tc = new mWnCtlText( p, fnt, hlp1[3] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 1, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp1[2] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 1, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp1[1] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 1, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp1[0] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 1, tc );

   //............... page 2
   p.set( 50, 20 );
   tc = new mWnCtlText( p, fnt, "" );
   delete tc->getnodes()->txt;
   r.set( 20, 120, 260, 140 );
   tc->getnodes()->txt = new mHiloCtlTxt( r, hlp_titles[1], fnt,
                                          mPen( 0, 3 ), TOGGLE );
   bk->addcontrol( 2, tc );
   tc = new mWnCtlText( p, fnt, hlp2[3] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 2, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp2[2] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 2, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp2[1] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 2, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp2[0] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 2, tc );

   //............... page 3
   p.set( 50, 20 );
   tc = new mWnCtlText( p, fnt, "" );
   delete tc->getnodes()->txt;
   r.set( 20, 120, 260, 140 );
   tc->getnodes()->txt = new mHiloCtlTxt( r, hlp_titles[2], fnt,
                                          mPen( 0, 3 ), TOGGLE );
   bk->addcontrol( 3, tc );
   tc = new mWnCtlText( p, fnt, hlp3[3] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 3, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp3[2] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 3, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp3[1] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 3, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp3[0] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 3, tc );

   //............... page 4
   p.set( 50, 20 );
   tc = new mWnCtlText( p, fnt, "" );
   delete tc->getnodes()->txt;
   r.set( 20, 120, 260, 140 );
   tc->getnodes()->txt = new mHiloCtlTxt( r, hlp_titles[3], fnt,
                                          mPen( 0, 3 ), TOGGLE );
   bk->addcontrol( 4, tc );
   tc = new mWnCtlText( p, fnt, hlp4[3] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 4, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp4[2] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 4, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp4[1] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 4, tc );
   p.y += 23;
   tc = new mWnCtlText( p, fnt, hlp4[0] );
   tc->getnodes()->txt->setjust( jLEFT );
   bk->addcontrol( 4, tc );
}

int main( void )
{
   mWindowManager *WM = new mWindowManager;

   mFont *fnt = &WM->systemfont();
   mWindow *wn = new mWindow( "MNSAMP21", 0, fnt, 355, 197,
                              wBDRFIXED, wcSYSMENU );
   wn->setstyle( yDESTROY, 1 );

   // Create the book definition
   mBookDef *bookdef = new mBookDef;
   bookdef->area    = mRect( 20, 12, 280, 165 );      // Area for book
   bookdef->cvrflag = 1;                              // Cover flag
   bookdef->bkfont  = fnt;                            // Book font
   bookdef->title   = "Book 'o' Help";                // Title
   bookdef->cvrbr   = mBrush( 0 );                    // Cover brush
   bookdef->ttlbr   = mBrush( 14 );                   // Title area brush
   bookdef->npages  = NPAGES;                         // Number of tabs
   bookdef->tabtxt  = HelpTabLabels;                  // Tab labels

   // Create the book control
   mWnCtlBook *bk = new mWnCtlBook( bookdef );
   bk->setstyle( xPOSTDRAW, 1 );
   addbookcontrols( bk, fnt );
   *wn << *bk;

   mWnCtlKey *ky = new mWnCtlKey( mKey( kbKEYPAD, kbPGUP, 0 ) );
   ky->tag = 0;
   ky->setdata( (void *)bk );
   ky->settask( KeyTask );
   *wn << *ky;
   ky = new mWnCtlKey( mKey( kbKEYPAD, kbPGDN, 0 ) );
   ky->tag = 1;
   ky->setdata( (void *)bk );
   ky->settask( KeyTask );
   *wn << *ky;

   *WM << *wn;

   WM->run();

   delete WM;

   return 0;
}
