//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp2.Cpp                                         //
// Desc:   Sample Program 2 - Adding a Main Menu               //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mStdHdr.H"

//-------------------------------------------------------------//

// A typical main menu definition.

char *main_menu_labels[] =
{
   "~F~iles",                  // The tilda ( ~ ) is a "toggle"
   "~E~dit",                   // character that turns character
   "~O~ptions",                // highlighting on and off within
   "~Q~uit"                    // a string.
};

mKey main_menu_keys[] =
{
   mKey( kbALPHANUM, 'F', 0 ),    // These are the accelerator
   mKey( kbALPHANUM, 'E', 0 ),    // key definitions for each
   mKey( kbALPHANUM, 'O', 0 ),    // menu item.
   mKey( kbALPHANUM, 'Q', 0 ),
};

mMenuDef main_menu( main_menu_labels,  // array of labels
                    main_menu_keys,    // array of accel keys
                    4,                 // number of items
                    '~' );             // the toggle character

//-------------------------------------------------------------//

// A task for the main menu control.  This is called for
// every event processed by the menu control.  You would
// normally want to do something only when the user selects
// an item, which is indicated by the message verb.

int my_main_menu_task( mMsg& msg, mWnControl& ctl )
{
   if( msg.verb == mSELECT )
   {
      int item = msg.param[0];
      // in this example, only "Quit" does something
      switch( item )
      {
         case 1 : // Files
         case 2 : // Edit
         case 3 : // Options
                  beep();
                  break;
         case 4 : // Quit
                  mWindowManager *wm = ctl.getwind()->getwnmgr();
                  (*wm) << mMsg( mWINDOW, mCLOSE );
                  break;
      }
   }
   return 0;
}

//-------------------------------------------------------------//

int main( void )
{
    // instantiate a window manager
    mWindowManager WM;

    // instantiate a window
    mWindow wn( "Main Menu",         // window title
                &main_menu,          // pointer to menu def
                &WM.systemfont(),    // pointer to a font
                400, 250,            // window initial dimensions
                wBDRSIZABLE );       // window border type

    // set the task for the main menu control
    wn.getwnmenu()->settask( my_main_menu_task );

    // "attach" the window to the window manager
    WM << wn;

    // process the window
    WM.run();

    return 0;
}
