//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP17.CPP                                        //
// Desc:   Application Specific Mouse Cursors                  //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mStdHdr.H"

//*****************************************************************************
// NOTE: Uncomment the #define BGI line for Borland BGI and Microsoft Graphics
//       libraries.
// #define BGI
//*****************************************************************************

#ifndef BGI
// New mouse cursor mask for Flash Graphics, MetaWINDOW, and Genux GX
unsigned char NewMask[] =
{
 // Background Mask
 0xFF, 0xFE, 0x40, 0x04, 0x20, 0x08, 0x15, 0x50,
 0x0A, 0xA0, 0x05, 0x40, 0x02, 0x80, 0x02, 0x80,
 0x02, 0x80, 0x02, 0x80, 0x04, 0x40, 0x08, 0x20,
 0x15, 0x50, 0x2A, 0xA8, 0x55, 0x54, 0xFF, 0xFE,
 // Foreground Mask
 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xA0,
 0x05, 0x40, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00,
 0x00, 0x00, 0x00, 0x00, 0x02, 0x80, 0x05, 0x40,
 0x0A, 0xA0, 0x15, 0x50, 0x2A, 0xA8, 0x00, 0x00,
};
#else
// New mouse cursor mask for BGI and Microsoft Graphics
ushort NewMask[] =
{
 // Background Mask
 0x0001, 0xBFFB, 0xDFF7, 0xE00F, 0xF01F, 0xF83F, 0xFD7F, 0xFD7F,
 0xFD7F, 0xFD7F, 0xF83F, 0xF01F, 0xE00F, 0xC007, 0x8003, 0x0001,
 // Foreground Mask
 0x0000, 0x0000, 0x0000, 0x0AA0, 0x0540, 0x0280, 0x0000, 0x0000,
 0x0000, 0x0000, 0x0380, 0x07C0, 0x0AA0, 0x1550, 0x2AA8, 0x0000,
};
#endif

int MyTask( mWindowManager& winmgr, mMgrData dta )
{
   // If the window manger is not running
   if ( winmgr.getstatus( zFOCUS ) == 0 )
      return( 0 );

   // Set up needed areas
   mMsDevice& msdev = winmgr.msdevice();
   mPoint p = msdev.querycursor();
   int c = winmgr.getmscursor();
   // Window's Client Area
   mRect cr = winmgr.findtopwindow()->getclientrect();
   // Window's Title Area
   mRect tr = winmgr.findtopwindow()->getsyscontrol(wcTITLE)->extent();
   // Window's Entire Area
   mRect wr = winmgr.findtopwindow()->extent();

   // Return if the window is minimized
   if ( winmgr.findtopwindow()->getstatus( yMINIMIZED ) == 1 )
   {
      if ( c == -1 )
      {
         // Set the mouse cursor for the mouse device
         msdev.setcursor( 0 );
         // Tell the window manager which mouse to use
         winmgr << mMsg( mMOUSE, mSETCURSOR, 0 );
      }
      return( 0 );
   }

   // See if we are in the client area
   if ( ((p % cr) == INSIDE) && (c != -1) )
   {
      // Set the mouse cursor for the mouse device
      msdev.setcursor( NewMask, 7, 7 );
      // Tell the window manager which mouse to use
      winmgr << mMsg( mMOUSE, mSETCURSOR, -1 );
   }
   // See if we are outside the window or in the title bar
   else if ( (((p % wr) != INSIDE) || ((p % tr) == INSIDE)) && (c == -1) )
   {
      // Set the mouse cursor for the mouse device
      msdev.setcursor( 0 );
      // Tell the window manager which mouse to use
      winmgr << mMsg( mMOUSE, mSETCURSOR, 0 );
   }

   // That's all
   return( 0 );
}

int main( void )
{
   mWindowManager *WM = new mWindowManager;
   // Set up a task to toggle the mouse
   int wm_task = WM->registertask( MyTask, 0 );

   // Create a window to use
   mWindow *main_win = new mWindow( "MNSAMP17", 0,
               &WM->systemfont(), 400, 250, wBDRSIZABLE );
   main_win->setstyle( yDESTROY, 1 );

   *WM << *main_win;

   WM->run();

   // Release the window manager task
   WM->releasetask( wm_task );

   delete WM;

   return 0;
}
