//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP16.CPP                                        //
// Desc:   Tear-Off Menu example...                            //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//
// This is a example of adding a tear off menu to              //
// Menuet/CPP 2.0                                              //
//-------------------------------------------------------------//

#include "mStdHdr.H"

#define wcTEAROFFMENU 0x8002

#define TOGGLE '~'

//---------------------------------------------------------------------------//
//                                                                           //
//                          Tear Off Menu Class                              //
//                                                                           //
//---------------------------------------------------------------------------//
class mWnCtlTearOffMenu : public mWnCtlBoxMenu
{
   public:

      ulong timestamp;

   public:

      mWnCtlTearOffMenu( mRect r, mFont *fnt, mMenuDef *mdef );
      mWnCtlTearOffMenu( mFont *fnt, mMenuDef *mdef );
      mWnCtlTearOffMenu( );
      virtual ~mWnCtlTearOffMenu( );

      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
};

mWnCtlTearOffMenu::mWnCtlTearOffMenu( mRect r, mFont *fnt, mMenuDef *mdef ) :
               mWnCtlBoxMenu( r, fnt, mdef )
{
   iden = wcTEAROFFMENU;
   class_id = wcTEAROFFMENU;
   timestamp = 0;
   setstyle( xVISIBLE, 0 );
}

mWnCtlTearOffMenu::mWnCtlTearOffMenu( mFont *fnt, mMenuDef *mdef ) :
               mWnCtlBoxMenu( fnt, mdef )
{
   iden = wcTEAROFFMENU;
   class_id = wcTEAROFFMENU;
   timestamp = 0;
   setstyle( xVISIBLE, 0 );
}

mWnCtlTearOffMenu::mWnCtlTearOffMenu( void ) : mWnCtlBoxMenu()
{
   iden = wcTEAROFFMENU;
   class_id = wcTEAROFFMENU;
   timestamp = 0;
   setstyle( xVISIBLE, 0 );
}

mWnCtlTearOffMenu::~mWnCtlTearOffMenu( )
{
}

mMsg& mWnCtlTearOffMenu::xlate( mEvent& evt )
{
   int i;
   action.set( mNOTHING, mNULL );
   if( !getstatus( xACTIVE ) )
      return action;
   if( evt.devtype==devMOUSE )
   {
      switch( evt.key.keytype )
      {
         case msPRESS :
         {
              if ( evt.time == timestamp )
                 break;
              setstatus( xLOCKED, 1 );
              i = whichitem( evt.posn );
              if( getstatus( xOPEN ) && (i > 0) )
                 action.set( mCONTROL, mHIGHLIGHT, i );
              else if( ! getstatus(xOPEN) )
                 action.set( mCONTROL, mOPEN, i );
              else
                 action.set( mCONTROL, mCLOSE, mUP );
              break;
         }

         case msDRAG :
         {
              if( getstatus(xOPEN) )
              {
                 i = whichitem( evt.posn );
                 if( (i > 0) && (i != curitem) )
                    action.set( mCONTROL, mHIGHLIGHT, i );
              }
              break;
         }

         case msRELEASE :
         {
              setstatus( xLOCKED, 0 );
              if( getstatus(xOPEN) )
              {
                 i = whichitem( evt.posn );
                 if( i > 0 )
                    action.set( mCONTROL, mSELECT, i, -1 );
                 else if( (curitem > 0) && (submenu[curitem] == 0) )
                    action.set( mCONTROL, mCLOSE, mUP );
              }
              break;
         }

         case msDBLCLICK :
         {
              action.set( mCONTROL, mCLOSE, mUP );
              break;
         }
      }
   }
   else if( (evt.devtype == devKEYBRD) && (! getstatus(xLOCKED)) )
   {
      switch( evt.key.keyvalue )
      {
         case kbENTER :
         {
              if( curitem > 0 )
              {
                 if( submenu[curitem] == 0 )
                    action.set( mCONTROL, mSELECT, curitem, 0 );
                 else
                    setstatus( xLOCKED, 1 );
              }
              else if( curitem < 1 )
                 action.set( mCONTROL, mHIGHLIGHT, 1 );
              break;
         }

         case kbESCAPE :
         {
              action.set( mCONTROL, mCLOSE, mUP );
              break;
         }

         case kbDOWN :
         {
              i = nextselectable();
              action.set( mCONTROL, mHIGHLIGHT, i );
              break;
         }

         case kbUP :
         {
              i = prevselectable();
              action.set( mCONTROL, mHIGHLIGHT, i );
              break;
         }

         default : // test accelerator keys
         {
              i = whichkey( evt.key );
              if( i > 0 )
                 action.set( mCONTROL, mSELECT, i, 0 );
              break;
         }
      }
   }
   return action;
}

int mWnCtlTearOffMenu::exec( mMsg& msg )
{
   mWnControl *ctl;
   if( (wind->getwnmgr() != 0) && (msg.noun == mCONTROL) )
   {
      switch( msg.verb )
      {
         case mOPEN :
         {
              // to avoid conflicts with active cursored controls
              // we disable tit while we have focus
              mshide();
              ctl = wind->getcursorcontrol();
              if ( ctl )
                 if ( ctl->getstatus( xFOCUS ) )
                    *ctl << mMsg( mCONTROL, mENDEDIT );

              // Open the menu
              mRect rc = mGdMgr::getcliprect();
              mRect r1 = mGdMgr::getdisprect() - mGdMgr::getvieworigin();
              mRect r2 = extent();
              if ( (r2 % r1) != OUTSIDE )
              {
                 setstyle( xVISIBLE, 1 );
                 mGdMgr::setcliprect( r1 & r2 );
                 open();
                 curitem = msg.param[0];
                 if( curitem == 0 )
                    curitem = nextselectable();
                 sethighlight( curitem, 1 );
                 mGdMgr::setcliprect( rc );
              }
              msshow();
              break;
         }

         case mCLOSE :
         {
              mshide();
              setstyle( xVISIBLE, 0 );
              sethighlight( curitem, 0 );
              close();
              if( (msg.param[0] == mUP) && (submenu[0] != 0) )
                 (*submenu[0]) << mMsg( mCONTROL, mCLOSE, mUP );
              if( (msg.param[0] == mDOWN) && (curitem > 0) &&
                  (submenu[curitem] != 0) )
                 (*submenu[curitem]) << mMsg( mCONTROL, mCLOSE, mDOWN );

              // reactivate the cursor control
              ctl = wind->getcursorcontrol();
              if ( ctl )
                 if ( !ctl->getstatus( xFOCUS ) )
                    *ctl << mMsg( mCONTROL, mBGNEDIT );
              msshow();
              break;
         }

         case mSELECT :
         {
              mshide();
              curitem = msg.param[0];
              if( (curitem < 1) || (submenu[curitem] == 0) ) // no submenu
              {
                 close();
                 if( submenu[0] != 0 ) // parent menu
                    (*submenu[0]) << mMsg( mCONTROL, mCLOSE, mUP );
              }
              else // has submenu
              {
                 setstatus( xFOCUS, 0 );
                 (*submenu[curitem]) << mMsg( mCONTROL, mOPEN, msg.param[1] );
              }
              msshow();
              break;
         }

         case mHIGHLIGHT :
         {
              mshide();
              sethighlight( curitem, 0 );
              curitem = msg.param[0];
              sethighlight( curitem, 1 );
              msshow();
              break;
         }
      }
   }
   if( task )
      return (*task)( msg, *this );
   return 0;
}

//---------------------------------------------------------------------------//
// Menu definitions                                                          //
//---------------------------------------------------------------------------//
char *window_menu_labels[] =
{ "~G~rid", "~N~avigate", "~S~ave", "~R~estore", "~Q~uit" };

mKey window_menu_keys[] =
{
   mKey( kbOTHER, kbALTG, kbALTKEY ), mKey( kbOTHER, kbALTN, kbALTKEY ),
   mKey( kbOTHER, kbALTS, kbALTKEY ), mKey( kbOTHER, kbALTR, kbALTKEY ),
   mKey( kbOTHER, kbALTQ, kbALTKEY )
};

mMenuDef window_menu( window_menu_labels, window_menu_keys, 5, TOGGLE );

//---------------------------------------------------------------------------//
// Tear Off Menu Task                                                        //
//---------------------------------------------------------------------------//
int TearOffMenuTask( mMsg& msg, mWnControl& ctl )
{
   if ( msg.verb == mSELECT )
   {
      switch( msg.param[0] )
      {
         case 1 : // Grid
         case 2 : // Navigate
         case 3 : // Save
         case 4 : // Restore
                   break;
         case 5 : // Quit
                   *ctl.getwind()->getwnmgr() << mMsg( mWINDOW, mCLOSE );
                   return( 1 );
      }
   }

   return( 0 );
}

//---------------------------------------------------------------------------//
// Main window task                                                          //
//---------------------------------------------------------------------------//
int MainWindowClientTask( mMsg& msg, mWindow& win )
{
   if ( msg.noun == mEVT )
   {
      mEvent *evt = (mEvent *)msg.msgpointer();
      if ( evt->devtype == devMOUSE )
      {
         if ( (evt->key.keytype == msPRESS) &&
              (evt->key.keyvalue == msRIGHTBUTTON) &&
              ((evt->posn % win.getclientrect()) == INSIDE) )
         {
            mWnCtlTearOffMenu *menu =
               (mWnCtlTearOffMenu *)win.getclientctllist();

            mRect r( menu->extent() );
            mPoint p( r.xmin, r.ymin );
            p = evt->posn - p;
            p -= mPoint( 0, menu->extent().dely() );
            menu->move( p );
            menu->timestamp = evt->time;
            *menu << mMsg( mCONTROL, mOPEN );
            return( 1 );
         }
      }
   }

   return( 0 );
}

//---------------------------------------------------------------------------//
// Main 'C++' routine                                                        //
//---------------------------------------------------------------------------//
int main( void )
{
   mWindowManager *winmgr = new mWindowManager();
   mFont *sysfnt = &winmgr->systemfont();

   mWindow *win = new mWindow( "Click in Client Area", 0, sysfnt,
                               350, 300, wBDRFIXED, wcSYSMENU );
   win->setclienttask( MainWindowClientTask );
   win->setstyle( yDESTROY, 1 );

   mWnCtlTearOffMenu *mnu = new mWnCtlTearOffMenu( sysfnt, &window_menu );
   mnu->settask( TearOffMenuTask );
   *win << *mnu;
   *winmgr << *win;

   winmgr->run();

   delete( winmgr );

   return( 1 );
}
