//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP15.CPP                                        //
// Desc:   General Combo Box example                           //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mStdHdr.H"

// Text strings for the button labels
char *drv_but_lbls[] =
{
    "..", "A:", "B:", "C:", "D:", "E:", "M:", "N:", "O:", "P:"
};

char *clr_but_lbls[] =
{
    "Black", "Dark Gray", "Thematic Color", "Thematic Color",
    "Thematic Color", "Gold", "Orange", "Aquamarine", "Blue",
    "Red", "Light Blue", "Thematic Color", "Thematic Color",
    "Thematic Color", "Light Gray", "White"
};

// Text to draw in list box
char *txt_list[] =
{
    "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine",
    "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen",
    "Seventeen", "Eightteen", "Nineteen", "Twenty", "Twentyone", "Twentytwo",
    "Twentythree", "Twentyfour", "Twentyfive"
};

//---------------------------------------------------------------------------//
// Since the mWnControl::move() function is relative use this function to    //
//   move a control to an absolute location.                                 //
//---------------------------------------------------------------------------//
void MoveCtlTo( mWnControl& ctl, mPoint& dest_pt )
{
    mRect  cr( ctl.extent() );
    mPoint co( cr.xmin, cr.ymin );
    mPoint cd( dest_pt.x - co.x, dest_pt.y - co.y );
    ctl.move( cd );
}

//---------------------------------------------------------------------------//
// Task to draw the buttons in the list box                                  //
//---------------------------------------------------------------------------//
void DrawButTask( mRect& r, short index, void *ld )
{
    mWnControl **ctl_list = (mWnControl **)ld;
    if ( ctl_list )
    {
        MoveCtlTo( *ctl_list[index], mPoint( r.xmin, r.ymin ) );
        ctl_list[index]->draw();
    }
}

//---------------------------------------------------------------------------//
// Task to draw the text in the third list box                               //
//---------------------------------------------------------------------------//
void DrawTxtTask( mRect& r, short index, void *ld )
{
    mFont *fnt = (mFont *)ld;
    fnt->drawstring( r, txt_list[index] );
}

//---------------------------------------------------------------------------//
// Main 'C++' routine                                                        //
//---------------------------------------------------------------------------//
int main( void )
{
    mWindowManager *WM = new mWindowManager;

    mFont *sysfont = &WM->systemfont();
    int width = mGdMgr::getdispwidth();
    int height = mGdMgr::getdispheight();
    mWindow wn( "Menuet/CPP Sample 15", 0, sysfont,
                width, height, wBDRFIXED, wcSYSMENU );

    // Drive button list
    mWnCtlButton **but_list =
             (mWnCtlButton **)new char[ 10 * sizeof( mWnCtlButton * ) ];
    for( int i=0; i<10; i++ )
    {
        but_list[i] = new mWnCtlButton( mRect(0,0,30,16),
                         sysfont, drv_but_lbls[i] );
    }
    mWnCtlComboBox *cb = new mWnCtlComboBox( mRect( 20, 250, 150, 270 ),
                                             sysfont, "Drive", 10, 16,
                                             DrawButTask,
                                             butVERTICAL|butUPDOWN );
    cb->setcbdata( (void *)but_list );
    cb->tag = 1;
    wn << *cb;

    // Button color list
    but_list = (mWnCtlButton **)new char[ 16 * sizeof( mWnCtlButton * ) ];
    for( i=0; i<16; i++ )
    {
        but_list[i] = new mWnCtlButton( mRect(0,0,145,20),
                         sysfont, clr_but_lbls[i] );
        mControlText *ct = but_list[i]->getnodes()->txt;
        ct->setpen( mPen( i ) );
    }
    cb = new mWnCtlComboBox( mRect( 190, 250, 380, 274 ),
                             sysfont, "Drive", 16, 20,
                             DrawButTask, butVERTICAL|butUPDOWN );
    cb->tag = 2;
    cb->setcbdata( (void *)but_list );
    wn << *cb;

    // Regular text list
    cb = new mWnCtlComboBox( mRect( 390, 250, 600, 270 ),
                             sysfont, "Number",
                             25, sysfont->getcellh(),
                             DrawTxtTask );
    cb->setcbdata( (void *)sysfont );
    wn << *cb;

    *WM << wn;

    WM->run();

    delete WM;

    return 0;
}
