//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP14.CPP                                        //
// Desc:   General List Box example                            //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mStdHdr.H"

// Text strings for the button labels
char *drv_but_lbls[] =
{
    "..", "A:", "B:", "C:", "D:", "E:", "M:", "N:", "O:", "P:"
};

char *clr_but_lbls[] =
{
    "Black", "Dark Gray", "Thematic Color", "Thematic Color",
    "Thematic Color", "Gold", "Orange", "Aquamarine", "Blue",
    "Red", "Light Blue", "Thematic Color", "Thematic Color",
    "Thematic Color", "Light Gray", "White"
};

// Text to draw in list box
char *txt_list[] =
{
    "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine",
    "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen",
    "Seventeen", "Eightteen", "Nineteen", "Twenty", "Twentyone", "Twentytwo",
    "Twentythree", "Twentyfour", "Twentyfive"
};

//---------------------------------------------------------------------------//
// Since the mWnControl::move() function is relative use this function to    //
//   move a control to an absolute location.                                 //
//---------------------------------------------------------------------------//
void MoveCtlTo( mWnControl& ctl, mPoint& pt )
{
    mRect  cr( ctl.extent() );
    mPoint co( cr.xmin, cr.ymin );
    mPoint cd( pt.x - co.x, pt.y - co.y );
    ctl.move( cd );
}

//---------------------------------------------------------------------------//
// Task to draw the buttons in the list box                                  //
//---------------------------------------------------------------------------//
void DrawButTask( mRect& r, short index, void *ld )
{
    mWnControl **ctl_list = (mWnControl **)ld;
    if ( ctl_list )
    {
        MoveCtlTo( *ctl_list[index], mPoint( r.xmin, r.ymin ) );
        ctl_list[index]->draw();
    }
}

//---------------------------------------------------------------------------//
// Task to draw the text in the third list box                               //
//---------------------------------------------------------------------------//
void DrawTxtTask( mRect& r, short index, void *ld )
{
    mFont *fnt = (mFont *)ld;
    fnt->drawstring( r, txt_list[index] );
}

//---------------------------------------------------------------------------//
// Main 'C++' routine                                                        //
//---------------------------------------------------------------------------//
int main( void )
{
    mWindowManager *WM = new mWindowManager;

    mFont *sysfont = &WM->systemfont();
    int width = mGdMgr::getdispwidth();
    int height = mGdMgr::getdispheight();
    mWindow wn( "Menuet/CPP Sample 14", 0, sysfont,
                width, height, wBDRFIXED, wcSYSMENU );

    // Drive button list
    mWnCtlButton **but_list =
             (mWnCtlButton **)new char[ 10 * sizeof( mWnCtlButton * ) ];
    for( int i=0; i<10; i++ )
    {
        but_list[i] = new mWnCtlButton( mRect(0,0,30,16),
                         sysfont, drv_but_lbls[i] );
    }
    mWnCtlListBox *lb = new mWnCtlListBox( mRect( 20, 50, 120, 170 ),
                                           mRect( 123,50, 143, 170 ),
                                           10, 16, DrawButTask,
                                           butVERTICAL|butUPDOWN );
    lb->setlistdata( (void *)but_list );
    wn << *lb;

    // Button color list
    but_list = (mWnCtlButton **)new char[ 16 * sizeof( mWnCtlButton * ) ];
    for( i=0; i<16; i++ )
    {
        but_list[i] = new mWnCtlButton( mRect(0,0,160,20),
                         sysfont, clr_but_lbls[i] );
        mControlText *ct = but_list[i]->getnodes()->txt;
        ct->setpen( mPen( i ) );
    }
    lb = new mWnCtlListBox( mRect( 180, 50, 360, 250 ),
                            mRect( 363, 50, 383, 250 ),
                            16, 20,
                            DrawButTask );
    lb->setlistdata( (void *)but_list );
    wn << *lb;

    // Regular text list
    lb = new mWnCtlListBox( mRect( 390, 50, 600, 250 ),
                            mRect( 603, 50, 620, 250 ),
                            25, sysfont->getcellh(),
                            DrawTxtTask );
    lb->setlistdata( (void *)sysfont );
    wn << *lb;

    *WM << wn;

    WM->run();

    delete WM;

    return 0;
}
