//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MNSAMP13.CPP                                        //
// Desc:   Using Gauges                                        //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//
//                                                             //
// Notes:  (1) This example contains 2 different gauge         //
//             demo functions.  Pass a 1 or a 2 on the         //
//             command line to select which demo is run.       //
//                                                             //
//-------------------------------------------------------------//

#include "mstdhdr.h"

//------------------------------------------------------------------//
//  Demo 1 - Basic gauge usage                                      //
//------------------------------------------------------------------//

void DoDemo1( void )
{
     mWindowManager WM;
     mWindow wn( "Gauge Demo 1", 0, WM.getsysfont(),
                 640, 480, wBDRSIZABLE );

     // horz gauge
     mRect hr( 100, 100, 300, 125 );
     mWnCtlGauge hg( hr, 5, 5, butHORIZONTAL );

     // vert gauge
     mRect vr( 375, 100, 400, 300 );
     mWnCtlGauge vg( vr, 5, 5, butVERTICAL );

     wn << hg << vg;

     WM << wn;
     WM.run();
}

//------------------------------------------------------------------//
//  Demo 2 - Advanced gauge usage                                   //
//------------------------------------------------------------------//

//--------- spin button stuff for controling the vertical gauge

static char vstr[16] = "50";
static int  vmin = 0,
            vcur = 50,
            vmax = 100;

char *vselector( int verb, void * dataptr )
{
   // determine new spin button reading
   switch( verb )
   {
      case mNEXT :
           if( vcur < vmax ) vcur++;
           break;

      case mPREVIOUS :
           if( vcur > vmin ) vcur--;
           break;
   }
   sprintf( vstr, "%d", vcur );

   // update gauge with new reading
   mWnCtlGauge *ga = (mWnCtlGauge *) dataptr;
   ga->set( vcur );
   *ga << mMsg( mCONTROL, mUPDATE );

   return vstr;
}

//--------- spin button stuff for controling the horizontal gauge

static char hstr[16] = "50";
static int  hmin = 0,
            hcur = 50,
            hmax = 100;

char *hselector( int verb, void * dataptr )
{
   // determine new spin button reading
   switch( verb )
   {
      case mNEXT :
           if( hcur < hmax ) hcur++;
           break;

      case mPREVIOUS :
           if( hcur > hmin ) hcur--;
           break;
   }
   sprintf( hstr, "%d", hcur );

   // update gauge with new reading
   mWnCtlGauge *ga = (mWnCtlGauge *) dataptr;
   ga->set( hcur );
   *ga << mMsg( mCONTROL, mUPDATE );

   return hstr;
}

//--------- demo 2 "main"

void DoDemo2( void )
{
     mWindowManager WM;
     mWindow wn( "Gauge Demo 1", 0, WM.getsysfont(),
                 640, 480, wBDRSIZABLE );

     // horz gauge...
     mRect hgr( 100, 100, 300, 125 );
     mWnCtlGauge hg( hgr, 5, 5, butHORIZONTAL );
     hg.setstatus( xACTIVE, 0 );   // make display-only
     hg.set( hmin, hcur, hmax );   // set reading extent

     // ...related spin button
     mRect hsr( 100, 135, 175, 165 );
     mWnCtlSpinBut hsp( hsr, WM.getsysfont(), "Horz", hselector );
     hsp.setdata( &hg );

     // vert gauge...
     mRect vgr( 375, 100, 400, 300 );
     mWnCtlGauge vg( vgr, 5, 5, butVERTICAL );
     vg.setstatus( xACTIVE, 0 );   // make display-only
     vg.set( vmin, vcur, vmax );   // set reading extent

     // ...related spin button
     mRect vsr( 410, 100, 485, 130 );
     mWnCtlSpinBut vsp( vsr, WM.getsysfont(), "Vert", vselector );
     vsp.setdata( &vg );

     wn << hg << hsp << vg << vsp;

     WM << wn;
     WM.run();
}

//------------------------------------------------------------------//
//                             M A I N                              //
//------------------------------------------------------------------//

int main( int argc, char *argv[] )
{
     SetDefaultPalette( pPewter );

     int which = '1';
     if( argc > 1 ) which = *argv[1];

     if( which == '1' )
        DoDemo1();
     else if( which == '2' )
        DoDemo2();
     else
        printf( "Usage:   MNSAMP13   [ 1 | 2 ]\n" );

     return 0;
}
