//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp12.Cpp                                        //
// Desc:   Sample Program 12 - An event display program        //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.h"

//-------------------------------------------------------------//

// Window Manager
mWindowManager *WM;

// Display Controls
mWnCtlField *dtype;
mWnCtlField *ktype;
mWnCtlField *value;
mWnCtlField *flags;
mWnCtlField *time_ctl;
mWnCtlField *xpos;
mWnCtlField *ypos;
mWnCtlButton *exit_but;

//-------------------------------------------------------------//

#define dNONE       0
#define dNULL       1
#define dKEYBRD     2
#define dMOUSE      3
#define dTIMER      4
#define dPEN        5

char *dev_type_labels[] =
{
   "None", "devNULL", "devKEYBRD", "devMOUSE", "devTIMER", "devPEN"
};

#define mtNONE      0
#define mtNULL      1
#define mtPRESS     2
#define mtRELEASE   3
#define mtDBLCLICK  4
#define mtDRAG      5

char *mouse_keytype_labels[] =
{
   "None", "msNULL", "msPRESS", "msRELEASE", "msDBLCLICK", "msDRAG"
};

#define mvLEFTBUTTON    0
#define mvRIGHTBUTTON   1
#define mvMIDDLEBUTTON  2
#define mvXCHANGE       3
#define mvYCHANGE       4

char *mouse_keyvalue_labels[] =
{
   "msLEFTBUTTON", "msRIGHTBUTTON", "msMIDDLEBUTTON",
   "msXCHANGE", "msYCHANGE"
};

#define ktNONE          0
#define ktNULL          1
#define ktALPHANUM      2
#define ktKEYPAD        3
#define ktFUNCTION      4
#define ktCONTROL       5
#define ktOTHER         6

char *keybrd_keytype_labels[] =
{
   "None", "kbNULL", "kbALPHANUM", "kbKEYPAD", "kbFUNCTION",
   "kbCONTROL", "kbOTHER"
};

#define kvCTRLON    0
#define kvCTRLOFF   1
#define kvALTON     2
#define kvALTOFF    3
#define kvSHIFTON   4
#define kvSHIFTOFF  5
#define kvENTER     6
#define kvESCAPE    7
#define kvTAB       8
#define kvSHIFTTAB  9
#define kvBACKSPACE 10
#define kvUP        11
#define kvDOWN      12
#define kvLEFT      13
#define kvRIGHT     14
#define kvPGUP      15
#define kvPGDN      16
#define kvHOME      17
#define kvEND       18
#define kvINSERT    19
#define kvDEL       20
#define kvCTRLHOME  21
#define kvCTRLEND   22
#define kvCTRLRIGHT 23
#define kvCTRLLEFT  24
#define kvF1        25
#define kvF2        26
#define kvF3        27
#define kvF4        28
#define kvF5        29
#define kvF6        30
#define kvF7        31
#define kvF8        32
#define kvF9        33
#define kvF10       34
#define kvSHIFTF1   35
#define kvSHIFTF2   36
#define kvSHIFTF3   37
#define kvSHIFTF4   38
#define kvSHIFTF5   39
#define kvSHIFTF6   40
#define kvSHIFTF7   41
#define kvSHIFTF8   42
#define kvSHIFTF9   43
#define kvSHIFTF10  44
#define kvCTRLF1    45
#define kvCTRLF2    46
#define kvCTRLF3    47
#define kvCTRLF4    48
#define kvCTRLF5    49
#define kvCTRLF6    50
#define kvCTRLF7    51
#define kvCTRLF8    52
#define kvCTRLF9    53
#define kvCTRLF10   54
#define kvALTF1     55
#define kvALTF2     56
#define kvALTF3     57
#define kvALTF4     58
#define kvALTF5     59
#define kvALTF6     60
#define kvALTF7     61
#define kvALTF8     62
#define kvALTF9     63
#define kvALTF10    64
#define kvALTA      65
#define kvALTB      66
#define kvALTC      67
#define kvALTD      68
#define kvALTE      69
#define kvALTF      70
#define kvALTG      71
#define kvALTH      72
#define kvALTI      73
#define kvALTJ      74
#define kvALTK      75
#define kvALTL      76
#define kvALTM      77
#define kvALTN      78
#define kvALTO      79
#define kvALTP      80
#define kvALTQ      81
#define kvALTR      82
#define kvALTS      83
#define kvALTT      84
#define kvALTU      85
#define kvALTV      86
#define kvALTW      87
#define kvALTX      88
#define kvALTY      89
#define kvALTZ      90

char *keybrd_value_labels[] =
{
    "kbCTRLON",    "kbCTRLOFF",   "kbALTON",     "kbALTOFF",    "kbSHIFTON",
    "kbSHIFTOFF",  "kbENTER",     "kbESCAPE",    "kbTAB",       "kbSHIFTTAB",
    "kbBACKSPACE", "kbUP",        "kbDOWN",      "kbLEFT",      "kbRIGHT",
    "kbPGUP",      "kbPGDN",      "kbHOME",      "kbEND",       "kbINSERT",
    "kbDEL",       "kbCTRLHOME",  "kbCTRLEND",   "kbCTRLRIGHT", "kbCTRLLEFT",
    "kbF1",        "kbF2",        "kbF3",        "kbF4",        "kbF5",
    "kbF6",        "kbF7",        "kbF8",        "kbF9",        "kbF10",
    "kbSHIFTF1",   "kbSHIFTF2",   "kbSHIFTF3",   "kbSHIFTF4",   "kbSHIFTF5",
    "kbSHIFTF6",   "kbSHIFTF7",   "kbSHIFTF8",   "kbSHIFTF9",   "kbSHIFTF10",
    "kbCTRLF1",    "kbCTRLF2",    "kbCTRLF3",    "kbCTRLF4",    "kbCTRLF5",
    "kbCTRLF6",    "kbCTRLF7",    "kbCTRLF8",    "kbCTRLF9",    "kbCTRLF10",
    "kbALTF1",     "kbALTF2",     "kbALTF3",     "kbALTF4",     "kbALTF5",
    "kbALTF6",     "kbALTF7",     "kbALTF8",     "kbALTF9",     "kbALTF10",
    "kbALTA",      "kbALTB",      "kbALTC",      "kbALTD",      "kbALTE",
    "kbALTF",      "kbALTG",      "kbALTH",      "kbALTI",      "kbALTJ",
    "kbALTK",      "kbALTL",      "kbALTM",      "kbALTN",      "kbALTO",
    "kbALTP",      "kbALTQ",      "kbALTR",      "kbALTS",      "kbALTT",
    "kbALTU",      "kbALTV",      "kbALTW",      "kbALTX",      "kbALTY",
    "kbALTZ"
};

#define ttNULL    0
#define ttALARM   1

char *timer_type_labels[] =
{
   "tmNULL", "tmALARM"
};

#define fRSHIFT   0
#define fLSHIFT   1
#define fCTRLKEY  2
#define fALTKEY   3
#define fSCRLOCK  4
#define fNUMLOCK  5
#define fCAPLOCK  6
#define fINS      7

char *event_flags[] =
{
    "RShf", "LShf", "Ctl", "Alt", "Scr", "Num", "Cap", "Ins"
};

static int last_devtype = -1;

//-------------------------------------------------------------//
// Decode the key type for a mouse event                       //
//-------------------------------------------------------------//

void DecodeMouseEvent( mEvent& evt )
{
    static int mlast_keytype = -1;
    static int mlast_keyvalue = -1;

    // Determine the key type
    int kt;
    switch( evt.key.keytype )
    {
        case msNULL :     kt = mtNULL;
                          break;
        case msPRESS :    kt = mtPRESS;
                          break;
        case msRELEASE :  kt = mtRELEASE;
                          break;
        case msDBLCLICK : kt = mtDBLCLICK;
                          break;
        case msDRAG :     kt = mtDRAG;
                          break;
        default:          kt = mtNONE;
                          break;
    }

    // only redraw if things have changed
    if ( (mlast_keytype != evt.key.keytype) ||
         (last_devtype != evt.devtype) )
    {
        WM->msdevice().hidecursor();
        ktype->put( mouse_keytype_labels[kt] );
        ktype->draw();
        mlast_keytype = evt.key.keytype;
        WM->msdevice().showcursor();
    }

    // Determine the key value
    int kv = 0;
    switch( evt.key.keyvalue )
    {
        case msLEFTBUTTON   : kv = mvLEFTBUTTON;
                              break;
        case msRIGHTBUTTON  : kv = mvRIGHTBUTTON;
                              break;
        case msMIDDLEBUTTON : kv = mvMIDDLEBUTTON;
                              break;
        case msXCHANGE      : kv = mvXCHANGE;
                              break;
        case msYCHANGE      : kv = mvYCHANGE;
                              break;
    }

    // only redraw if things have changed
    if ( (mlast_keyvalue != evt.key.keyvalue) ||
         (last_devtype != evt.devtype) )
    {
        WM->msdevice().hidecursor();
        value->put( mouse_keyvalue_labels[kv] );
        value->draw();
        mlast_keyvalue = evt.key.keyvalue;
        WM->msdevice().showcursor();
    }
}

//-------------------------------------------------------------//
// Decode a keyboard event                                     //
//-------------------------------------------------------------//
void DecodeKeyboardEvent( mEvent& evt )
{
    static int klast_keytype = -1;
    static int klast_keyvalue = -1;

    // Determine the key type
    int kt;
    switch( evt.key.keytype )
    {
        case kbNULL :     kt = ktNULL;
                          break;
        case kbALPHANUM : kt = ktALPHANUM;
                          break;
        case kbKEYPAD   : kt = ktKEYPAD;
                          break;
        case kbFUNCTION : kt = ktFUNCTION;
                          break;
        case kbCONTROL  : kt = ktCONTROL;
                          break;
        default         : kt = ktOTHER;
                          break;
    }

    // only redraw if things have changed
    if ( (klast_keytype != evt.key.keytype) ||
         (last_devtype != evt.devtype) )
    {
        WM->msdevice().hidecursor();
        ktype->put( keybrd_keytype_labels[kt] );
        ktype->draw();
        klast_keytype = evt.key.keytype;
        WM->msdevice().showcursor();
    }

    // Determine the key value
    int kv;
    char msg[10];
    switch( evt.key.keyvalue )
    {
        case kbCTRLON :    kv = kvCTRLON;
                           break;
        case kbCTRLOFF :   kv = kvCTRLOFF;
                           break;
        case kbALTON :     kv = kvALTON;
                           break;
        case kbALTOFF :    kv = kvALTOFF;
                           break;
        case kbLSHIFTON :  kv = kvSHIFTON;
                           break;
        case kbLSHIFTOFF : kv = kvSHIFTOFF;
                           break;
        case kbENTER :     kv = kvENTER;
                           break;
        case kbESCAPE :    kv = kvESCAPE;
                           break;
        case kbTAB :       kv = kvTAB;
                           break;
        case kbSHIFTTAB :  kv = kvSHIFTTAB;
                           break;
        case kbBACKSPACE : kv = kvBACKSPACE;
                           break;
        case kbUP :        kv = kvUP;
                           break;
        case kbDOWN :      kv = kvDOWN;
                           break;
        case kbLEFT :      kv = kvLEFT;
                           break;
        case kbRIGHT :     kv = kvRIGHT;
                           break;
        case kbPGUP :      kv = kvPGUP;
                           break;
        case kbPGDN :      kv = kvPGDN;
                           break;
        case kbHOME :      kv = kvHOME;
                           break;
        case kbEND :       kv = kvEND;
                           break;
        case kbINSERT :    kv = kvINSERT;
                           break;
        case kbDEL :       kv = kvDEL;
                           break;
        case kbCTRLHOME :  kv = kvCTRLHOME;
                           break;
        case kbCTRLEND :   kv = kvCTRLEND;
                           break;
        case kbCTRLLEFT :  kv = kvCTRLLEFT;
                           break;
        case kbCTRLRIGHT : kv = kvCTRLRIGHT;
                           break;
        case kbF1 :        kv = kvF1;
                           break;
        case kbF2 :        kv = kvF2;
                           break;
        case kbF3 :        kv = kvF3;
                           break;
        case kbF4 :        kv = kvF4;
                           break;
        case kbF5 :        kv = kvF5;
                           break;
        case kbF6 :        kv = kvF6;
                           break;
        case kbF7 :        kv = kvF7;
                           break;
        case kbF8 :        kv = kvF8;
                           break;
        case kbF9 :        kv = kvF9;
                           break;
        case kbF10 :       kv = kvF10;
                           break;
        case kbSHIFTF1 :   kv = kvSHIFTF1;
                           break;
        case kbSHIFTF2 :   kv = kvSHIFTF2;
                           break;
        case kbSHIFTF3 :   kv = kvSHIFTF3;
                           break;
        case kbSHIFTF4 :   kv = kvSHIFTF4;
                           break;
        case kbSHIFTF5 :   kv = kvSHIFTF5;
                           break;
        case kbSHIFTF6 :   kv = kvSHIFTF6;
                           break;
        case kbSHIFTF7 :   kv = kvSHIFTF7;
                           break;
        case kbSHIFTF8 :   kv = kvSHIFTF8;
                           break;
        case kbSHIFTF9 :   kv = kvSHIFTF9;
                           break;
        case kbSHIFTF10 :  kv = kvSHIFTF10;
                           break;
        case kbCTRLF1 :    kv = kvCTRLF1;
                           break;
        case kbCTRLF2 :    kv = kvCTRLF2;
                           break;
        case kbCTRLF3 :    kv = kvCTRLF3;
                           break;
        case kbCTRLF4 :    kv = kvCTRLF4;
                           break;
        case kbCTRLF5 :    kv = kvCTRLF5;
                           break;
        case kbCTRLF6 :    kv = kvCTRLF6;
                           break;
        case kbCTRLF7 :    kv = kvCTRLF7;
                           break;
        case kbCTRLF8 :    kv = kvCTRLF8;
                           break;
        case kbCTRLF9 :    kv = kvCTRLF9;
                           break;
        case kbCTRLF10 :   kv = kvCTRLF10;
                           break;
        case kbALTF1 :     kv = kvALTF1;
                           break;
        case kbALTF2 :     kv = kvALTF2;
                           break;
        case kbALTF3 :     kv = kvALTF3;
                           break;
        case kbALTF4 :     kv = kvALTF4;
                           break;
        case kbALTF5 :     kv = kvALTF5;
                           break;
        case kbALTF6 :     kv = kvALTF6;
                           break;
        case kbALTF7 :     kv = kvALTF7;
                           break;
        case kbALTF8 :     kv = kvALTF8;
                           break;
        case kbALTF9 :     kv = kvALTF9;
                           break;
        case kbALTF10 :    kv = kvALTF10;
                           break;
        case kbALTA :      kv = kvALTA;
                           break;
        case kbALTB :      kv = kvALTB;
                           break;
        case kbALTC :      kv = kvALTC;
                           break;
        case kbALTD :      kv = kvALTD;
                           break;
        case kbALTE :      kv = kvALTE;
                           break;
        case kbALTF :      kv = kvALTF;
                           break;
        case kbALTG :      kv = kvALTG;
                           break;
        case kbALTH :      kv = kvALTH;
                           break;
        case kbALTI :      kv = kvALTI;
                           break;
        case kbALTJ :      kv = kvALTJ;
                           break;
        case kbALTK :      kv = kvALTK;
                           break;
        case kbALTL :      kv = kvALTL;
                           break;
        case kbALTM :      kv = kvALTM;
                           break;
        case kbALTN :      kv = kvALTN;
                           break;
        case kbALTO :      kv = kvALTO;
                           break;
        case kbALTP :      kv = kvALTP;
                           break;
        case kbALTQ :      kv = kvALTQ;
                           break;
        case kbALTR :      kv = kvALTR;
                           break;
        case kbALTS :      kv = kvALTS;
                           break;
        case kbALTT :      kv = kvALTT;
                           break;
        case kbALTU :      kv = kvALTU;
                           break;
        case kbALTV :      kv = kvALTV;
                           break;
        case kbALTW :      kv = kvALTW;
                           break;
        case kbALTX :      kv = kvALTX;
                           break;
        case kbALTY :      kv = kvALTY;
                           break;
        case kbALTZ :      kv = kvALTZ;
                           break;
        default     :      kv = -1;
                           sprintf( msg, "0x%04X", evt.key.keyvalue );
                           break;
    }

    // only redraw if things have changed
    if ( (klast_keyvalue != evt.key.keyvalue) ||
         (last_devtype != evt.devtype) )
    {
        WM->msdevice().hidecursor();
        if ( kv == -1 )
            value->put( msg );
        else
            value->put( keybrd_value_labels[kv] );
        value->draw();
        klast_keytype = evt.key.keytype;
        WM->msdevice().showcursor();
    }
}

//-------------------------------------------------------------//
// Decode a timer event                                        //
//-------------------------------------------------------------//

void DecodeTimerEvent( mEvent& evt )
{
    static int tlast_keytype = -1;
    int tt;

    switch( evt.key.keytype )
    {
        case tmNULL  : tt = ttNULL;
                       break;
        case tmALARM : tt = ttALARM;
                       break;
    }

    // only redraw if things have changed
    if ( (tlast_keytype != evt.key.keytype) ||
         (last_devtype != evt.devtype) )
    {
        WM->msdevice().hidecursor();
        ktype->put( timer_type_labels[tt] );
        ktype->draw();
        tlast_keytype = evt.key.keytype;
        WM->msdevice().showcursor();
    }
}

//-------------------------------------------------------------//
// Decode the flags for an event                               //
//-------------------------------------------------------------//
void DecodeEventFlags( mEvent& evt )
{
    static int last_event_flags = -1;
    int not_first = 0;
    char sflags[80];

    memset( sflags, 0, 80 );
    if ( evt.key.keyflags & kbRSHIFT )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fRSHIFT] );
        }
        else
        {
            strcpy( sflags, event_flags[fRSHIFT] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbLSHIFT )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fLSHIFT] );
        }
        else
        {
            strcpy( sflags, event_flags[fLSHIFT] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbCTRLKEY )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fCTRLKEY] );
        }
        else
        {
            strcpy( sflags, event_flags[fCTRLKEY] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbALTKEY )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fALTKEY] );
        }
        else
        {
            strcpy( sflags, event_flags[fALTKEY] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbSCRLOCK )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fSCRLOCK] );
        }
        else
        {
            strcpy( sflags, event_flags[fSCRLOCK] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbNUMLOCK )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fNUMLOCK] );
        }
        else
        {
            strcpy( sflags, event_flags[fNUMLOCK] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbCAPLOCK )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fCAPLOCK] );
        }
        else
        {
            strcpy( sflags, event_flags[fCAPLOCK] );
            not_first = 1;
        }
    }
    if ( evt.key.keyflags & kbINS )
    {
        if ( not_first )
        {
            strcat( sflags, "," );
            strcat( sflags, event_flags[fINS] );
        }
        else
        {
            strcpy( sflags, event_flags[fINS] );
            not_first = 1;
        }
    }

    // only redraw if things have changed
    if ( (last_event_flags != evt.key.keyflags) ||
         (last_devtype != evt.devtype) )
    {
        WM->msdevice().hidecursor();
        flags->put( sflags );
        flags->draw();
        last_event_flags = evt.key.keyflags;
        WM->msdevice().showcursor();
    }
}

//-------------------------------------------------------------//
// Decode the time of an event                                 //
//-------------------------------------------------------------//

void DecodeEventTime( mEvent& evt )
{
    char stime[10];

    sprintf( stime, "%u", evt.time );
    WM->msdevice().hidecursor();
    time_ctl->put( stime );
    time_ctl->draw();
    WM->msdevice().showcursor();
}

//-------------------------------------------------------------//
// Decode the position of an event                             //
//-------------------------------------------------------------//

void DecodeEventPosition( mEvent& evt )
{
    static int last_xpos = -1;
    static int last_ypos = -1;
    char str[5];

    if ( last_xpos != evt.posn.x )
    {
        last_xpos = evt.posn.x;
        sprintf( str, "%u", evt.posn.x );
        WM->msdevice().hidecursor();
        xpos->put( str );
        xpos->draw();
        WM->msdevice().showcursor();
    }

    if ( last_ypos != evt.posn.y )
    {
        last_ypos = evt.posn.y;
        sprintf( str, "%u", evt.posn.y );
        WM->msdevice().hidecursor();
        ypos->put( str );
        ypos->draw();
        WM->msdevice().showcursor();
    }
}

//-------------------------------------------------------------//
// Decode the parts of an event and display them               //
//-------------------------------------------------------------//

void DecodeEvent( mEvent& evt )
{
    int dev;
    // Determine the device type
    switch( evt.devtype )
    {
        case devNULL :   dev = dNULL;
                         break;
        case devKEYBRD : dev = dKEYBRD;
                         DecodeKeyboardEvent( evt );
                         break;
        case devMOUSE :  dev = dMOUSE;
                         DecodeMouseEvent( evt );
                         break;
        case devTIMER :  dev = dTIMER;
                         break;
        case devPEN :    dev = dPEN;
                         break;
        default:         dev = dNONE;
                         break;
    }

    // only redraw if things have changed
    if ( last_devtype != evt.devtype )
    {
        WM->msdevice().hidecursor();
        dtype->put( dev_type_labels[dev] );
        dtype->draw();
        last_devtype = evt.devtype;
        WM->msdevice().showcursor();
    }

    DecodeEventFlags( evt );
    DecodeEventTime( evt );
    DecodeEventPosition( evt );
}

//-------------------------------------------------------------//
// Task for the mKey window                                    //
//-------------------------------------------------------------//

int KeyWindowTask( mMsg& msg, mWindow& win )
{
    if( msg.noun == mEVT )
    {
       mEvent *evt = (mEvent *) msg.msgpointer();
       DecodeEvent( *evt );
    }
    return( 0 );
}

//-------------------------------------------------------------//
// Exit the sample                                             //
//-------------------------------------------------------------//

int KeyExitTask( mMsg& msg, mWnControl& ctl )
{
    if ( msg.verb == mENDEXECUTE )
    {
        (*ctl.getwind()->getwnmgr()) << mMsg( mWINDOW, mCLOSE );
        return( 1 );
    }
    return( 0 );
}

//-------------------------------------------------------------//
// Create the key display window                               //
//-------------------------------------------------------------//

mWindow *CreateKeyWindow( void )
{
    mWindow *key_win = new mWindow( "mKey Info", 0, &WM->systemfont(),
                                    mGdMgr::getdispwidth(),
                                    mGdMgr::getdispheight(), wBDRFIXED, 0 );
    key_win->setclienttask( KeyWindowTask );
    key_win->setstatus( yMODAL, 1 );
    key_win->setstyle( yDESTROY, 1 );
    key_win->setstyle( yMOVABLE, 0 );

    int xcenter = mGdMgr::getdispwidth()/2;

    // Dev Type
    dtype = new mWnCtlField( mRect( xcenter-140, 230, xcenter+140, 250 ),
                             &WM->systemfont(), "Dev Type", 10 );
    dtype->setstyle( xCURSORED, 0 );
    dtype->setstatus( xACTIVE, 0 );
    (*key_win) << (*dtype);

    // Key Type
    ktype = new mWnCtlField( mRect( xcenter-140, 200, xcenter+140, 220 ),
                             &WM->systemfont(), "Key Type", 80 );
    ktype->setstyle( xCURSORED, 0 );
    ktype->setstatus( xACTIVE, 0 );
    (*key_win) << (*ktype);

    // Value
    value = new mWnCtlField( mRect( xcenter-140, 170, xcenter+140, 190 ),
                             &WM->systemfont(), "Value", 80 );
    value->setstyle( xCURSORED, 0 );
    value->setstatus( xACTIVE, 0 );
    (*key_win) << (*value);

    // Flags
    flags = new mWnCtlField( mRect( xcenter-140, 140, xcenter+140, 160 ),
                             &WM->systemfont(), "Flags", 80 );
    flags->setstyle( xCURSORED, 0 );
    flags->setstatus( xACTIVE, 0 );
    (*key_win) << (*flags);

    // Time
    time_ctl = new mWnCtlField( mRect( xcenter-140, 110, xcenter+140, 130 ),
                            &WM->systemfont(), "Time", 10 );
    time_ctl->setstyle( xCURSORED, 0 );
    time_ctl->setstatus( xACTIVE, 0 );
    (*key_win) << (*time_ctl);

    // X Position
    xpos = new mWnCtlField( mRect( xcenter-140, 80, xcenter+140, 100 ),
                            &WM->systemfont(), "X Position", 3 );
    xpos->setstyle( xCURSORED, 0 );
    xpos->setstatus( xACTIVE, 0 );
    (*key_win) << (*xpos);

    // Y Position
    ypos = new mWnCtlField( mRect( xcenter-140, 50, xcenter+140, 70 ),
                            &WM->systemfont(), "Y Position", 3 );
    ypos->setstyle( xCURSORED, 0 );
    ypos->setstatus( xACTIVE, 0 );
    (*key_win) << (*ypos);

    // Exit button
    exit_but = new mWnCtlButton( mRect( xcenter-50, 20, xcenter+50, 40 ),
                                 &WM->systemfont(), "Exit" );
    exit_but->settask( KeyExitTask );
    (*key_win) << (*exit_but);

    return( key_win );
}

//-------------------------------------------------------------//
//                            M A I N                          //
//-------------------------------------------------------------//

int main( int argc, char *argv[] )
{
    WM = new mWindowManager;
    WM->kbdevice().set_extended( 1 );

    mWindow *key_win = CreateKeyWindow();

    (*WM) << (*key_win);

    WM->run();

    delete( WM );
    return( 0 );
}
