//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp11.Cpp                                        //
// Desc:   Sample Program 11 - Derived Controls                //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mstdhdr.h"

//--------------------------------------------------------------//

// data for a list

static char *cities[] =
{
   "Aspen",
   "Boulder",
   "Castlerock",
   "Denver",
   "Eldora",
   "Fort Collins",
   "Grand Junction",
   "Keystone",
   "Leadville",
   "Montrose",
   "Nederland",
   "Ouray",
   "Steamboat",
   "Telluride",
   "Vail",
   "Ward",
};

#define NCITIES ( sizeof(cities) / sizeof(char *) )

//--------------------------------------------------------------//

// This example shows how to customize a control class, in this
// case a combo box.  The normal list-open button to the right
// of the the display aperture is modified to appear above the
// display aperture, and contains a label instead of a symbol.

class myComboBox : public mWnCtlTextComboBox
{
   public :

      myComboBox( mRect r, mFont *fnt, char *lbl,
                      char **itms, int nitms );
};

myComboBox::myComboBox( mRect r, mFont *fnt, char *lbl,
                      char **itms, int nitms ) :
            mWnCtlTextComboBox( r, fnt, lbl, itms, nitms )
{
    // we modify the stock text combo box as follows:
    //
    // nodes[0] is display aperture plus label
    // nodes[0].txt is deleted and set to 0
    //
    // nodes[1] is the activate button.
    // nodes[1].rgn is deleted and replaced
    // nodes[1].sym is deleted and set to 0
    // nodes[1].txt is created and uses the passed label

    if( nodes[0].txt )
    {
       delete nodes[0].txt;
       nodes[0].txt = 0;
    }

    if( nodes[1].rgn )
    {
       delete nodes[1].rgn;
       nodes[1].rgn = 0;
    }

    if( nodes[1].sym )
    {
       delete nodes[1].sym;
       nodes[1].sym = 0;
    }

    // the activate button is placed above the display aperture
    // with the same width...

    mRect r0 = nodes[0].rgn->getbounds();
    mRect s( r0.xmin, r0.ymax+1, r0.xmax, r0.ymax+fnt->getcellh()+4 );
    nodes[1].rgn = new mRgnRect( s );
    nodes[1].txt = new mControlText( s, lbl, fnt, DefaultTextPen() );
}


//--------------------------------------------------------------//

int main( void )
{
    mWindowManager WM;

    mWindow wn( "MNSAMP11", 0, &WM.systemfont(),
                 400, 250, wBDRSIZABLE );

    wn <<  *( new myComboBox( mRect(  50, 150, 200, 170 ),
                              &WM.systemfont(),
                              "City...",
                              cities, NCITIES ) );

    WM << wn;

    WM.run();

    return 0;
}
