//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MnSamp10.Cpp                                        //
// Desc:   Sample Program 10 - Custom Controls                 //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//

#include "mStdHdr.h"

class xIntervalCtl : public mWnControl
{
   protected:

      mRect area;
      int   x0;
      int   x1;
      int   side;
      int   delta;

   private:

      void update( int chg );

   public:

      xIntervalCtl( mRect aR );
     ~xIntervalCtl(  ) { }

      virtual int   exec( mMsg& msg );
      virtual mMsg& xlate( mEvent& evt );
      virtual void  draw( void );
};

xIntervalCtl::xIntervalCtl( mRect aR ) : mWnControl( 5 )
{
   area = aR;
   int dxy = aR.dely() >> 1;

   // left up/down buttons
   mRect lu( aR.xmin, aR.midy(), aR.xmin+dxy, aR.ymax );
   mRect ld( aR.xmin, aR.ymin,   aR.xmin+dxy, aR.midy()-1 );
   // right up/down buttons
   mRect ru( aR.xmax-dxy, aR.midy(), aR.xmax, aR.ymax );
   mRect rd( aR.xmax-dxy, aR.ymin,   aR.xmax, aR.midy()-1 );
   // display aperture
   mRect da( lu.xmax+1, aR.ymin, ru.xmin-1, aR.ymax );

   // initialize nodes
   nodes[0].rgn = new mRgnRect( lu );
   nodes[0].sym = new mArrowCtlSym( lu>>2, DIR_UP );
   nodes[0].sts = DEFAULT_BUTTON_FLAGS;
   nodes[1].rgn = new mRgnRect( ld );
   nodes[1].sym = new mArrowCtlSym( ld>>2, DIR_DOWN );
   nodes[1].sts = DEFAULT_BUTTON_FLAGS;
   nodes[2].rgn = new mRgnRect( da );
   mRect ds = nodes[2].rgn->interior() >> 3;
   ds.ymin = ds.midy() + 2;
   nodes[2].sym = new mScaleCtlSym( ds, DIR_LEFT, 5, 4 );
   nodes[3].rgn = new mRgnRect( ru );
   nodes[3].sym = new mArrowCtlSym( ru>>2, DIR_UP );
   nodes[3].sts = DEFAULT_BUTTON_FLAGS;
   nodes[4].rgn = new mRgnRect( rd );
   nodes[4].sym = new mArrowCtlSym( rd>>2, DIR_DOWN );
   nodes[4].sts = DEFAULT_BUTTON_FLAGS;

   // initial left/right limits
   mRect di = nodes[2].rgn->interior() >> 3;
   x0 = di.xmin;
   x1 = di.xmax;
}

void xIntervalCtl::update( int chg )
{
   mRect r = nodes[2].rgn->interior() >> 3;
   int clr = nodes[2].rgn->getbrush().bfg;

   if( chg )
   {
      if( side == mLEFT )
      {
        if( (delta < 0) && (x0 > r.xmin) )
        {
           x0--;
           mGdMgr::drawline( mPoint(x0,r.ymin),
                             mPoint(x0,r.midy()),
                             8 );
        }
        else if( (delta > 0) && (x0 < x1) )
        {
           mGdMgr::drawline( mPoint(x0,r.ymin),
                             mPoint(x0,r.midy()),
                             clr );
           x0++;
        }
      }
      else if( side == mRIGHT )
      {
        if( (delta < 0) && (x1 > x0) )
        {
           mGdMgr::drawline( mPoint(x1,r.ymin),
                             mPoint(x1,r.midy()),
                             clr );
           x1--;
        }
        else if( (delta > 0) && (x1 < r.xmax) )
        {
           x1++;
           mGdMgr::drawline( mPoint(x1,r.ymin),
                             mPoint(x1,r.midy()),
                             8 );
        }
      }
   }
   else
   {
      for( int i=x0; i<=x1; i++ )
      {
         mGdMgr::drawline( mPoint(i,r.ymin),
                           mPoint(i,r.midy()),
                           8 );
      }
   }
}

void xIntervalCtl::draw( void )
{
   if ( !getstyle( xVISIBLE ) )
      return;
   mWnControl::draw();
   update( 0 );
}

mMsg& xIntervalCtl::xlate( mEvent& evt )
{
   action = mMsg( mNOTHING, mNULL );
   if( evt.devtype == devMOUSE )
   {
      if( evt.key.keytype == msPRESS )
      {
         action = mMsg( mCONTROL, mBGNSCROLL );
         switch( whichnode( evt.posn ) )
         {
            case 0 :
                 side = mLEFT;
                 delta = 1;
                 break;
            case 1 :
                 side = mLEFT;
                 delta = -1;
                 break;
            case 3 :
                 side = mRIGHT;
                 delta = 1;
                 break;
            case 4 :
                 side = mRIGHT;
                 delta = -1;
                 break;
         }
      }
      else if( (evt.key.keytype == msRELEASE) &&
               getstatus( xFOCUS ) )
      {
         action = mMsg( mCONTROL, mENDSCROLL );
      }
   }
   else if( (evt.devtype == devNULL) && getstatus(xFOCUS) )
   {
         action = mMsg( mCONTROL, mSCROLL );
   }
   return action;
}

int xIntervalCtl::exec( mMsg& msg )
{
   if ( wind->getwnmgr() != 0 )
   {
      mshide();
      switch( msg.verb )
      {
         case mBGNSCROLL :
              setstatus( xFOCUS|xIMMEDIATE, 1 );
              break;
         case mSCROLL :
              update( 1 );
              break;
         case mENDSCROLL :
              setstatus( xFOCUS|xIMMEDIATE, 0 );
              break;
      }
      msshow();
   }
   return 0;
}

int main( void )
{
    SetDefaultPalette( pDorian );

    mWindowManager WM;

    mWindow wn( "A Custom Control", 0, &WM.systemfont(),
                 400, 250, wBDRSIZABLE );

    xIntervalCtl ic( mRect(100,100,250,131) );
    wn << ic;

    WM << wn;

    WM.run();

    return 0;
}
