//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//         Copyright (c) 1991-94 - All Rights Reserved         //
//-------------------------------------------------------------//
// File:   MFV_SAMP.CPP                                        //
// Desc:   Menuet Font Viewing program                         //
// Vers:   Menuet/CPP 2                                        //
//-------------------------------------------------------------//
// NOTE:   This version of the Menuet Font Viewer does not     //
//         contain the code for printing since it requires     //
//         our Baby Driver libraries.                          //
//-------------------------------------------------------------//

// Menuet/CPP Header file
#include "mStdHdr.H"

#define TOGGLE '~'

// Strings to display and print
char *font_strings[] =
{
    "!\"#$%&'()*+,-./0123456789",
    ":;<=>?@[\\]^_`{|}~",
    "ABCDEFGHIJKLMNOPQRSTUVWXYZ",
    "abcdefghijklmnopqrstuvwxyz"
};
#define NFONTSTRINGS ( sizeof(font_strings) / sizeof(char *) )

//---------------------------------------------------------------------------//
// Menu definitions                                                          //
//---------------------------------------------------------------------------//

// Main Menu definition
char *main_menu_labels[] =
{
    "~F~ile", "~H~elp"
};

mKey main_menu_keys[] =
{
    mKey( kbOTHER, kbALTF, kbALTKEY ), mKey( kbOTHER, kbALTH, kbALTKEY )
};

#define NMAIN ( sizeof(main_menu_labels) / sizeof(char *) )
mMenuDef main_menu( main_menu_labels, main_menu_keys, NMAIN, TOGGLE );

// File Menu definition
char *file_menu_labels[] =
{
    " ~O~pen ", "", " ~Q~uit "
};

mKey file_menu_keys[] =
{
    mKey( kbOTHER, kbALTO, kbALTKEY ), mKey( 0, 0, 0 ),
    mKey( kbOTHER, kbALTQ, kbALTKEY )
};

#define NFILE ( sizeof(file_menu_labels) / sizeof(char *) )
mMenuDef file_menu( file_menu_labels, file_menu_keys, NFILE, TOGGLE );

// Help Menu definition
char *help_menu_labels[] =
{
    " ~A~bout "
};

mKey help_menu_keys[] =
{
    mKey( kbOTHER, kbALTA, kbALTKEY )
};

#define NHELP ( sizeof(help_menu_labels) / sizeof(char *) )
mMenuDef help_menu( help_menu_labels, help_menu_keys, NHELP, TOGGLE );

//---------------------------------------------------------------------------//
// Icon for About window                                                     //
//---------------------------------------------------------------------------//
unsigned char mfv_icon[] =
{
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0,  0, 13,
    13, 13,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0,
     0, 13, 13,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,
     0,  0,  0, 13, 13,  0,  0,  0, 13, 13, 13, 13,  0,  0, 13,
    13, 13, 13,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
     0,  0,  0,  0,  0, 13, 13,  0,  0,  0, 13, 13, 13, 13,  0,
     0, 13, 13, 13, 13,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13,  0,  0,  0,  0,  0, 13, 13,  0,  0,  0, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13,  0, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13,  0,  0,  0, 13, 13, 13,  0,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13,  0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13,  0,  0,  0, 13, 13, 13,  0,  0,
     0, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0, 13, 13, 13,
     0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13,  0,  0,
    13, 13,  0,  0,  0, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13,
     0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13,
     0,  0, 13, 13,  0,  0,  0, 13, 13, 13, 13,  0,  0, 13, 13,
    13, 13,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,
     0,  0,  0,  0, 13, 13,  0,  0,  0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0, 13, 13,  0,  0,  0, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13,  0, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13,  0,  0, 13, 13, 13,  0,  0, 13,  0,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13,  0,  0, 13, 13, 13,  0,  0, 13,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13,  0,  0, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0, 13,  0,  0,  0,
     0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0,
     0,  0,  0, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0, 13,  0,
     0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,  0,  0,
     0,  0,  0,  0,  0,  0,  0, 13, 13, 13, 13,  0,  0,  0,  0,
    13,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0,
    13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13,  0,  0,
     0,  0, 13,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13, 13,  0,
     0, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13,
     0,  0,  0,  0, 13,  0,  0,  0,  0, 13, 13, 13, 13, 13, 13,
    13,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13,
    13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13,
    13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,  0,
     0, 13, 13, 13, 13, 13, 13, 13,  0,  0, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13,  0,  0,  0,  0,  0,  0,  0, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13
};

//---------------------------------------------------------------------------//
// Task to close the current font window                                     //
//---------------------------------------------------------------------------//
int FontWindowExitTask( mMsg& msg, mWnControl& ctl )
{
    if ( (msg.verb == mEXECUTE) || (msg.verb == mENDEXECUTE) )
    {
        // Free the font if needed
        if ( ctl.tag == 1 )
            delete( ((mFont *)ctl.getdata()) );
        *ctl.getwind()->getwnmgr() << mMsg( mWINDOW, mCLOSE );
        return( 1 );
    }
    return( 0 );
}

//---------------------------------------------------------------------------//
// Font Info task...                                                         //
//---------------------------------------------------------------------------//
int FontInfoTask( mMsg& msg, mWnControl& ctl )
{
    if ( (msg.verb == mEXECUTE) || (msg.verb == mENDEXECUTE) )
    {
        // Open the font info window
        mFont *fnt = (mFont *)ctl.getdata();
        mWindowManager *wm = ctl.getwind()->getwnmgr();
        mFont *sfnt = &wm->systemfont();

        mWindow *win = new mWindow( "Font Info", 0, sfnt,
                                    200, 220, wBDRFIXED );
        win->setstatus( yMODAL, 1 );
        win->setstyle( yDESTROY, 1 );

        mWnCtlButton *but = new mWnCtlButton( mRect( 55, 10, 145, 35 ),
                                              sfnt, "~C~lose", TOGGLE );
        but->getnodes()->act.set( kbOTHER, kbALTC, kbALTKEY );
        but->tag = 0;
        but->settask( FontWindowExitTask );
        *win << *but;

        // Add each of the text strings with the font info
        mWnCtlText *txt_ctl;
        int         yo = 45;
        char        buffer[20];
        sprintf( buffer, "Max Char:       %i", fnt->getmaxch() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        yo += sfnt->getcellh() +5;
        sprintf( buffer, "Min Char:       %i", fnt->getminch() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        yo += sfnt->getcellh() +5;
        sprintf( buffer, "Pitch:          %i", fnt->getpitch() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        yo += sfnt->getcellh() +5;
        sprintf( buffer, "Descent:        %i", fnt->getdescent() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        yo += sfnt->getcellh() +5;
        sprintf( buffer, "Ascent:         %i", fnt->getascent() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        yo += sfnt->getcellh() +5;
        sprintf( buffer, "Cell Height:    %i", fnt->getcellh() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        yo += sfnt->getcellh() +5;
        sprintf( buffer, "Cell Width:     %i", fnt->getcellw() );
        txt_ctl = new mWnCtlText( mPoint( 15, yo ), sfnt, buffer );
        *win << *txt_ctl;

        *ctl.getwind()->getwnmgr() << *win;
        return( 1 );
    }
    return( 0 );
}

//---------------------------------------------------------------------------//
// File menu task                                                            //
//---------------------------------------------------------------------------//
void OpenFontTask( mWindowManager& wm, char *pick )
{
    // return if Cancel was selected
    if ( (pick == 0) || (*pick == 0) )
        return;

    // Load the specified font file
    mHpFont *fnt = new mHpFont( pick, 1, 255 );

    // Make sure the font file loaded okay
    if ( fnt == (mHpFont *)NULL )
    {
        char msg[90];
        sprintf( msg, "Error opening font file: %s", pick );
        wm << *notify( &wm.systemfont(), "ERROR", msg );
        return;
    }

    // Find out the optimum size for the window
    int width = wm.systemfont().stringwidth( pick ) + 40;
    int height = 0;
    int w = 0;
    for( int i=0; i<NFONTSTRINGS; i++ )
    {
        w = fnt->stringwidth( font_strings[i] );
        if ( w > width )
            width = w;
    }
    if ( width < 250 )
        width = 250;
    width += 20;
    height = fnt->getcellh() * 6 + 90;

    // Create the window for the loaded font
    mWindow *win = new mWindow( pick, 0, &wm.systemfont(),
                     width, height, wBDRFIXED, wcMINIMIZE );
    win->setstyle( yDESTROY, 1 );

    // Add the Close button
    mRect cr = win->getclientrect();
    int cx = cr.delx() / 2 + 6;
    mWnCtlButton *but = new mWnCtlButton( mRect( cx - 35, 10, cx + 35, 30 ),
                                       &wm.systemfont(), "~C~lose", TOGGLE );
    but->getnodes()->act.set( kbOTHER, kbALTC, kbALTKEY );
    but->settask( FontWindowExitTask );
    but->tag = 1;
    but->setdata( (void *)fnt );
    *win << *but;

    // Add the Info button
    cx += 80;
    but = new mWnCtlButton( mRect( cx - 35, 10, cx + 35, 30 ),
                            &wm.systemfont(), "~I~nfo", TOGGLE );
    but->getnodes()->act.set( kbOTHER, kbALTI, kbALTKEY );
    but->settask( FontInfoTask );
    but->tag = 1;
    but->setdata( (void *)fnt );
    *win << *but;

    // Add the Info button
    cx -= 160;
    but = new mWnCtlButton( mRect( cx - 35, 10, cx + 35, 30 ),
                            &wm.systemfont(), "~P~rint", TOGGLE );
    but->getnodes()->act.set( kbOTHER, kbALTP, kbALTKEY );
    but->tag = 1;
    but->setdata( (void *)fnt );
    *win << *but;

    // Add the test edit field
    int cellh = fnt->getcellh();
    int fh = 0;
    if ( cellh < 10 )
        fh = cellh * 2.5;
    else if ( cellh > 25 )
        fh = cellh * 1.5;
    else
        fh = cellh * 1.5;
    mWnCtlField *fld_ctl = new mWnCtlField(
                     mRect( 55, 40, cr.xmax - 10, fh + 40 ),
                         &wm.systemfont(), "Test:", 40 );
    fld_ctl->setfont( fnt );
    *win << *fld_ctl;

    // Add the font strings to the window
    mRect r = fld_ctl->extent();
    cr.ymin = r.ymax + 10;
    cr.ymax = cr.ymin + fnt->getcellh();
    width = cr.delx() / 2;
    mPoint p( 10, 10 );
    mWnCtlText *txt_ctl = new mWnCtlText( p, fnt, font_strings[3] );
    txt_ctl->getnodes()->txt->setbounds( cr );
    txt_ctl->getnodes()->txt->setjust( jCENTER );
    *win << *txt_ctl;

    txt_ctl = new mWnCtlText( p, fnt, font_strings[2] );
    cr += mPoint( 0, fnt->getcellh() + 5 );
    txt_ctl->getnodes()->txt->setbounds( cr );
    txt_ctl->getnodes()->txt->setjust( jCENTER );
    *win << *txt_ctl;

    txt_ctl = new mWnCtlText( p, fnt, font_strings[1] );
    cr += mPoint( 0, fnt->getcellh() + 5 );
    txt_ctl->getnodes()->txt->setbounds( cr );
    txt_ctl->getnodes()->txt->setjust( jCENTER );
    *win << *txt_ctl;

    txt_ctl = new mWnCtlText( p, fnt, font_strings[0] );
    cr += mPoint( 0, fnt->getcellh() + 5 );
    txt_ctl->getnodes()->txt->setbounds( cr );
    txt_ctl->getnodes()->txt->setjust( jCENTER );
    *win << *txt_ctl;

    wm << *win;
}

int FileMenuTask( mMsg& msg, mWnControl& ctl )
{
    static char file_path[65] = "*.HP";
    static char file_pick[65] = "";

    if ( msg.verb == mSELECT )
    {
        mWindowManager *wm = ctl.getwind()->getwnmgr();
        switch( msg.param[0] )
        {
            case 1 : // Open font file
                *wm << *create_filebox_window( &wm->systemfont(),
                 "Open Font", file_path, file_pick, OpenFontTask );
                break;
            case 3 : // Quit the application
                *wm << mMsg( mMANAGER, mCLOSE );
                return( 1 );
        }
    }
    return( 0 );
}

//---------------------------------------------------------------------------//
// Close the information window                                              //
//---------------------------------------------------------------------------//
int AboutWindowCloseTask( mMsg& msg, mWnControl& ctl )
{
    if ( (msg.verb == mEXECUTE) || (msg.verb == mENDEXECUTE) )
    {
        *ctl.getwind()->getwnmgr() << mMsg( mWINDOW, mCLOSE );
        return( 1 );
    }
    return( 0 );
}

//---------------------------------------------------------------------------//
// Help menu task                                                            //
//---------------------------------------------------------------------------//
int HelpMenuTask( mMsg& msg, mWnControl& ctl )
{
    if ( (msg.verb == mSELECT) && (msg.param[0] == 1) )
    {
        // Create the "About" window
        mWindowManager *wm = ctl.getwind()->getwnmgr();
        mFont          *sfnt = &wm->systemfont();
        mWindow *win = new mWindow( "MFV Info", 0, sfnt,
                              320, 170, wBDRFIXED, wcSYSMENU );
        win->setstatus( yMODAL, 1 );
        win->setstyle( yDESTROY, 1 );

        // Add the "close" button
        mWnCtlButton *but = new mWnCtlButton( mRect( 110, 10, 210, 35 ),
                                              sfnt, "~O~kay", TOGGLE );
        but->getnodes()->act.set( kbOTHER, kbALTO, kbALTKEY );
        but->settask( AboutWindowCloseTask );
        *win << *but;

        // Now add the text
        mWnCtlText *txt;
        mPoint      pt( 80, 40 );

        //-------------------------------------------------------
        pt.y += sfnt->getcellh() + 2;
        pt.x += 20;
        txt = new mWnCtlText( pt, sfnt, "Autumn Hill Software, Inc." );
        *win << *txt;
        //-------------------------------------------------------
        pt.y += sfnt->getcellh() + 2;
        pt.x -= 20;
        txt = new mWnCtlText( pt, sfnt,
                    "Copyright (c)1993 - 1994" );
        *win << *txt;
        //-------------------------------------------------------
        pt.y += sfnt->getcellh() + 2;
        txt = new mWnCtlText( pt, sfnt, "Version 1.0" );
        *win << *txt;
        //-------------------------------------------------------
        pt.y += sfnt->getcellh() + 2;
        txt = new mWnCtlText( pt, sfnt, "Menuet Font Viewer" );
        *win << *txt;
        //-------------------------------------------------------

        // Add the icon
        pt -= mPoint( 55, 25 );
        mWnCtlIcon *icn = new mWnCtlIcon( pt, 32, 32, mfv_icon, rgnRIDGED );
        *win << *icn;

        *wm << *win;
    }

    return( 0 );
}

//---------------------------------------------------------------------------//
// Main 'C++' routine                                                        //
//---------------------------------------------------------------------------//
int main( int argc, char*argv[] )
{
    mWindowManager *WM = new mWindowManager;

    // Create the main window
    mRect dr = mGdMgr::getdisprect();
    mWindow *wn = new mWindow( "Menuet Font Viewer",
                      &main_menu, &WM->systemfont(),
                      dr.xmax, dr.ymax, wBDRFIXED, wcSYSMENU );
    *WM << *wn;
    wn->setstyle( yDESTROY|yBACKGROUND, 1 );
    wn->setstyle( yMOVABLE, 0 );

    // Attach the sub-menus to the main menu
    mWnCtlBarMenu *mm = wn->getwnmenu();
    mWnCtlBoxMenu *file = new mWnCtlBoxMenu( &WM->systemfont(),
                                             &file_menu );
    file->settask( FileMenuTask );
    mm->setpulldown( file, 1 );
    mWnCtlBoxMenu *help = new mWnCtlBoxMenu( &WM->systemfont(),
                                             &help_menu );
    help->settask( HelpMenuTask );
    mm->setpulldown( help, 2 );

    // Run the application
    WM->run();

    delete WM;

    return 0;
}
