/*
 * FM/2 2.x associations/commands migration utility
 * copyright (c) 1994 by M. Kimes
 *
 * This program copies Commands, Associations and Registration from an
 * FM/2 1.x INI file into an FM/2 2.x INI file.  It should only be run
 * once (and INSTALL.CMD should run it for you).
 *
 * For unattended use, remove the lines marked with "NOTE:" below.
 */

/* skip clear screen if called with an argument (from INSTALL.CMD) */
'@Echo off'
arg dummy
if dummy = '' then 'cls'

/* find FM2.INI file */

fm2ini = value('fm2ini',,'OS2ENVIRONMENT')
if fm2ini \= '' then fm2ini = stream(fm2ini,'c','query exists')
if fm2ini = '' then
do
  fm2ini = value('fm2ini',,'OS2ENVIRONMENT')
  if fm2ini \= '' then
  do
    fm2ini = insert('\FM2.INI',fm2ini,length(fm2ini))
    fm2ini = stream(fm2ini,'c','query exists')
  end
end
if fm2ini = '' then fm2ini = SysSearchPath('PATH', 'FM2.INI')
if fm2ini = '' then fm2ini = SysSearchPath('DPATH', 'FM2.INI')
if fm2ini = '' then fm2ini = SysSearchPath('XPATH', 'FM2.INI')
if fm2ini = '' then
do
  say 'Sorry, FM2.INI not found.  Must not be right directory.'
  say 'Place FM2.INI in the FM/2 2.x directory and try again.'
  say 'Terminating.'
  exit
end

/* skip program intro if called with argument (from INSTALL.CMD) */
arg dummy
if dummy = '' then
do
  /* check for existing fm3.ini file so we can warn user */
  rc = stream('fm3.ini','c','query exists')
  say ''
  say 'This program migrates Associations, Commands and Registration from'
  say 'FM/2 1.x INI file ('fm2ini') to FM/2 2.x INI file.'
  if rc \= '' then
  do
    say ''
    say ' **WARNING: Information in existing 'rc' will be overwritten.'
  end
  say ''

  /* NOTE: remove 3 following lines for unattended use... */
  say 'Press [Enter].'
  pull dummy .
  say ''

end

/* load utility functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say 'Migrating Associations, Commands and Registration from FM/2 1.x...'

/* get INI info from fm2.ini */
assoc = SysIni(fm2ini, 'FM2', 'Associations')
commands = SysIni(fm2ini, 'FM2', 'Commands')
register = SysIni(fm2ini, 'FM2', 'Registration')
editor = SysIni(fm2ini,'FM2','Editor')
viewer = SysIni(fm2ini,'FM2','Viewer')
compare = SysIni(fm2ini,'FM2','Compare')
extractpath = SysIni(fm2ini,'FM2','ExtractPath')
printer = SysIni(fm2ini,'FM2','Printer')
virus = SysIni(fm2ini,'FM2','Virus')

/* write INI info to fm3.ini */
if assoc \= '' then
  if assoc \= 'ERROR:' then
    call SysIni 'FM3.INI', 'FM/3', 'Associations', assoc
if commands \= '' then
  if commands \= 'ERROR:' then
    call SysIni 'FM3.INI', 'FM/3', 'Commands', commands
if register \= '' then
  if register \= 'ERROR:' then
    call SysIni 'FM3.INI', 'FM/3', 'Registration', register
if editor \= '' then
  if editor \= 'ERROR:' then
    call SysIni 'FM3.INI','FM/3','Editor',editor
if viewer \= '' then
  if viewer \= 'ERROR:' then
    call SysIni 'FM3.INI','FM/3','Viewer',viewer
if compare \= '' then
  if compare \= 'ERROR:' then
    call SysIni 'FM3.INI','FM/3','Compare',compare
if extractpath \= '' then
  if extractpath \= 'ERROR:' then
    call SysIni 'FM3.INI','FM/3','ExtractPath',extractpath
if printer \= '' then
  if printer \= 'ERROR:' then
    call SysIni 'FM3.INI','FM/3','Printer',printer
if virus \= '' then
  if virus \= 'ERROR:' then
    call SysIni 'FM3.INI','FM/3','Virus',virus

/* tell user we're done, if no args (not called from INSTALL.CMD) */
arg dummy
if dummy = '' then say 'Complete.'
