{$i-} program wrapPCBoardDirfile;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release.  DDA
v1.00a : 1993/08/19.  Cosmetic corrections in .DOC and .DIZ files.  DDA
v1.01  : 1993/08/27.  Fixed bug: would not properly process files in
                          directories other than the current one.  DDA
v1.01a : 1993/09/09.  Added ability to set right margin (SET margin=xxx).  DDA
                      Now displays program ID & info. only if an error is
                          encountered.  (Less display "clutter".)  DDA
v1.02  : 1993/09/16.  Increased left margin flexibility: can be any width,
                          except that it cannot exceed the difference between
                          the right margin specification and 44.
                      More cosmetic work on .DOC file.  DDA
v1.03  : 1993/11/01.  Quashed minor bug: would loop if line did not wrap.  DDA
v1.04  : 1993/12/01.  Now preserves blank lines outside of descriptions.  DDA
v1.05  : 1993/12/09.  Now preserves original file date and time.  DDA
v1.06  : 1994/08/09.  Reworked source code, major overhaul - much more
                          robust and efficient (and no larger either!).
                      Now deletes control codes and box/ line drawing chars.
                      Now preserves ALL blank lines.  DDA

------------------------------------------------------------------------------}
{----
 example of a description, with two possible "prepipe|postpipe" specifications

PKZ204G.EXE    203019  02-08-93  PKZIP/PKUNZIP v2.04g; PKWare's compression
 | utilities. More, minor bug fixes relative to version 2.04e See V204G.NEW for
 | details; by Phil Katz/PKWare
 ^
 ^<- prepipe|postpipe of 1:1

PKZ204G.EXE    203019  02-08-93  PKZIP/PKUNZIP v2.04g; PKWare's compression
                               | utilities. More, minor bug fixes relative to
                               | version 2.04e See V204G.NEW for details; by
                               | Phil Katz/PKWare
    prepipe|postpipe of 31:1 ->^
}

uses dos;
const
  colon=#58;  pipe=#124;  { "pipe" is the "|" symbol, these are my  }
  hyphen=#45; space=#32;  { simple ways of minimizing typing errors }
  minwidth   = 44;        { minimum width of descriptions           }
  maxleft    = 78;        { maximum LEFT margin, including the      }
                          { spaces before and after the pipe        }
var  { GLOBAL vars }
  nostrip     : boolean;  { remove "Files: ", "Uploaded by: ", etc? }
                          { (read from a DOS environment variable)  }
  prepipe,                { spaces before the pipe                  }
  postpipe    : string;   { spaces after  the pipe                  }
  rightmargin : byte;     { right margin as a number                }

procedure showhelp(problem :byte);
{----
 If any *foreseen* errors arise, we are sent
  here to give a little help and exit (relatively) peacefully
----}
const
  progdesc = 'PCBWrap- Free DOS utility: PCBoard filelist offline reformatter.';
  author   = 'v1.06: August 9, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
  usage    = 'Usage:  PCBWrap file(s)_to_wrap [prepipe[:postpipe]] (1..79, default = 1:1)';
var
  message : string[79];
begin
  writeln(progdesc);
  writeln(author);    writeln;
  writeln(usage);     writeln;
  if problem > 0 then begin
    case problem of
      1 : message := 'The difference between the right and left margins must be 44 or greater.';
      2 : message := 'The second parameter is NOT a valid numeric!';
      3 : message := 'No files found.  First parameter must be a valid file specification.';
      6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message := 'Error opening, closing, or renaming a file.  Original may be renamed!';
    else  message := 'Unknown error.';
    end;
    writeln('Error encountered:'); writeln(message);
  end;
  halt(problem);
end;

procedure iocheck(iores :byte);
begin
  if iores <> 0 then showhelp(7);
end;

procedure openfiles(var file_in, file_out :text; name1, name2 :string);
begin
  assign(file_in,name1);
  reset(file_in);         iocheck(ioresult);
  assign(file_out,name2);
  rewrite(file_out);      iocheck(ioresult);
end;

function get_rightmargin :byte;
const
  default_rm = 78;        { default RIGHT margin }
var
  rm       : shortint;    { right margin as an integer }
  valerr   : integer;     { used when converting env var "margin" to number }
begin
  val (getenv('margin'), rm, valerr);
  if (valerr <> 0)
    then rm := default_rm
  else
    if NOT rm in [minwidth+3..minwidth+3+maxleft]
       then rm := default_rm;
  get_rightmargin := rm;
end;

procedure create_string(digits :string; var longstr :string);
{---- Create a string ("longstr") "digits"/"slen" in length ----}
var
  slen     : byte;        { numeric of string containing numbers needed   }
  pcode    : integer;     { error code:
                            will be non-zero if strings are not numbers   }
begin
  val(digits, slen, pcode);
  if (pcode <> 0) then
    showhelp(1);   { out of range }
  if NOT slen in [1..maxleft] then
    showhelp(2);     { numeric conversion error }
  longstr[0] := chr(slen);
  fillchar(longstr[1], slen, space);
end;

function get_leftmargin(var ppre, ppost :string) :byte;
{----
  Determine number of spaces to put before and after the pipe character
   (based on the second command line parameter, or a default)
----}
var
   pstr     : string[5];  { entire string containing numbers needed       }
begin
{----
  If the second parameter has a colon, the number before the colon will be
   "ppre", and the number after will be "ppost".
  If a colon is not present, ppre should be entire parameter (ppost=1).
----}
  pstr := paramstr(2); {first parameter is filespec, second is dimensions}
  if ((pos(colon,pstr)) > 1) then
  begin
    create_string (copy(pstr,1,((pos(colon,pstr))-1)),ppre);
    create_string (copy(pstr,((pos(colon,pstr))+1),length(pstr)),ppost);
  end
  else
    create_string (pstr,ppre);
  get_leftmargin:=length(ppre+pipe+ppost);
end;

function squeezestr(longstr :string) :string;
{---- Remove extra spaces, low and most of high ASCII, and leading pipes ----}
var newstr : string;
    index  : byte; { hold our place in string }
begin
  newstr := longstr;
  for index := 1 to length(newstr) do  {strip box/line chars, control codes}
    if ord(newstr[index]) in [0..31,169,170,174..223,240..245,247..250,254,255]
      then newstr[index] := space;
  while (length(newstr) > 1)
    and (pos(space+space,newstr) <> 0) do
      delete(newstr,pos(space+space,newstr),1);
  while (newstr <> '')
    and (newstr[length(newstr)]=space) do
      dec(newstr[0]);
  while (newstr <> '')
    and (newstr[1] in [space, pipe]) do
      delete(newstr,1,1);
  squeezestr := newstr;
end;

function wrapline(var thefile :text; theline :string) :string;
{---- Split line after rightmargin character or nearest preceding space ----}
var
  parta,partb  : string;    { first and second part of line }
  breakchar    : string[1]; { character which will eventually be a space }
  breakfound   : boolean;
  breakpos     : byte;
begin
  breakpos   := rightmargin+2;
  breakfound := false;
{----
  Search for a space or a hyphen or the ASCII 255 non-displaying char,
   by decrementing the breakpos while checking validity
----}
  while ((NOT breakfound) AND (breakpos > length(prepipe+postpipe)+2)) do
  begin
    dec(breakpos);
    breakfound := theline[breakpos] in [space,hyphen,#255];
  end;
  if NOT breakfound {if unable to find a valid breakpoint, break at max width}
    then breakpos:=rightmargin+1;

  parta     := copy(theline,1,breakpos-1);
  partb     := copy(theline,breakpos+1,length(theline)-(breakpos));
  breakchar := theline[breakpos];

  if NOT (breakchar[1] in [space, #255]) then {save non-blank breakchar}
     if breakpos <= rightmargin then parta := parta+breakchar
                                else partb := breakchar+partb;
{----
  Write the first part to the file,
   and then return the second part (after adding prepipe and postpipe).
----}
  writeln (thefile,parta);
  wrapline := (prepipe+pipe+postpipe+partb);
end;

procedure process_line(var nextline, thisline :string);
const
  files1 = 'Files: ';           {7}
  files2 = '(Files: ';          {8}
  uplby1 = 'Uploaded by: ';    {13}
  uplby2 = 'Uploaded By: ';    {13}
  dcount = 'Download Count: '; {16}
begin
{----
  First remove upload status lines (unless otherwise instructed),
  then remove spaces ("squeezestr" function)
---}
  if (not (nostrip)) and (ord(nextline[0]) > 40) then
    if ((pos(files1,nextline) = 34) or
        (pos(files2,nextline) = 34) or
        (pos(uplby1,nextline) = 34) or
        (pos(uplby2,nextline) = 34) or
        (pos(dcount,nextline) = 34)) then { remove that description line }
     nextline:=copy(nextline,1,33);
{----
 If the next line still exists, then join current and next line with a
  space between them for a word delimiter.  However, if the last char of
  the current line is a hyphen, and the character preceding it is -not-
  a space, then DO NOT add a space.  This is to force hyphenated words
  to reconnect (eg. "hyphen-ation" instead of "hyphen- ation").
----}
  nextline := squeezestr(nextline);
  if ((thisline[length(thisline)] <> space) and
      (length(nextline) > 0)) then
    if NOT ((thisline[length(thisline)] = hyphen) and
            (thisline[length(thisline)-1] <> space))
      then thisline:=thisline+space;

  thisline:=thisline+nextline;
end;

function isfirstline(currentline :string) :boolean;
var isfirst : boolean;    { is this the first line of a file desc?   }
  valsize   : longint;    { filesize }
  valcode   : integer;    { will give error if filesize not a number }
begin
{----
  Determine a valid first line by looking for a non-space/ control char in
   the first position, and verifying file size, date, and proper spacing
   between the size and date (file size is a number in columns 15-21).
----}
  isfirst := false;
  if ((length(currentline) > 30) and (currentline[1] > space)) then begin
     val(copy(currentline,15,7),valsize,valcode);
     if (valcode = 0) then
       isfirst:=((currentline[26] = hyphen) and (currentline[29] = hyphen) and
                 (currentline[22] = space)  and (currentline[23] = space));
  end;
  isfirstline:=isfirst;
end;

procedure makenewfile(var source, dest :text); { actually rewrite the file }
var
  crnline,                { the line currently on hold, already processed }
  freshline : string;     { the line just read, now being processed       }
  indesc,                 { have we found a first line of a description ? }
  first     : boolean;    { if this is first line of FILE, do NOT write   }
                          { it to a new file unless it is the beginning   }
                          { of a new description                          }
begin
  first   := true;        { Initialize some vars... }
  indesc  := false;
  repeat
    fillChar(freshline,sizeof(freshline),0);     { clear out old line !!! }
    readln(source,freshline);
    if ((freshline[1] = space) and indesc) then {Process description line }
      process_line(freshline,crnline)    { Join lines and pack the result }
    else begin { First char not a space, or not processing a description, }
      if (NOT first) then
        writeln(dest,crnline); {just write the processed line, and move on}
      crnline := freshline;
      indesc := isfirstline(crnline);  { Perhaps it starts a new filedesc }
      if indesc then                 { YES!, we are in a new description! }
        crnline := copy(crnline,1,31)+'  '+
        squeezestr(copy(crnline,34,length(crnline)-33)); {pack description}
    end;
    if indesc then while length(crnline) > rightmargin do
                                crnline := wrapline(dest,crnline);
    first := false;
  until eof(source);             { loop back to read another line - PHEW! }
  writeln(dest,crnline);       { last line of file, was already processed }
end;

{---- TYPEs, CONSTs and VARs for "main" program ----}
type
  link = ^node;
  node = record
           name : string[12];
           next : link;
         end;
const
  destfname = 'pwraptmp.dst';
  tempfname = 'pwraptmp.tmp';
var
  dirinfo   : searchrec;  { contains filespec info.    }
  spath     : pathstr;    { source file path,          }
  sdir      : dirstr;     {             directory,     }
  sname     : namestr;    {             name,          }
  sext      : extstr;     {             extension.     }
  sfn,dfn,tfn : pathstr;  { Source/ Dest/ Temp FileName, including dir }
  infile, outfile : text; { files read from/ written to                }
  filedt    : longint;    { file date and time, to preserve original   }
  numdone   : word;       { numdone is number of files wrapped         }
{----
  The boolean var "done" and pointers (type of 'link') of "anchor" and
   "chain" are used to cope with a bothersome quirk of DOS (I think),
   which allows "findnext" to find files more than once (under certain
   circumstances).  This quirk seems to be due to the order of the file
   names in the FAT, which is altered when a file is written to disk and
   then renamed.
----}
  done      : boolean;
  anchor, chain : link;

{---- BEGIN the "main" program ----}
begin
{----
  Initialize some variables.
  Prepipe and postpipe begin as single spaces.
  The user must pass a filename (first parameter), and
  may optionally pass a margin specification (second parameter),
   which must allow at least 44 characters for the description.
----}
  if NOT (paramcount in [1..2]) then showhelp(0);
  nostrip := (getenv('nostrip') = 'true');
  numdone := 0;
  new (anchor);
  anchor^.name := '';
  anchor^.next := nil;

{---- Get margin specifications ----}
  rightmargin:=get_rightmargin;
  prepipe  := space;
  postpipe := space;
  if (paramcount = 2) then
    if ((rightmargin-(get_leftmargin(prepipe,postpipe))) < minwidth) then
      showhelp(1);

{---- Get file specification ----}
  spath := paramstr(1);
  if spath[1] in ['/','-'] then showhelp(0);
  fsplit(fexpand(spath),sdir,sname,sext); if (sname = '')  then showhelp(6);
  findfirst(spath, archive, dirinfo);     if doserror <> 0 then showhelp(3);
  dfn := sdir+destfname;
  tfn := sdir+tempfname;

{---- Okay, let's go! ----}
  while doserror = 0 do
  begin
    done := false;                 { initialize for each "new" file found }
    chain:=anchor;             { check if file was processed file already }
    while ((chain^.next <> nil) and (NOT done)) do
        if (chain^.name = dirinfo.name) then done := true
                                       else chain := chain^.next;

{---- Only process if not processed before ----}
    if NOT done then begin
      inc(numdone);
      new(chain);
      chain^.name:=dirinfo.name;  { add current name to beginning of list }
      chain^.next:=anchor;
      anchor:=chain;

{---- Process the file! ----}
      sfn := sdir+dirinfo.name;
      write('Wrapping ',sfn);    { tell user this file is being processed }
      openfiles(infile,outfile,sfn,dfn);
      makenewfile(infile,outfile);
      writeln(', done!');        { tell user this file has been processed }
{----
  Swap file names, preserving the original date and time
   (need to "flush" file so new date/ time sticks)
----}
      getftime (infile, filedt);
       close (outfile);    iocheck(ioresult);
       reset (outfile);    iocheck(ioresult);
      setftime (outfile, filedt);
       close (infile);     iocheck(ioresult);
       close (outfile);    iocheck(ioresult);
      rename(infile,tfn);  iocheck(ioresult);
      rename(outfile,sfn); iocheck(ioresult);
      erase (infile);      iocheck(ioresult);
    end;
    findnext(dirinfo);
  end;                  { now loop back with name of next file to process }
  repeat  { dispose of pointers - not necessary at end, but good practice }
    chain:=anchor^.next;
    dispose (anchor);
    anchor:=chain;
  until (anchor = nil);
  writeln('PCBWrapped ',numdone,' file(s).');
end.
