############################################################################
#
# Name: EDB2.INC
#
############################################################################
#		Copyright (C) 1990-1993 Easel Corporation
#		All Rights Reserved.
#
#		NOTICE - PROPRIETARY AND CONFIDENTIAL
#  This computer program is and contains trade secret and confidential
#  and proprietary information of Easel Corporation.  All use, disclosure,
#  and/or reproduction not specifically authorized in writing by Easel
#  Corporation is prohibited.  This program may also be protected under
#  the copyright and trade secrets laws of countries other than the U.S.A.
#
#		RESTRICTED RIGHTS LEGEND
#  Use, duplication, or disclosure by the Government is subject to
#  restrictions as set forth in subparagraph (c) (ii) of the Rights in
#  Technical Data and Computer Software clause at DFARS 252.227-7013
#  or subparagraphs (c) (1) and (2) of Commercial Computer Software --
#  Restricted Rights at 48 CFR 52.227-19, as applicable.
#
#  Easel Corporation, 25 Corporate Drive, Burlington, MA 01803, U.S.A.
#
#
#  EASEL, EASEL/2, EASEL/Win, and EASEL Workbench are Registered
#  Trademarks (R); EASEL Renovator Plus, Enterprise Workbench, EASEL/DOS,
#  EASEL/32 and DB/Assist are Trademarks (TM), of Easel Corporation,
#  Burlington, Massachusetts.
############################################################################

#-------------------------------------------------------------------
# EASEL constants and generally useful variable definitions 
#--------------------------------------------------------------------

#
# EDB2 Messages sent to EASEL/2
#
integer constant EDB2_OK       is 0
integer constant EDB2_ERROR    is 1
integer constant EDB2_STARTED  is 2

#
# EASEL Data Types
#
integer constant ESL_STRING   is 0
integer constant ESL_INTEGER  is 1
integer constant ESL_FLOAT    is 2


#
# SQLCODE Constants
#
integer constant SUCCESS        is 0         # Successful execution
integer constant END_OF_DATA    is 100       # Data not found 
integer constant CURSOR_CLOSED  is -501      # Cursor is closed
integer constant NOT_UNIQUE     is -803      # Row is not unique
integer constant MULTIPLE_ROWS  is -811      # Result is multiple rows 
integer constant DEADLOCK       is -911      # Run unit rolled back due to deadlock
integer constant DBM_NOT_STARTED   is -1032  # Database Manager Not Started
integer constant ALREADY_CONNECTED_THISDB is -1098  # Already Connected to This DB
integer constant ALREADY_CONNECTED_SOMEDB is -1047  # Already Connected to Another DB

#
# Access Mode indicators for DB Mgr
#
integer SQL_USE_SHR is 0
integer SQL_USE_EXC is 1

#
# Bind Option DateTime Values
#
integer   SQL_FMT_0    is    0    # FORMAT = Default for Country Code
integer   SQL_FMT_1    is    1    # FORMAT = USA   
integer   SQL_FMT_2    is    2    # FORMAT = EUR   
integer   SQL_FMT_3    is    3    # FORMAT = ISO   
integer   SQL_FMT_4    is    4    # FORMAT = JIS   
integer   SQL_FMT_5    is    5    # FORMAT = LOCAL 

#
# Bind Option IsolationLevel Values
#
integer   SQL_REP_READ	    is	  0	# Repeatable read level  
integer   SQL_CURSOR_STAB   is	  1	# Cursor stability level 
integer   SQL_UNCOM_READ    is	  2	# Uncommitted read level 

#
# Bind Option RecordBlocking Values
#
integer   SQL_BL_UNAMBIG    is	  0	# Block Unambiguous cursors 
integer   SQL_BL_ALL	    is	  1	# Block All cursors 
integer   SQL_NO_BL	    is	  2	# Block No cursors 


#-------------------------------------------------------------------
# Structure Type Declarations
#--------------------------------------------------------------------

#
# Database Directory Information
#
#

structure DIR_ENTRY is
 string  Alias        using string  size 9        # Alias name         
 string  Dbname       using string  size 9        # Database name      
 string  Nodename     using string  size 9        # Node name             
 string  Dbtype       using string  size 21       # Release information   
 string  Comment      using string  size 31       # Comment               
 integer Com_codepage using integer size 2        # Code page of comment  
 string  Type         using string  size 1 format "nonull"  # Entry type defines above
end structure 

#
# Table Information
#
#

structure TABLE_ROW is
    string  Name       using string  size 19
    string  Qualifier  using string  size 9
    integer Parents    using integer size 2
    integer Children   using integer size 2
    integer Selfrefs   using integer size 2
    integer Keycolumns using integer size 2
end structure

#
# Column Information
#
#

structure COLUMN_ROW is
    string   Sqlname    using string  size 19  # Column name
    string   Coltype    using string  size 9   # Column data type
    string   Nulls      using string  size 2   # Nullable rule:
                                               # Y=nullable
                                               # N=Not nullable
                                               # D=Not nullable with default
    integer  Length     using integer size 2   # Length in bytes 
    integer  Scale      using integer size 2   # Scale for Decimals 0 if not decimal 
    integer  Colno      using integer size 2   # Numerical place within table/view 
    integer  Keyseq     using integer size 2   # If a primary key column, this is the
                                               # position of this column within the key
end structure


#
# Index Column Information
#
#

structure INDEX_COL is
    string   IXorder        using string  size 2     # "A"scending or "D"escending order
    string   IXcolname      using string size 19     # Index key column name
end structure

 
#
# Index Information
#
#

structure INDEX_ROW is
    string   IXname         using string  size 19    # Index name
    string   IXcreator      using string  size 9     # Index creator
    string   IXuniquerule   using string  size 2     # Unique rule
    integer  IXcolcount     using integer size 2     # Number of columns in key
    structure INDEX_COL     IXarray[12]              # Array of index key column structures
end structure
 

#
# Primary Key Information
#
#

structure PKEY_ROW is
    string   PKeyName   using string  size 19  # Primary key column name
    string   PKeyType   using string  size 9   # Primary key column type
    integer  PKeyLen    using integer size 2   # Primary key length
    integer  PKeyScale  using integer size 2   # Primary key scale (decimal only)
    integer  PKeySeq    using integer size 2   # Primary key sequence 
end structure

#
# Foreign Key Information
#
#

structure FKEY_ROW is
    string   FKeyrelname   using string  size 9  # Foreign key relationship name
    string   FKeyreftbname using string  size 19 # Name of parent table
    string   FKeyreftbcreator using string  size 9  # Qualifier of parent table
    integer  FKeycolcount  using integer size 2     # Number of columns in foreign key
    string   FKeycolnames[12] using string size 19  # Array of foreign key column names
end structure
 
#
# Relationship Information
#
#

structure REL_ROW is
    string   Relname       using string  size 9  # Relationship name
    string   Parentname    using string  size 19 # Name of parent table
    string   Parentcreator using string  size 9  # Qualifier of parent table
    string   Childname     using string  size 19 # Name of child table
    string   Childcreator  using string  size 9  # Qualifier of child table
    integer  Keycolcount  using integer size 2     # Number of columns in foreign key
    string   FKeycolnames[12] using string size 19  # Array of foreign key column names
    string   PKeycolnames[12] using string size 19  # Array of primary key column names
end structure
 

structure SQLOPT is
    integer        DateTimeFormat           # Date and Time Format
    integer        IsolationLevel           # Isolation Level 
    integer        RecordBlocking           # Type of record blocking
end structure


#-------------------------------------------------------------------
# EDB2 Services Subroutines and Functions
#--------------------------------------------------------------------

#
# Check to see if EDB2.DLL got loaded successfully; returns 1 if
# successful and 0 if unsuccessful. If 0, it's probably because DB2/2
# is not present on the workstation
#
function EDB2RUThere( )
                    returns integer
                    library "edb2"



#
# START DATABASE MANAGER  
#
subroutine EDB2StartDBM() library "EDB2"


#
# CONNECT TO DATABASE  
#
subroutine EDB2Connect(
		    string : Database,
                    integer: Use,
                    structure ESQLCA: Sqlca
                    )
		    library "EDB2"

#
# DISCONNECT FROM DATABASE  
#
subroutine EDB2Disconnect(structure ESQLCA: Sqlca)
		    library "EDB2"
 
#
# GET ERROR MESSAGE
#
subroutine EDB2Error(
                   string : Error,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"

#
# GET DATABASE DIRECTORY
#
subroutine EDB2DBDirectory(
                   integer : Maxrows,
                   integer : Numrows,
                   structure DIR_ENTRY: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"
#
# GET TABLE NAMES
#
subroutine EDB2GetTableNames(
                   integer : Maxrows,
                   integer : Numrows,
                   structure TABLE_ROW: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"

#
# GET COLUMN INFO
#
subroutine EDB2GetColInfo(
                   string: Tablename,
                   string: Qualifier,
                   integer : Maxrows,
                   integer : Numrows,
                   structure COLUMN_ROW: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"
#
# GET INDEX INFO
#
subroutine EDB2GetIndexInfo(
                   string: Tablename,
                   string: Qualifier,
                   integer : Maxrows,
                   integer : Numrows,
                   structure INDEX_ROW: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"
#
# GET PRIMARY KEYS
#
subroutine EDB2GetPrimaryKeys(
                   string: Tablename,
                   string: Qualifier,
                   integer : Maxrows,
                   integer : Numrows,
                   structure PKEY_ROW: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"

#
# GET FOREIGN KEYS
#
subroutine EDB2GetForeignKeys(
                   string: Tablename,
                   string: Qualifier,
                   integer : Maxrows,
                   integer : Numrows,
                   structure FKEY_ROW: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"

#
# GET RELATIONSHIPS
#
subroutine EDB2GetRelationships(
                   integer : Maxrows,
                   integer : Numrows,
                   structure REL_ROW: Array,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"
#
# BIND WITH OPTIONS
#
subroutine EDB2Bind(
                   string          : Bindfile,
                   string          : Database,
                   structure SQLOPT: Sqlopt,
                   structure ESQLCA: Sqlca
		   )
                   library "EDB2"




#-------------------------------------------------------------------
# EDB2 Runtime Subroutines and Functions
#--------------------------------------------------------------------

#
# EDB2Allocate -- Allocates an internal SQLDA.
#
function EDB2Allocate(
                    small integer : Sqlda_id,
                    small integer : Sqld,
                    small integer : Stmt_id
                   ) returns integer
                    library "edb2"

#
# EDB2CALL -- Call Database Manager to execute an SQL statement. 
#
function EDB2Call(
                    integer : Call_type,
                    integer : Section_number,
                    integer : Input_sqlda_id,
                    integer : Output_sqlda_id
                   ) returns integer
                    library "edb2"

#
# EDB2DEALLOCATE -- Deallocates internal SQLDAs previously allocated by SQLAALOC
#
subroutine EDB2Deallocate(integer : Sqlda_id)
                    library "edb2"

#
# EDB2SETSTATEMENT -- Generate this call when an SQL statement contains the name
#             of a host variable used to store statement text, as in 
#             dynamic SQL statements PREPARE and EXEC IMMEDIATE.
#
subroutine EDB2SetStatement(string  : Sql_text)
                    library "edb2"


#
# EDB2SETVARIABLE --  Use SQLSETV after SQLALOC allocation call to initialize field
#              of a SQLDA SQLVAR element to the type, length, and address of
#              a host variable found in an SQL statement.
#
function   EDB2SetVariable(
                    small integer    : Sqlda_id,
                    small integer    : Sqlvar_index,
                    small integer    : Esltype,
                    small integer    : Collen,    # length of database column
                    reference        : Esldata,   # -> untyped EASEL variable      
                    integer reference: Eslind     # -> integer null indicator
                   )
                    returns integer
                    library "edb2"



#
# EDB2STOP -- Releases the semaphore obtained by SQLASTRT.
#
subroutine EDB2Stop()
                    library "edb2"

#
# EDB2START -- Obtains a global semaphore to serialize thread access to 
#             Run Time Services
#
subroutine EDB2Start(
                    integer : Array,
                    structure ESQLCA : Sqlca
                   ) 
                    library "edb2"


#
# EDB2USERSQLDA -- Stores the address of a user specified input or output SQLDA
#             in Run Time Services.
#
function EDB2UserSQLDA(
                    integer : Sqlda_id,
                    structure ESQLDA_STRUCT : Sqlda
                   ) returns integer
                    library "edb2"

#
# EDB2Commit -- Commit changes to the database
#
subroutine EDB2Commit(structure ESQLCA : Sqlca
                     ) 
                       library "edb2"


#
# EDB2Rollback -- Rollback changes to the database
#
subroutine EDB2Rollback(structure ESQLCA : Sqlca
                       )
                         library "edb2"


#-------------------------------------------------------------------
# Default Error Routine for Runtime Services
#--------------------------------------------------------------------
action EDB2WheneverError is
    call EDB2Error(EDB2ErrorMessage_SV,Esqlca)
    send "EDB2 Whenever Error: " EDB2ErrorMessage_SV to errorlog
    send "\n******** SQLCA ************" to errorlog
    send "\n  Sqlcaid  = "         to errorlog
    send Esqlca.Sqlcaid            to errorlog
    send "\n  Sqlcabc  = "         to errorlog
    send Esqlca.Sqlcabc            to errorlog
    send "\n  Sqlcode  = "         to errorlog
    send Esqlca.Sqlcode            to errorlog
    send "\n  Sqlerrml = "         to errorlog
    send Esqlca.Sqlerrml           to errorlog    
    send "\n  Sqlerrmc = "         to errorlog
    send Esqlca.Sqlerrmc           to errorlog    
    send "\n  Sqlerrp  = "         to errorlog
    send Esqlca.Sqlerrp            to errorlog
    send "\n  Sqlerrd[]= "         to errorlog
    send Esqlca.Sqlerrd[1]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlerrd[2]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlerrd[3]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlerrd[4]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlerrd[5]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlerrd[6]         to errorlog
    send "\n  Sqlwarn[]= "         to errorlog
    send Esqlca.Sqlwarn[1]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[2]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[3]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[4]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[5]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[6]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[7]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[8]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[9]         to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[10]        to errorlog
    send ", "                      to errorlog
    send Esqlca.Sqlwarn[11]        to errorlog
    send "\n  Sqlstate   = "       to errorlog
    send Esqlca.Sqlstate           to errorlog
    send "\n"                    to errorlog
    call EDB2Rollback(Esqlca)                 
    send "Database Rolled Back\n\n"  to errorlog



