// Dialogs for Spatial Explorer, Ver. 1.0 for Windows.
// All rights reserved (C) copyright Schreiber Instruments, 1994
//
// dialog box for fence command
fencer : dialog {
  key="fence_options";
  label="Define Intervals";
  : row {
    : column {
      : boxed_column {
        : button { label="QSB Load.."; key="qsb_load";
                   width=12; }
        : button { label="ASCII Load.."; key="ascii_load";
                   width=12; }
        : button { label="Load Setup.."; key="slc_load";
                   width=12; }
        : button { label="Save Setup.."; key="slc_save";
                   width=12; }
      }
      : text { key="tell_user"; }
    }
    : spacer { width=1; fixed_width=true; }
    : boxed_row {
      : column {
        : text { value="Top:"; }
        : popup_list { key="pick_top";
                       width=20; fixed_width=true; }
        : text { value="Bottom:"; }
        : popup_list { key="pick_bot";
                       width=20; fixed_width=true; }
        : text { value="Layer:"; }
        : popup_list { key="slc_layer";
                       width=20; fixed_width=true; }
      }
      : spacer { width=1; fixed_width=true; }
      : column {
        : spacer { height=1; fixed_height=true; }
        : row {
          : button { label="Color.."; key="top_bot_color";
                     width=8; fixed_width=true; }
          : text { key="chosen_color";
                   width=9; fixed_width=true; }
        }
        : row {
          : button { label="Hatch.."; key="top_bot_hatch";
                     width=8; fixed_width=true; }
          : text { key="chosen_hatch";
                    width=9; fixed_width=true; }
        }
        : spacer { height=1; fixed_height=true; }
        : button { label="Accept"; key="accept_entry";
                   width=8; fixed_wdth=true; }
      }
    }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : column {
      : row {
        : text { key="txt_top"; width=15; value="Top"; }
        : text { key="txt_bot"; width=15; value="Bottom"; }
        : text { key="txt_fence_layer"; width=12; value="Layer"; }
        : text { key="txt_fence_color"; width=7; value="Color"; }
        : text { key="txt_fence_hatch"; width=10; value="Hatch"; }
      }
      : list_box {
        key="fence_spec";
        width=63; fixed_width=true;
        height=6; fixed_height=true;
        multiple_select=true;
		tabs="16 32 45 53";
      }
      : row {
        : button { label="Delete Selected"; key="delete_select";
                   width=13; fixed_width=true; }
        : button { label="Delete All"; key="delete_all";
                   width=13; fixed_width=true; }
        : button { label="Edit Selected"; key="edit";
                   width=13; fixed_width=true; }
      }
    }
    : column {
      : spacer { height=1; fixed_height=true; }
      : button { label="Surfaces.."; key="draw_surf";
                 width=11; fixed_width=true; }
      : button { label="Wells.."; key="draw_wells";
                 width=11; fixed_width=true; }
      : button { label="Options.."; key="options";
                 width=11; fixed_width=true; }
      : spacer { height=1; fixed_height=true; }
    }
  }
  : spacer { height=1; fixed_height=true; }
  ok_cancel_help;
}

// Dialog for cap specification
capper : dialog {
  label="Surfaces to Draw";
  : boxed_row {
    : column {
      : text { value="Surface:"; }
      : popup_list { key="pick_cap";
                     width=20; fixed_width=true; }
      : text { value="Layer:"; }
      : popup_list { key="slc_layer";
                     width=20; fixed_width=true; }
    }
    : spacer { width=1; fixed_width=true; }
    : column {
      : spacer { height=1; fixed_height=true; }
      : row {
        : button { label="Color.."; key="cap_color";
                   width=8; fixed_width=true; }
        : text { key="chosen_color";
                 width=15; fixed_width=true; }
      }
      : spacer { height=1; fixed_height=true; }
      : button { label="Accept"; key="accept_entry";
                 width=8; fixed_wdth=true; }
    }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : text { key="txt_surface"; width=23; value="Surface"; }
    : text { key="txt_layer"; width=13; value="Layer"; }
    : text { key="txt_color"; width=12; value="Color"; }
  }
  : list_box {
    key="cap_spec";
    width=50; fixed_width=true;
    height=3; fixed_height=true;
    tabs="24 38";
    multiple_select=true;
  }
  : row {
    : button { label="Delete Selected"; key="delete_select";
               width=15; fixed_width=true; }
    : button { label="Delete All"; key="delete_all";
               width=15; fixed_width=true; }
  }
  : spacer { height=1; fixed_height=true; }
  : toggle { label="Include Original Data Points as Vertices";
             key="orig_pts"; }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=10; fixed_width=true; }
    ok_button;
    : spacer { width=5; fixed_width=true; }
    help_button;
    : spacer { width=10; fixed_width=true; }
  }
}


//  The following are for the color-selection dialogs

gswatch : image_button {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = true;
    height = 0.7;
    width = 1.5;
}

gh_color :column{
    :column {
        :boxed_row {
            fixed_width = true;
            label = /*MSG13*/"Standard Colors";
            color_palette_1_9;
        }
        :row {
            :boxed_row {
                fixed_width = true;
                label = /*MSG14*/"Gray Shades";
                color_palette_250_255;
            }
            :boxed_row {
                fixed_width = true;
                label = /*MSG15*/"Logical Colors";
                :button {
                    label = /*MSG16*/"BYLAYER";
                    mnemonic = /*MSG17*/"L";
                    key = "256";
                }
                :button {
                    label = /*MSG18*/"BYBLOCK";
                    mnemonic = /*MSG19*/"B";
                    key = "000";
                }
            }
        }
    }
    :boxed_column {
        label = /*MSG20*/"Full Color Palette";

  : row {
    : gswatch { color=018; key="018"; }
    : gswatch { color=028; key="028"; }
    : gswatch { color=038; key="038"; }
    : gswatch { color=048; key="048"; }
    : gswatch { color=058; key="058"; }
    : gswatch { color=068; key="068"; }
    : gswatch { color=078; key="078"; }
    : gswatch { color=088; key="088"; }
    : gswatch { color=098; key="098"; }
    : gswatch { color=108; key="108"; }
    : gswatch { color=118; key="118"; }
    : gswatch { color=128; key="128"; }
    : gswatch { color=138; key="138"; }
    : gswatch { color=148; key="148"; }
    : gswatch { color=158; key="158"; }
    : gswatch { color=168; key="168"; }
    : gswatch { color=178; key="178"; }
    : gswatch { color=188; key="188"; }
    : gswatch { color=198; key="198"; }
    : gswatch { color=208; key="208"; }
    : gswatch { color=218; key="218"; }
    : gswatch { color=228; key="228"; }
    : gswatch { color=238; key="238"; }
    : gswatch { color=248; key="248"; }
  }

  : row {
    : gswatch { color=016; key="016"; }
    : gswatch { color=026; key="026"; }
    : gswatch { color=036; key="036"; }
    : gswatch { color=046; key="046"; }
    : gswatch { color=056; key="056"; }
    : gswatch { color=066; key="066"; }
    : gswatch { color=076; key="076"; }
    : gswatch { color=086; key="086"; }
    : gswatch { color=096; key="096"; }
    : gswatch { color=106; key="106"; }
    : gswatch { color=116; key="116"; }
    : gswatch { color=126; key="126"; }
    : gswatch { color=136; key="136"; }
    : gswatch { color=146; key="146"; }
    : gswatch { color=156; key="156"; }
    : gswatch { color=166; key="166"; }
    : gswatch { color=176; key="176"; }
    : gswatch { color=186; key="186"; }
    : gswatch { color=196; key="196"; }
    : gswatch { color=206; key="206"; }
    : gswatch { color=216; key="216"; }
    : gswatch { color=226; key="226"; }
    : gswatch { color=236; key="236"; }
    : gswatch { color=246; key="246"; }
  }

  : row {
    : gswatch { color=014; key="014"; }
    : gswatch { color=024; key="024"; }
    : gswatch { color=034; key="034"; }
    : gswatch { color=044; key="044"; }
    : gswatch { color=054; key="054"; }
    : gswatch { color=064; key="064"; }
    : gswatch { color=074; key="074"; }
    : gswatch { color=084; key="084"; }
    : gswatch { color=094; key="094"; }
    : gswatch { color=104; key="104"; }
    : gswatch { color=114; key="114"; }
    : gswatch { color=124; key="124"; }
    : gswatch { color=134; key="134"; }
    : gswatch { color=144; key="144"; }
    : gswatch { color=154; key="154"; }
    : gswatch { color=164; key="164"; }
    : gswatch { color=174; key="174"; }
    : gswatch { color=184; key="184"; }
    : gswatch { color=194; key="194"; }
    : gswatch { color=204; key="204"; }
    : gswatch { color=214; key="214"; }
    : gswatch { color=224; key="224"; }
    : gswatch { color=234; key="234"; }
    : gswatch { color=244; key="244"; }
  }

  : row {
    : gswatch { color=012; key="012"; }
    : gswatch { color=022; key="022"; }
    : gswatch { color=032; key="032"; }
    : gswatch { color=042; key="042"; }
    : gswatch { color=052; key="052"; }
    : gswatch { color=062; key="062"; }
    : gswatch { color=072; key="072"; }
    : gswatch { color=082; key="082"; }
    : gswatch { color=092; key="092"; }
    : gswatch { color=102; key="102"; }
    : gswatch { color=112; key="112"; }
    : gswatch { color=122; key="122"; }
    : gswatch { color=132; key="132"; }
    : gswatch { color=142; key="142"; }
    : gswatch { color=152; key="152"; }
    : gswatch { color=162; key="162"; }
    : gswatch { color=172; key="172"; }
    : gswatch { color=182; key="182"; }
    : gswatch { color=192; key="192"; }
    : gswatch { color=202; key="202"; }
    : gswatch { color=212; key="212"; }
    : gswatch { color=222; key="222"; }
    : gswatch { color=232; key="232"; }
    : gswatch { color=242; key="242"; }
  }

  : row {
    : gswatch { color=010; key="010"; }
    : gswatch { color=020; key="020"; }
    : gswatch { color=030; key="030"; }
    : gswatch { color=040; key="040"; }
    : gswatch { color=050; key="050"; }
    : gswatch { color=060; key="060"; }
    : gswatch { color=070; key="070"; }
    : gswatch { color=080; key="080"; }
    : gswatch { color=090; key="090"; }
    : gswatch { color=100; key="100"; }
    : gswatch { color=110; key="110"; }
    : gswatch { color=120; key="120"; }
    : gswatch { color=130; key="130"; }
    : gswatch { color=140; key="140"; }
    : gswatch { color=150; key="150"; }
    : gswatch { color=160; key="160"; }
    : gswatch { color=170; key="170"; }
    : gswatch { color=180; key="180"; }
    : gswatch { color=190; key="190"; }
    : gswatch { color=200; key="200"; }
    : gswatch { color=210; key="210"; }
    : gswatch { color=220; key="220"; }
    : gswatch { color=230; key="230"; }
    : gswatch { color=240; key="240"; }
  }

  : spacer { height=0.7; fixed_height=true; }

  : row {
    : gswatch { color=011; key="011"; }
    : gswatch { color=021; key="021"; }
    : gswatch { color=031; key="031"; }
    : gswatch { color=041; key="041"; }
    : gswatch { color=051; key="051"; }
    : gswatch { color=061; key="061"; }
    : gswatch { color=071; key="071"; }
    : gswatch { color=081; key="081"; }
    : gswatch { color=091; key="091"; }
    : gswatch { color=101; key="101"; }
    : gswatch { color=111; key="111"; }
    : gswatch { color=121; key="121"; }
    : gswatch { color=131; key="131"; }
    : gswatch { color=141; key="141"; }
    : gswatch { color=151; key="151"; }
    : gswatch { color=161; key="161"; }
    : gswatch { color=171; key="171"; }
    : gswatch { color=181; key="181"; }
    : gswatch { color=191; key="191"; }
    : gswatch { color=201; key="201"; }
    : gswatch { color=211; key="211"; }
    : gswatch { color=221; key="221"; }
    : gswatch { color=231; key="231"; }
    : gswatch { color=241; key="241"; }
  }

  : row {
    : gswatch { color=013; key="013"; }
    : gswatch { color=023; key="023"; }
    : gswatch { color=033; key="033"; }
    : gswatch { color=043; key="043"; }
    : gswatch { color=053; key="053"; }
    : gswatch { color=063; key="063"; }
    : gswatch { color=073; key="073"; }
    : gswatch { color=083; key="083"; }
    : gswatch { color=093; key="093"; }
    : gswatch { color=103; key="103"; }
    : gswatch { color=113; key="113"; }
    : gswatch { color=123; key="123"; }
    : gswatch { color=133; key="133"; }
    : gswatch { color=143; key="143"; }
    : gswatch { color=153; key="153"; }
    : gswatch { color=163; key="163"; }
    : gswatch { color=173; key="173"; }
    : gswatch { color=183; key="183"; }
    : gswatch { color=193; key="193"; }
    : gswatch { color=203; key="203"; }
    : gswatch { color=213; key="213"; }
    : gswatch { color=223; key="223"; }
    : gswatch { color=233; key="233"; }
    : gswatch { color=243; key="243"; }
  }

  : row {
    : gswatch { color=015; key="015"; }
    : gswatch { color=025; key="025"; }
    : gswatch { color=035; key="035"; }
    : gswatch { color=045; key="045"; }
    : gswatch { color=055; key="055"; }
    : gswatch { color=065; key="065"; }
    : gswatch { color=075; key="075"; }
    : gswatch { color=085; key="085"; }
    : gswatch { color=095; key="095"; }
    : gswatch { color=105; key="105"; }
    : gswatch { color=115; key="115"; }
    : gswatch { color=125; key="125"; }
    : gswatch { color=135; key="135"; }
    : gswatch { color=145; key="145"; }
    : gswatch { color=155; key="155"; }
    : gswatch { color=165; key="165"; }
    : gswatch { color=175; key="175"; }
    : gswatch { color=185; key="185"; }
    : gswatch { color=195; key="195"; }
    : gswatch { color=205; key="205"; }
    : gswatch { color=215; key="215"; }
    : gswatch { color=225; key="225"; }
    : gswatch { color=235; key="235"; }
    : gswatch { color=245; key="245"; }
  }

  : row {
    : gswatch { color=017; key="017"; }
    : gswatch { color=027; key="027"; }
    : gswatch { color=037; key="037"; }
    : gswatch { color=047; key="047"; }
    : gswatch { color=057; key="057"; }
    : gswatch { color=067; key="067"; }
    : gswatch { color=077; key="077"; }
    : gswatch { color=087; key="087"; }
    : gswatch { color=097; key="097"; }
    : gswatch { color=107; key="107"; }
    : gswatch { color=117; key="117"; }
    : gswatch { color=127; key="127"; }
    : gswatch { color=137; key="137"; }
    : gswatch { color=147; key="147"; }
    : gswatch { color=157; key="157"; }
    : gswatch { color=167; key="167"; }
    : gswatch { color=177; key="177"; }
    : gswatch { color=187; key="187"; }
    : gswatch { color=197; key="197"; }
    : gswatch { color=207; key="207"; }
    : gswatch { color=217; key="217"; }
    : gswatch { color=227; key="227"; }
    : gswatch { color=237; key="237"; }
    : gswatch { color=247; key="247"; }
  }

  : row {
    : gswatch { color=019; key="019"; }
    : gswatch { color=029; key="029"; }
    : gswatch { color=039; key="039"; }
    : gswatch { color=049; key="049"; }
    : gswatch { color=059; key="059"; }
    : gswatch { color=069; key="069"; }
    : gswatch { color=079; key="079"; }
    : gswatch { color=089; key="089"; }
    : gswatch { color=099; key="099"; }
    : gswatch { color=109; key="109"; }
    : gswatch { color=119; key="119"; }
    : gswatch { color=129; key="129"; }
    : gswatch { color=139; key="139"; }
    : gswatch { color=149; key="149"; }
    : gswatch { color=159; key="159"; }
    : gswatch { color=169; key="169"; }
    : gswatch { color=179; key="179"; }
    : gswatch { color=189; key="189"; }
    : gswatch { color=199; key="199"; }
    : gswatch { color=209; key="209"; }
    : gswatch { color=219; key="219"; }
    : gswatch { color=229; key="229"; }
    : gswatch { color=239; key="239"; }
    : gswatch { color=249; key="249"; }
  }



    }
    :row {
        fixed_width = true;
        alignment = centered;
        :edit12_box {
            label = /*MSG21*/"Color:";
            key = "color_edit";
            allow_accept = true;
        }
        :swatch {
            key = "color_image";
        }
    }
    ok_cancel_help;
}
// dialog box for color
color_box : dialog {
  key="color_box";
  label="Colors";
  gh_color;
}


gh_hatch_pat : dialog {
    label = /*MSG31*/"Choose Hatch Pattern";
    aspect_ratio = 0;
// If you don't box this, it fits on EGA
    : row {
            fixed_width = true;
            alignment = centered;
        : text {
            label = /*MSG108*/"NOTE: * patterns not to scale.";
        }
    }
    : column {
        : row {
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic0";
                }
                : text {
                    key = /*MSG0*/"il0";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic1";
                }
                : text {
                    key = /*MSG0*/"il1";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic2";
                }
                : text {
                    key = /*MSG0*/"il2";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic3";
                }
                : text {
                    key = /*MSG0*/"il3";
                    width = 12;
                }
            }
        }
        : row {
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic4";
                }
                : text {
                    key = /*MSG0*/"il4";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic5";
                }
                : text {
                    key = /*MSG0*/"il5";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic6";
                }
                : text {
                    key = /*MSG0*/"il6";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic7";
                }
                : text {
                    key = /*MSG0*/"il7";
                    width = 12;
                }
            }
        }
        : row {
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic8";
                }
                : text {
                    key = /*MSG0*/"il8";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic9";
                }
                : text {
                    key = /*MSG0*/"il9";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic10";
                }
                : text {
                    key = /*MSG0*/"il10";
                    width = 12;
                }
            }
            : column {
                : icon_image {
                  key         = /*MSG0*/"ic11";
                }
                : text {
                    key = /*MSG0*/"il11";
                    width = 12;
                }
            }
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : button { label="Previous"; key="prev_hatch_set";
                    width=9; fixed_width=true; }
        : spacer { width = 2; }
        : button { label="Next"; key="next_hatch_set";
                    width=9; fixed_width=true; }
        cancel_button;
    }
}
gh_hatch_options : dialog {
    label = /*MSG15*/"Hatch Options";
            : boxed_radio_column {
                key = /*MSG0*/"u_cluster";
                label = /*MSG17*/"Pattern Type";
                : radio_button {
                    key = /*MSG0*/"standard";
                    label = /*MSG18*/"Stored Hatch Pattern";
                    mnemonic = /*MSG85*/"H";
                }
                : radio_button {
                    key = /*MSG0*/"u_option";
                    label = /*MSG19*/"User-Defined Pattern (U)";
                    mnemonic = /*MSG86*/"U";
                }
            }
            : row {
                : button {
                    label = /*MSG25*/"Pattern...";
                    key = /*MSG0*/"look_hatch";
                    mnemonic = /*MSG87*/"P";
                    fixed_width = true;
                }
                : edit_box {
                    key = /*MSG0*/"hatch_pattern";
                    label = "";
                    edit_width = 16;
                }
            }
            : spacer { height=1; fixed_height=true; }
            : boxed_column {
              label="Scale:";
              : toggle { label="Auto"; key="auto_hatch_scale"; }
              : edit_box {
                  key = /*MSG0*/"hatch_scale";
                  label = /*MSG27*/"User Specified:";
                  edit_width = 16;
                  mnemonic = /*MSG88*/"l";
              }
            }
            : edit_box {
                key = /*MSG0*/"hatch_angle";
                label = /*MSG28*/"Angle:";
                edit_width = 16;
                mnemonic = /*MSG89*/"A";
            }
            : edit_box {
                key = /*MSG0*/"hatch_spacing";
                label = /*MSG29*/"Spacing:";
                edit_width = 16;
                mnemonic = /*MSG90*/"S";
            }
            : toggle {
                key = /*MSG0*/"hatch_double";
                label = /*MSG30*/"Double Hatch";
                mnemonic = /*MSG94*/"D";
            }
    : spacer { height=1; fixed_height=true; }
    ok_cancel_help;
}

// dialog for executing fence command
fence_execute : dialog {
  label="3D Models";
  : boxed_column {
    label="Structures to Draw:";
    : toggle { label="Fences"; key="fences"; }
    : toggle { label="Surfaces"; key="surfaces"; }
    : toggle { label="Wells"; key="wells"; }
  }
  : spacer { height=1; fixed_height=true; }
  : text { value="Vertical Exaggeration:"; }
  : edit_box { key="vert_exagg"; width=12; fixed_width=true;
               edit_width=12; }
  : spacer { height=1; fixed_height=true; }
  : boxed_radio_column {
    key="fill_cluster";
    label="Fill Mode:";
    : radio_button { key="solid"; label="Solid"; }
    : radio_button { key="hatch"; label="Hatch"; }
    : radio_button { key="three_poly"; label="3D Poly"; }
    : radio_button { key="tube"; label="Tube"; }
  }
  ok_cancel_help;
}

// dialog for well options
well_options : dialog {
  label="3D Wellbore Options";
  : text { value="Well Radius:"; }
  : edit_box { key="well_radius"; width=18; fixed_width=true;
               edit_width=20; }
  : spacer { height=1; fixed_height=true; }
  : boxed_column {
    : toggle { label="Wells at Points"; key="well_pts"; }
    : row {
      : toggle { label="Wells at Blocks";
                        key="well_blocks"; }
      : button { label="Blocks..."; key="pick_blocks";
                 width=11; fixed_width=true; }
    }
    : toggle { label="Wells at Vertices"; key="well_vertices"; }
  }
  ok_cancel_help;
}

// dialog for slice options
slc_options : dialog {
  label="Options";
  : boxed_column {
    label="Step Size:";
    : toggle { label="Auto"; key="auto_step"; }
    : edit_box { label="User Specified:"; key="step_size";
                 width=12; fixed_width=true; edit_width=12; }
  }
  : spacer { height=1; fixed_height=true; }
  : boxed_column {
    label="Hatching Offset";
    : toggle { label="Auto Offset"; key="auto_hatch_offset";}
    : edit_box { label="User Specified:"; key="hatch_offset";
                 width=12; fixed_width=true; edit_width=12; }
  }
  : spacer { height=1; fixed_height=true; }
  : boxed_column {
    : toggle { label="Slab Model"; key="slab_model"; }
    : boxed_column {
      : toggle { label="Auto Offset"; key="auto_slab_offset"; }
      : edit_box { label="User Specified:"; key="slab_offset";
                   width=12; fixed_width=true; edit_width=12; }
    }
  }
  : spacer { height=1; fixed_height=true; }
  : toggle { label="Linear Interpolation Only"; key="lin_interp"; }
  : spacer { height=1; fixed_height=true; }
  ok_cancel_help;
}

// dialog box for annotation options
note_opt_box : dialog {
  label="3D Annotation Options:";
  : boxed_column {
    label="Offset From Plane of Fence:";
    : toggle { label="Auto Offset"; key="auto_note_offset";}
    : edit_box { label="User Specified:"; key="note_off";
               width=12; fixed_width=true; edit_width=12; }
  }
  ok_cancel_help;
}



// sub-dialog box called to pick a named slice setup

pick_slc_setup_dialog : dialog {
  label="Pick a Named Setup";
  : edit_box {
    label="Path:";
    key="setup_path";
    width=16;
    fixed_width=true;
  }
  : spacer { height=1; fixed_height=true; }
  : list_box {
    label="Setup Names:";
    key="setup_names";
    alignment=centered;
    height=10;
    fixed_height=true;
    multiple_select=false;
    width=8;
    fixed_width=true;
  }
  ok_cancel_help;
}

// dialog box to save setup
slc_save_name : dialog {
  : row {
    : text {
      label="Save Slice Setup:";
    }
    : edit_box {
      key="enter_save_name";
      width=25;
      fixed_width=true;
      allow_accept=true;
    }
  }
  : spacer { height=2; }
  ok_cancel_help;
}

// dialog box to create new layer
newlayer : dialog {
  label="Create New Layer";
  : row {
    : text {
      label="Layer Name:";
    }
    : edit_box {
      key="new_layer_name";
      width=25;
      fixed_width=true;
      allow_accept=true;
    }
  }
  : spacer { height=2; }
  ok_cancel_help;
}

// dialog box to select blocks for wells
block_selection : dialog {
  label="Select Blocks for Wells";
  : list_box {
    label="Currently Defined Blocks:";
    key="slc_blocks";
    width=36;
    fixed_width=true;
    height=8;
    fixed_height=true;
    multiple_select=true;
  }
  : row {
    : button { label="Select All"; key="sel_all_blocks";
               width=13; fixed_width=true; }
    : button { label="Clear All"; key="clr_all_blocks";
               width=13; fixed_width=true; }
  }
  ok_button;
}

// dialog box called to pick tin to display

tinbox : dialog {
  label="Display Tin";
  : list_box {
    label="Surfaces:";
    key="pick_tin";
    alignment=centered;
    height=14;
    fixed_height=true;
    multiple_select=false;
    width=34;
    fixed_width=true;
  }
  ok_cancel_help;
}
graph_box : dialog {
  label="Graph";
  : row {
    : boxed_column {
      label="Scaling:";
	  : row {
	    : text { key="txt_horiz_mult"; width=20; fixed_width=true;
		         value="Horizontal Multiplier:"; }
        : edit_box { key="horiz_mult";
                     width=8; fixed_width=true; edit_width=12; }
	  }
	  : row {
	    : text { key="txt_vert_mult"; width=20; fixed_width=true;
		         value="Vertical Multiplier:"; }
        : edit_box { key="vert_mult";
                     width=8; fixed_width=true; edit_width=12; }
	  }
      : toggle { label="Scaled to Fit"; key="scaled_to_fit"; }
    }
    : spacer { width=1; fixed_width=true; }
    : column {
      : boxed_column {
        label="Vertical Range:";
		: row {
		  : text { key="txt_vert_max"; width=12; fixed_width=true;
		           value="Maximum:"; }
          : edit_box { key="vert_max";
                       width=8; fixed_width=true; edit_width=12; }
	    }
		: row {
		  : text { key="txt_vert_min"; width=12; fixed_width=true;
		           value="Minimum:"; }
          : edit_box { key="vert_min";
                       width=8; fixed_width=true; edit_width=12; }
		}
        : toggle { label="Auto"; key="auto_vert_range"; }
      }
    }
  }
  : spacer { height=2; fixed_height=true; }
  : row {
    : spacer { width=37; fixed_width=true; }
    : text { key="txt_x_axis"; width=16; fixed_width=true;
             value="X Axis"; }
    : text { key="txt_y_axis"; width=12; fixed_width=true;
             value="Y Axis"; }
    : text { key="txt_auto"; width=6; fixed_width=true;
             value="Auto"; }
  }
  : row {
    : toggle { key="tick"; }
    : text { key="txt_tick"; width=12; fixed_width=true;
	         value="Ticks"; }
	: text { key="interval_tick"; width=12; fixed_width=true;
	         value="Interval:"; }
    : edit_box { key="tick_x_interval"; width=8; fixed_width=true;
                 edit_width=12; }
    : edit_box { key="tick_y_interval"; width=8; fixed_width=true;
                 edit_width=12; }
    : toggle { key="auto_tick_interval"; }
  }
  : row {
    : toggle { key="back_grid"; }
    : text { key="txt_back_grid"; width=12; fixed_width=true;
	         value="Grid"; }
    : text { key="grid_interval"; width=12; fixed_width=true;
	         value="Interval:"; }
    : edit_box { key="grid_x_interval"; width=8; fixed_width=true;
                 edit_width=12; }
    : edit_box { key="grid_y_interval"; width=8; fixed_width=true;
                 edit_width=12; }
    : toggle { key="auto_grid_interval"; }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : toggle { key="label_graph"; }
    : text { key="txt_label_graph"; width=35; fixed_width=true; }
    : spacer { width=35; fixed_width=true; }
  }
  : row {
    : toggle { key="surface_names"; }
    : text { key="txt_surface_names"; width=35; fixed_width=true; }
    : spacer { width=35; fixed_width=true; }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=19; fixed_width=true; }
    : text { key="txt_horiz_origin"; width=12; fixed_width=true; }
    : edit_box { key="horiz_origin";
                 width=8; fixed_width=true; edit_width=12; }
    : spacer { width=12; fixed_width=true; }
    : toggle { key="auto_origin"; }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=17; fixed_width=true; }
    ok_button;
    : spacer { width=8; fixed_width=true; }
    help_button;
    : spacer { width=17; fixed_width=true; }
  }
}
win_selection : dialog {
  label="2D Section Layout";
  : boxed_column {
    label="AutoCad Space:";
    : boxed_radio_row {
      key="autocad_space";
      : radio_button { key="paper_sp"; label="Paper Space"; }
      : radio_button { key="model_sp"; label="Model Space"; }
    }
    : spacer { height=1; fixed_height=true; }
    : row {
      : spacer { width=4; fixed_width=true; }
      : column {
        : text { key="txt_pap_units"; width=12; fixed_width=true; }
        : edit_box { key="paper_units"; width=10; fixed_width=true;
                     edit_width=15; }
      }
      : column {
        : text { key="eq1"; width=5; fixed_width=true; }
        : text { key="eq2"; width=5; fixed_width=true; }
      }
      : column {
        : text { key="txt_mod_units"; width=12; fixed_width=true; }
        : edit_box { key="model_units"; width=10; fixed_width=true;
                     edit_width=15;}
      }
      : spacer { width=4; fixed_width=true; }
    }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=16; fixed_width=true; }
    : text { key="txt_paper_text_height"; width=17;
                  fixed_width=true; value="Paper Space"; }
    : text { key="txt_model_text_height"; width=16;
                  fixed_width=true; value="Model Space"; }
    : text { key="txt_auto_text_height"; width=8;
                  fixed_width=true; value="Auto"; }
  }
  : row {
    : text { key="txt_text_height"; width=12; fixed_height=true; }
    : edit_box { key="paper_text_height"; width=8; fixed_width=true;
                 edit_width=12; }
    : edit_box { key="model_text_height"; width=8; fixed_width=true;
                 edit_width=12; }
    : toggle { key="auto_text_height"; }
  }
  : spacer { height=1; fixed_height=true; }
  : button { label="Multi-Section Layout..."; key="mwin_layout";
             width=25; fixed_width=true; alignment=centered; }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=4; fixed_width=true; }
    ok_button;
    : spacer { width=8; fixed_width=true; }
    help_button;
    : spacer { width=4; fixed_width=true; }
  }
}
well_space : dialog {
  label="Wells on 2D Sections";
  : boxed_column {
    label="Wells:";
    : toggle { label="Well Logs"; key="well_logs"; }
    : text { label="Width:"; }
    : row {
      : spacer { width=2; fixed_width=true; }
      : edit_box { label="Model Space:"; key="model_log_width";
                   width=12; fixed_width=true; edit_width=12; }
    }
    : row {
      : spacer { width=2; fixed_width=true; }
      : edit_box { label="Paper Space:"; key="paper_log_width";
                   width=12; fixed_width=true; edit_width=12; }
    }
  }
  : spacer { height=1; fixed_height=true; }
  : boxed_column {
    label="Symbols:";
    : toggle { label="Well Symbols"; key="draw_symbols"; }
    : boxed_column {
      : toggle { label="Auto Scale"; key="auto_sym_scale"; }
      : edit_box { label="Multiplier:"; key="multiplier";
                   width=12; fixed_width=true; edit_width=12; }
    }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    ok_button;
    help_button;
  }
}
multi_layout : dialog {
  label="Multi-Section Layout";
  : spacer { height=1; fixed_height=true; }
  : text { value="Array of"; width=9; fixed_width=true; }
  : row {
    : spacer { width=7; fixed_width=true; }
    : edit_box { key="spe_rows"; width=4; fixed_width=true;
                 edit_width=4; }
    : text { key="txt_rows"; width=6; fixed_width=true; }
    : spacer { width=2; fixed_width=true; }
    : edit_box { key="spe_columns"; width=4; fixed_width=true;
                 edit_width=4; }
    : text { key="txt_columns"; width=8; fixed_width=true; }
    : spacer { width=4; fixed_width=true; }
  }
  : text { value="ordered by"; }
  : row {
    : spacer { width=2; fixed_width=true; }
    : radio_row {
      key="multi_order";
      : radio_button { key="spe_row_order"; label="rows"; }
      : radio_button { key="spe_col_order";  label="columns"; }
    }
    : spacer { width=6; fixed_width=true; }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=16; fixed_width=true; }
    : text { key="txt_paper_spacing"; width=17;
             fixed_width=true; value="Paper Space"; }
    : text { key="txt_model_spacing"; width=16;
             fixed_width=true; value="Model Space"; }
    : text { key="txt_auto_spacing"; width=8;
             fixed_width=true; value="Auto"; }
  }
  : row {
    : text { key="txt_x_spacing"; width=12; fixed_height=true; }
    : edit_box { key="paper_x_spacing"; width=8; fixed_width=true;
                 edit_width=12; }
    : edit_box { key="model_x_spacing"; width=8; fixed_width=true;
                 edit_width=12; }
    : toggle { key="auto_x_spacing"; }
  }
  : row {
    : text { key="txt_y_spacing"; width=12; fixed_height=true; }
    : edit_box { key="paper_y_spacing"; width=8; fixed_width=true;
                 edit_width=12; }
    : edit_box { key="model_y_spacing"; width=8; fixed_width=true;
                 edit_width=12; }
    : toggle { key="auto_y_spacing"; }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : spacer { width=2; fixed_width=true; }
    ok_button;
    help_button;
    : spacer { width=2; fixed_width=true; }
  }
}
twod_exe : dialog {
  label="2D Sections";
  : boxed_radio_column {
    key="vertical_axis";
    label="Vertical Axis:";
    : radio_button { key="linear"; label="Linear"; }
    : radio_button { key="log"; label="Log"; }
  }
  : spacer { height=1; fixed_height=true; }
  : boxed_radio_column {
    key="section_mode";
    label="Section Mode:";
    : radio_button { key="extended"; label="Standard"; }
    : radio_button { key="projected"; label="Projected"; }
  }
  : spacer { height=1; fixed_height=true; }
  : boxed_radio_column {
    key="twod_fill";
    label="Fill Mode:";
    : radio_button { key="solid"; label="Outline"; }
    : radio_button { key="hatch"; label="Hatch"; }
    : radio_button { key="sing_poly";
                     label="Polylines"; }
  }
  ok_cancel_help;
}
twod : dialog {
  label="2D Section Properties";
  : toggle { label="All Defaults"; key="all_defaults"; }
  : spacer { height=1; fixed_height=true; }
  : column {
    children_alignment=centered;
    : button { label="Graph.."; key="graph";
               width=10; fixed_width=true; }
    : button { label="Layout.."; key="window";
               width=10; fixed_width=true; }
    : button { label="Wells.."; key="well_sym_options";
               width=10; fixed_width=true; }
    : button { label="Layers.."; key="graph_layers";
               width=10; fixed_width=true; }
  }
  : spacer { height=1; fixed_height=true; }
  ok_cancel_help;
}
layer_2d : dialog {
  label="Layers";
  : spacer { height=1; fixed_height=true; }
  : boxed_radio_column {
    key="layer_2d_choice";
    label="Layers For Graph Items:";
    : radio_button {
      key="curr_layer";
      label="Current Layer";
    }
    : radio_button {
      key="named_layer";
      label="Named Layers";
    }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
    : text { key="txt_item";  width=12; fixed_width=true; }
    : text { key="txt_layer_name"; width=12; fixed_width=true; }
  }
  : row {
    : text { key="txt_axes"; width=12; fixed_width=true; }
    : text { key="axes_layer"; width=12; fixed_width=true; }
  }
  : row {
    : text { key="txt_grid"; width=12; fixed_width=true; }
    : text { key="grid_layer"; width=12; fixed_width=true; }
  }
  : row {
    : text { key="txt_text"; width=12; fixed_width=true; }
    : text { key="text_layer"; width=12; fixed_width=true; }
  }
  : row {
    : text { key="txt_logs"; width=12; fixed_width=true; }
    : text { key="logs_layer"; width=12; fixed_width=true; }
  }
  : spacer { height=1; fixed_height=true; }
  : row {
  ok_button;
  help_button;
  }
}
bbox_dia : dialog {
  label="Bounding Box";
  : boxed_column {
    label="Base Elevation:";
    : row {
      : toggle { label="Data Minimum:"; key="data_minimum"; }
      : text { key="min_z"; }
    }
    : row {
      : toggle { label="User Specified:"; key="user_spec_base"; }
      : edit_box { key="user_base"; edit_width=10; width=8;
                   fixed_width=true; }
    }
  }
  : boxed_column {
    label="Top Elevation:";
    : row {
      : toggle { label="Data Maximum:"; key="data_maximum"; }
      : text { key="max_z"; }
    }
    : row {
      : toggle { label="User Specified:"; key="user_spec_top"; }
      : edit_box { key="user_top"; edit_width=10; width=8;
                   fixed_width=true; }
    }
  }
  ok_cancel_help;
}
abort_box : dialog {
  label="Spatial Explorer Alert";
  : spacer { height=1; fixed_height=true; }
  : text {
    key="txt1_abort_box";
    width=35; fixed_width=true;
  }
  : text {
    key="txt2_abort_box";
    width=35; fixed_width=true;
  }
  : spacer { height=1; fixed_height=true; }
  ok_cancel_help;
}
spe_alert_box : dialog {
  label="Spatial Explorer Alert";
  : spacer { height=1; fixed_height=true; }
  : text {
    key="txt1";
    width=35; fixed_width=true;
  }
  : text {
    key="txt2";
    width=35; fixed_width=true;
  }
  : spacer { height=1; fixed_height=true; }
  ok_button;
}
spe_about_box : dialog {
  label="Spatial Explorer Alert";
  : spacer { height=1; fixed_height=true; }
  : text {
    key="txt1";
    width=35; fixed_width=true;
  }
  : text {
    key="txt2";
    width=35; fixed_width=true;
  }
  : spacer { height=1; fixed_height=true; }
  : text {
    key="txt3";
    width=35; fixed_width=true;
  }
  : text {
    key="txt4";
    width=35; fixed_width=true;
  }
  : text {
    key="txt5";
    width=35; fixed_width=true;
  }
  : text {
    key="txt6";
    width=35; fixed_width=true;
  }
  : text {
    key="txt7";
    width=35; fixed_width=true;
  }
  : text {
    key="txt8";
    width=35; fixed_width=true;
  }
  : spacer { height=1; fixed_height=true; }
  ok_button;
}

overwrite_box : dialog {
  : text { key="txt_over1"; width=25; fixed_width=true; }
  : text { key="txt_over2"; width=25; fixed_width=true; }
  : boxed_radio_column {
    key="over_choice";
    : radio_button { label="Load existing .QSB file.";
                     key="existing"; }
    : radio_button { label="Overwrite existing .QSB file.";
                     key="over"; }
    : radio_button { label="Abort load."; key="abort"; }
  }
  ok_button;
}
