/*
 * FM/2 2.x installation program copyright (c) 1994 by M. Kimes
 *
 * This program creates a folder to hold program objects,
 * then creates program objects for each executable.  It only needs to be
 * run once (unless you move the FM/2 directory -- see say notes at end).
 * It also calls MIGINI.CMD if it finds an old FM2.INI file to migrate
 * some information to the new version's FM3.INI file.
 *
 * For unattended installation, remove the lines marked with "NOTE:" below.
 */

/* see if we might be in the right directory... */

'@Echo off'
'cls'

'echo  Ŀ'
'echo                    FM/2 2.x Installation Program                    '
'echo               FM/2 is copyright (c) 1993/94 by M. Kimes             '
'echo                         All rights reserved                         '
'echo  Ĵ'
'echo                  Have you read the READ.ME file yet?                '
'echo          By running this program, you agree to the license          '
'echo                       as specified in that file,                    '
'echo        and it tells you how to install, so you should read it.      '
'echo  '

rc = stream('fm3.exe','c','query exists')
if rc = '' then
do
  say 'Sorry, FM3.EXE not found.  Must not be right directory.  Terminating.'
  exit
end

/* tell user what we're doing, give him a chance to hit CTRL-C */

say ''
say 'This program creates objects for FM/2.'
say ''



/* NOTE:  remove following 3 lines for unattended use... */
say 'Press [Enter].'
pull dummy .
say ''


/* save current directory */

curdir = directory()

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* say it, then do it */

say "Creating File Manager/2 folder and program objects..."

/* first, create FM/2 folder */

title = "File Manager/2"
classname = 'WPFolder'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<FM3_Folder>;OPEN=DEFAULT'
result=SysCreateObject(classname,title,location,setup,f)

/* NOTE:  remove following 9 lines for unattended use... */
if result = 0 then
do
  say ''
  say 'The File Manager/2 folder already exists.'
  say 'Should I replace the objects? (Y/N)'
  parse upper pull dummy
  if left(dummy,1) = 'N' then exit
  say ''
end

/* now, create program objects in FM/2 folder */

title = "File Manager/2"
classname = 'WPProgram'
location = '<FM3_Folder>'
setup = 'EXENAME='curdir'\FM3.EXE;PARAMETERS=%*;STARTUPDIR='curdir
call SysCreateObject classname,title,location,setup,u

rc = stream('av2.exe','c','query exists')
if rc \= '' then
do
  title = "Archive Viewer/2"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\AV2.EXE;PARAMETERS=%*;STARTUPDIR='curdir';ASSOCFILTER=*.ZIP,*.ARC,*.LZH,*.ARJ,*.ZOO,*.MO0'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('doicon.exe','c','query exists')
if rc \= '' then
do
  title = "SysIcon"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\DOICON.EXE;PARAMETERS=%*;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('eas.exe','c','query exists')
if rc \= '' then
do
  title = "EA Viewer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\EAS.EXE;PARAMETERS=%*;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('ini.exe','c','query exists')
if rc \= '' then
do
  title = "INI Viewer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\INI.EXE;PARAMETERS=%*;STARTUPDIR='curdir';ASSOCFILTER=*.INI'
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('killproc.exe','c','query exists')
if rc \= '' then
do
  title = "Process Killer"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\KILLPROC.EXE;PARAMETERS=%;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('undel.exe','c','query exists')
if rc \= '' then
do
  title = "Undeleter"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\UNDEL.EXE;PARAMETERS=%*;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vtree.exe','c','query exists')
if rc \= '' then
do
  title = "Visual Tree"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\VTREE.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vdir.exe','c','query exists')
if rc \= '' then
do
  title = "Visual Directory"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\VDIR.EXE;PARAMETERS=%*;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

rc = stream('vcollect.exe','c','query exists')
if rc \= '' then
do
  title = "Collector"
  classname = 'WPProgram'
  location = '<FM3_Folder>'
  setup = 'EXENAME='curdir'\VCOLLECT.EXE;STARTUPDIR='curdir
  call SysCreateObject classname,title,location,setup,u
end

/*
 * create an FM2.CMD file that the user can copy into a directory
 * in their PATH if they'd like to be able to start FM/2 from any
 * directory via command line.
 */

'del FM2.CMD'
dummy = stream('FM2.CMD','C','open')
if dummy = 'READY:' then
do
  say 'Creating an FM2.CMD file.'
  call lineout 'FM2.CMD', "/* FM/2 command file.  Locate in a directory"
  call lineout 'FM2.CMD', " * on your PATH. */"
  call lineout 'FM2.CMD', "'@echo off'"
  call lineout 'FM2.CMD', "arg dummy"
  call lineout 'FM2.CMD', "if dummy = '' then"
  call lineout 'FM2.CMD', "  curdir = directory()"
  call lineout 'FM2.CMD', "else"
  call lineout 'FM2.CMD', "  curdir = ''"
  call lineout 'FM2.CMD', "n = setlocal()"
  call lineout 'FM2.CMD', "n = directory('"curdir"')"
  call lineout 'FM2.CMD', "'start fm3.exe 'curdir' %1 %2 %3 %4 %5 %6 %7 %8 %9'"
  call lineout 'FM2.CMD', "n = endlocal()"
  call stream 'FM2.CMD','C','close'
end
else say "Couldn't create FM2.CMD file."
say ''

/* if we can find FM2.INI, run MIGINI.CMD */

fm2ini = value('fm2ini',,'OS2ENVIRONMENT')
if fm2ini \= '' then fm2ini = stream(fm2ini,'c','query exists')
if fm2ini = '' then
do
  fm2ini = value('fm2ini',,'OS2ENVIRONMENT')
  if fm2ini \= '' then
  do
    fm2ini = insert('\FM2.INI',fm2ini,length(fm2ini))
    fm2ini = stream(fm2ini,'c','query exists')
  end
end
fm2ini = SysSearchPath('PATH', 'FM2.INI')
if fm2ini = '' then fm2ini = SysSearchPath('DPATH', 'FM2.INI')
if fm2ini = '' then fm2ini = SysSearchPath('XPATH', 'FM2.INI')
if fm2ini \= '' then
do
  'call migini.cmd dummy'
  say ''
  say '  (You can remove the old FM/2 1.x files when installation completes.)'
  call SysSleep 2
  say ''
end

/* type the read.me file just so we're sure user had a _chance_ to see it */

/* NOTE:  remove following 4 lines for unattended use... */
rc = stream('install.dat','c','query exists')
if rc \= '' then 'type install.dat'
say 'Press [Enter].'
pull dummy .

say 'To move FM/2 to another directory, move the files, delete the FM/2 folder,'
say 'then rerun INSTALL.  To remove FM/2, run UNINSTAL and follow its directions.'
say "If you'd like to be able to run FM2 from any OS/2 command line, copy the"
say 'FM2.CMD file in this directory to a directory on your PATH.'
say ''
say "I'm done now."

