/*
	This is a DMapEdit source code module.  Though it is copyrighted, you
	may modify it and use it for your own personal use, meaning that new
	modified code and anything derived from it (such as exe files) doesn't
	get distributed to anyone, unless you get my permission first.  Code
	from this file, or code based on ideas from this file may be used with
	other programs, provided that you give credit for it in the source code,
	documentation, and 'about' windows or screens, if one exists, for the
	programs using it.  Giving credit means something like this:

	Code from DMapEdit was used in this program

							  or

	Some code for this program was based on ideas presented in DMapEdit

	Whatever.  Just be sure to mention "DMapEdit" in such a way that it's
	self-evident how it was useful to the new program, and be sure to have
	"DMapEdit is a trademark of Jason Hoffoss" in the docs.  That's all..
*/

#include <stdio.h>
#include <graphics.h>
#include "dme.h"
#include "dme2.h"

int toggle_item(int num, int far * far *list);
void mark_line_vertexes(void);
int unmark_item(int num, int far * far *ptr);
int mark_item(int num, int far * far *ptr);
void mark_thing(int num);
void mark_sector(int num);
int mark_sectors(int mode, int total);

int old_mark_color=0;

void make_lists(void)
{
	mthings = get_farmem(4L, "marked thing list");
	*mthings = 0;
	mthings[1] = 2;
	mvertexes = get_farmem(4L, "marked vertex list");
	*mvertexes = 0;
	mvertexes[1] = 2;
	mlinedefs = get_farmem(4L, "marked line list");
	*mlinedefs = 0;
	mlinedefs[1] = 2;
	msidedefs = get_farmem(4L, "marked sidedef list");
	*msidedefs = 0;
	msidedefs[1] = 2;
	msectors = get_farmem(4L, "marked sector list");
	*msectors = 0;
	msectors[1] = 2;

	marked = 0;
	return;
}

void sort_marked(int far *list)
{
	int i, j, temp;
	int far *list2;

	if (*list < 2)
		return; /* no sorting needed */

	list2 = list + 2;
	for (i=1; i<*list; i++)
	{
		temp = list2[i];
		j = i;
		while (j-- && temp < list2[j])
			list2[j+1] = list2[j];

		j++;
		list2[j] = temp;
	}
	return;
}

void unmark_all(void)
{
	*mthings = 0;
	mthings[1] = 2;
	mthings = resize_farmem(mthings, 4L, "marked thing list");

	*mvertexes = 0;
	mvertexes[1] = 2;
	mvertexes = resize_farmem(mvertexes, 4L, "marked vertex list");

	*mlinedefs = 0;
	mlinedefs[1] = 2;
	mlinedefs = resize_farmem(mlinedefs, 4L, "marked line list");

	*msidedefs = 0;
	msidedefs[1] = 2;
	msidedefs = resize_farmem(msidedefs, 4L, "marked sidedef list");

	*msectors = 0;
	msectors[1] = 2;
	msectors = resize_farmem(msectors, 4L, "marked sector list");

	marked = 0;
	return;
}

int toggle_item(int num, int far * far *ptr)
{
	int i, j, size;
	int far *list;

	list = *ptr;
	size = *list;

	for (i=0; i<size; i++)
		if (list[i+2] == num)
		{
			for (j=i+1; j<size; j++)
				list[j+1] = list[j+2];
			(*list)--;
			marked = *mthings | *mvertexes | *mlinedefs | *msidedefs | *msectors;
			return 0;
		}

	if (size + 2 == list[1])
		*ptr = list = resize_farmem(list, (list[1] += 256)*2, "marked list");
	list[size + 2] = num;
	(*list)++;
	marked = 1;
	return 1;
}

int mark_item(int num, int far * far *ptr)
{
	int i, j, size;
	int far *list;

	list = *ptr;
	size = *list;

	for (i=0; i<size; i++)
		if (list[i+2] == num)
			return 0;

	if (size + 2 == list[1])
		*ptr = list = resize_farmem(list, (list[1] += 256)*2, "marked list");
	list[size + 2] = num;
	(*list)++;
	marked = 1;
	return 1;
}

int unmark_item(int num, int far * far *ptr)
{
	int i, j, size;
	int far *list;

	list = *ptr;
	size = *list;

	for (i=0; i<size; i++)
		if (list[i+2] == num)
		{
			for (j=i+1; j<size; j++)
				list[j+1] = list[j+2];
			(*list)--;
			marked = *mthings | *mvertexes | *mlinedefs | *msidedefs | *msectors;
			return 1;
		}

	return 0;
}

int check_marked(int num, int far *list)
{
	int i, size;

	size = *list;

	for (i=0; i<size; i++)
		if (list[i+2] == num)
			return 1;

	return 0;
}

void mark_vertex(int num)
{
	if (!toggle_item(num, &mvertexes))
		draw_point(adjvx[num], adjvy[num], maxx - point_size * 2,
			maxy - point_size * 2);
	return;
}

void mark_line_vertexes(void)
{
	uchar *bits, flags[] = { 1, 2, 4, 8, 16, 32, 64, 128 };
	int i, v, z, max, mindex;

	if (!max_vertex)
		return;

	i = (max_vertex + 7) / 8;
	bits = get_mem(i, "Sector marking list");
	while (i--)
		bits[i] = 0;

	for (i=0; i<*mlinedefs; i++)
	{
		z = mlinedefs[i+2];
		v = linedefs[z].v1;
		bits[v >> 3] |= flags[v & 7];

		v = linedefs[z].v2;
		bits[v >> 3] |= flags[v & 7];
	}

	sort_marked(mvertexes);
	mindex = 2;
	max = *mvertexes + 2;
	for (i=0; i<max_vertex; i++)
	{
		if (mvertexes[mindex] == i && mindex < max )
		{
			if (!(bits[i >> 3] & flags[i & 7]))
			{
				if (unmark_item(i, &mvertexes))
				draw_point(adjvx[i], adjvy[i], maxx - point_size * 2,
					maxy - point_size * 2);
				max--;
			} else
				mindex++;

		} else
			if (bits[i >> 3] & flags[i & 7])
				mark_item(i, &mvertexes);
	}
	return;
}

void mark_line(int num)
{
	int sd1, sd2, sec1, sec2;

	sd1 = linedefs[num].sd1;
	if (sd1 != -1)
		sec1 = sidedefs[sd1].sector;

	sd2 = linedefs[num].sd2;
	if (sd2 != -1)
		sec2 = sidedefs[sd2].sector;

	if (toggle_item(num, &mlinedefs))
	{
		if (sec1 != -1)
			mark_item(sd1, &msidedefs);
		if (sec2 != -1)
			mark_item(sd2, &msidedefs);
		mark_item(linedefs[num].v1, &mvertexes);
		mark_item(linedefs[num].v2, &mvertexes);

	} else {
		wall_color(num);
		draw_line(num, SOLID_LINE);
		if (sec1 != -1)
			unmark_item(sd1, &msidedefs);
		if (sec2 != -1)
			unmark_item(sd2, &msidedefs);
	}

	return;
}

void mark_sector(int num)
{
	int i, z, test, test2, sd, sec;

	z = toggle_item(num, &msectors);

	for (i=0; i<l_size; i++)
	{
		test = test2 = 0;
		sd = linedefs[i].sd1;
		if (sd != -1)
		{
			sec = sidedefs[sd].sector;
			if (sec == num)
			{
				test++;
				if (z)
					mark_item(sec, &msidedefs);
				else
					unmark_item(sec, &msidedefs);
			} else
				test2 = check_marked(sec, msectors);
		}

		sd = linedefs[i].sd2;
		if (sd != -1)
		{
			sec = sidedefs[sd].sector;
			if (sec == num)
			{
				test++;
				if (z)
					mark_item(sec, &msidedefs);
				else
					unmark_item(sec, &msidedefs);
			} else
				test2 += check_marked(sec, msectors);
		}

		if (test)
		{
			if (z || test2)
				mark_item(i, &mlinedefs);
			else
				unmark_item(i, &mlinedefs);
		}
	}

	mark_line_vertexes();
	return;
}

int mark_sectors(int mode, int total)
{
	uchar *bits, flags[] = { 1, 2, 4, 8, 16, 32, 64, 128 };
	int i, mindex, max, sd, sec, total2=0;

	if (!sec_size)
		goto skip;

	i = (sec_size + 7) / 8;
	bits = get_mem(i, "Sector marking list");
	while (i--)
		bits[i] = 0;

	sort_marked(mlinedefs);
	mindex = 2;
	max = *mlinedefs + 2;
	for (i=0; i<l_size; i++)
	{
		if (mlinedefs[mindex] == i && mindex < max)
		{
			mindex++;
			continue;
		}

		sd = linedefs[i].sd1;
		if (sd != -1)
		{
			sec = sidedefs[sd].sector;
			if (sec != -1)
				bits[sec >> 3] |= flags[sec & 7];
		}

		sd = linedefs[i].sd2;
		if (sd != -1)
		{
			sec = sidedefs[sd].sector;
			if (sec != -1)
				bits[sec >> 3] |= flags[sec & 7];
		}
	}

	for (i=0; i<sec_size; i++)
		if (!(bits[i >> 3] & flags[i & 7]))
		{
			toggle_item(i, &msectors);
			total2++;
		}

	if (mode == 5 || mode == 6)
	{
		total = total2;
		for (i=0; i<(sec_size + 7) / 8; i++)
			bits[i] = 0;

		for (i=0; i<*msectors; i++)
		{
			sec = msectors[i+2];
			bits[sec >> 3] |= flags[sec & 7];
		}

		for (i=0; i<l_size; i++)
		{
			max = 0;
			sd = linedefs[i].sd1;
			if (sd != -1)
			{
				sec = sidedefs[sd].sector;
				if (sec != -1 && bits[sec >> 3] & flags[sec & 7])
				{
					max++;
					mark_item(sd, &msidedefs);

				} else
					unmark_item(sd, &msidedefs);
			}

			sd = linedefs[i].sd2;
			if (sd != -1)
			{
				sec = sidedefs[sd].sector;
				if (sec != -1 && bits[sec >> 3] & flags[sec & 7])
				{
					max++;
					mark_item(sd, &msidedefs);

				} else
					unmark_item(sd, &msidedefs);
			}

			if (max)
				mark_item(i, &mlinedefs);
			else
				unmark_item(i, &mlinedefs);
		}
	}

	free_mem(bits, "Sector marking list");

skip:
	mark_line_vertexes();
	return total;
}

void mark_thing(int num)
{
	toggle_item(lthing_num[num], &mthings);
	setcolor(old_mark_color);
	box_local_thing(num);
}

int boxmark(int mode)
{
	int i, xx, yy, x1, y1, x, y, z, temp, total=0;

	xx = x1 = mousex;
	yy = y1 = mousey;
	setwritemode(XOR_PUT);
	setlinestyle(DOTTED_LINE, 0, 1);
	setcolor(255);
	sync_time();

	while(mouse_check() & 8)
	{
		if (wait(8))
		{
			setwritemode(COPY_PUT);
			setlinestyle(SOLID_LINE, 0, 1);
			plot_marked(-1);
			setwritemode(XOR_PUT);
			setlinestyle(DOTTED_LINE, 0, 1);
			setcolor(255);
		}

		if (mousex == x1 && mousey == y1)
			continue;

		mouse_off();
		if (x1 != xx || y1 != yy)
		{
			line(xx, yy, x1, yy);
			line(xx, yy, xx, y1);
			line(x1, yy, x1, y1);
			line(xx, y1, x1, y1);
		}

		x1 = mousex;
		y1 = mousey;
		if (x1 != xx || y1 != yy)
		{
			line(xx, yy, x1, yy);
			line(xx, yy, xx, y1);
			line(x1, yy, x1, y1);
			line(xx, y1, x1, y1);
		}
		mouse_on();
	}

	mouse_off();
	if (x1 != xx || y1 != yy)
	{
		line(xx, yy, x1, yy);
		line(xx, yy, xx, y1);
		line(x1, yy, x1, y1);
		line(xx, y1, x1, y1);
	}
	setlinestyle(SOLID_LINE, 0, 1);
	setwritemode(COPY_PUT);

	if (x1 < xx)
	{
		temp = x1;
		x1 = xx;
		xx = temp;
	}

	if (y1 < yy)
	{
		temp = y1;
		y1 = yy;
		yy = temp;
	}

	if (mode == 5 || mode == 6)
		*mlinedefs = 0;

	switch (mode)
	{
		case 0:
			for (i=0; i<max_vertex; i++)
			{
				x = adjvx[i];
				y = adjvy[i];

				if (x > xx && y > yy && x < x1 && y < y1)
				{
					mark_vertex(i);
					total++;
				}
			}
			break;

		case 1:
		case 5:
			for (i=0; i<l_size; i++)
			{
				z = linedefs[i].v1;
				x = adjvx[z];
				y = adjvy[z];

				if (x > xx && y > yy && x < x1 && y < y1)
				{
					z = linedefs[i].v2;
					x = adjvx[z];
					y = adjvy[z];

					if (x > xx && y > yy && x < x1 && y < y1)
					{
						mark_line(i);
						total++;
					}
				}
			}
			total = mark_sectors(mode, total);
			break;

		case 2:
		case 6:
			for (i=0; i<l_size; i++)
			{
				z = linedefs[i].v1;
				x = adjvx[z];
				y = adjvy[z];

				if (x > xx && y > yy && x < x1 && y < y1)
				{
					mark_line(i);
					total++;
					continue;
				}

				z = linedefs[i].v2;
				x = adjvx[z];
				y = adjvy[z];

				if (x > xx && y > yy && x < x1 && y < y1)
				{
					mark_line(i);
					total++;
				}
			}
			total = mark_sectors(mode, total);
			break;

		case 3:
		case 4:
			for (i=0; i<lthing_count; i++)
			{
				x = lthingx[i];
				y = lthingy[i];

				if (x > xx && y > yy && x < x1 && y < y1)
				{
					mark_thing(i);
					total++;
				}
			}
			break;
	}
	return total;
}

void move_marked(void)
{
	int i, z, dx, dy, x, y, origx, origy, oldx, oldy;

	origx = oldx = re_x();
	origy = oldy = re_y();

	sync_time();
	while(1)
	{
		mouse_check();
		x = re_x();
		y = re_y();

		if (x != oldx || y != oldy)
		{
			dx = x - oldx;
			dy = y - oldy;
			oldx = x;
			oldy = y;

			if (*mvertexes)
			{
				for (i=0; i<*mvertexes; i++)
				{
					z = mvertexes[i+2];
					vertexes[z].x += dx;
					vertexes[z].y += dy;
				}
				draw_map();
				mouse_on();
			}
/* for all edit mode
			for (i=0; i<*mthings; i++)
			{
				z = mthings[i+2];
				things[z].x += dx;
				things[z].y += dy;
			} */
		}

		if (wait(8))
			plot_marked(-1);

		if (!(button_status & 1))
		{
			mouse_off();
			return;
		}

		if (button_status & 2)
		{
			dx = origx - x;
			dy = origy - y;

			for (i=0; i<*mvertexes; i++)
			{
				z = mvertexes[i+2];
				vertexes[z].x += dx;
				vertexes[z].y += dy;
			}

			ignore_button |= true_button;
			draw_map();
			return;
		}
	}
}
/*
int thing_drag(void)
{
	int i, j, z, x, y, dx, dy, dx2, dy2, origx, origy;

	origx = x = crossx + 2;
	origy = y = crossy + 2;

	while (1)
	{
		if (crossx+2 != x || crossy+2 != y)
		{
			dx = crossx + 2 - x;
			dy = crossy + 2 - y;
			dx2 = dx * scalers[scale];
			dy2 = dy * scalers[scale];
			x = crossx + 2;
			y = crossy + 2;

			if (marked)
			{
				if (*mvertexes)
				{
					for (i=0; i<*mthings; i++)
					{
						z = mthings[i+2];
						things[z].x += dx2;
						things[z].y -= dy2;
					}

					for (i=0; i<*mvertexes; i++)
					{
						z = mvertexes[i+2];
						vertexes[z].x += dx2;
						vertexes[z].y -= dy2;
					}
					draw_map();
					old_mark_color = 0;
					mouse_on();

				} else {
					plot_marked(0);
					for (i=0; i<*mthings; i++)
					{
						z = mthings[i+2];
						things[z].x += dx2;
						things[z].y -= dy2;

						for (j=0; j<lthing_count; j++)
							if (lthing_num[j] == z)
							{
								lthingx[j] += dx;
								lthingy[j] += dy;
								break;
							}
					}
					color_num--;
					plot_marked(-1);
				}

			} else {
				mouse_off();
				setcolor(cur_box_color);
				box_local_thing(cur_drag);

				lthingx[cur_drag] += dx;
				lthingy[cur_drag] += dy;
				box_local_thing(cur_drag);
				mouse_on();

				z = lthing_num[cur_drag];
				things[z].x += dx2;
				things[z].y -= dy2;
			}
		}

		if (wait(8))
		{
			if (marked)
				plot_marked(-1);

			else {
				i = rand_color();
				setcolor(i ^ cur_box_color);
				cur_box_color = i;
				box_local_thing(cur_drag);
			}
		}

		if (!(mouse_check() & 1))
		{
			draw_map();
			old_mark_color = edit_mode = 0;
			return 0;
		}

		if (button_status & 2)
		{
			del_thing(cur_drag);
			mouse_off();
			draw_map();
			await_release();
			edit_mode = 0;
			return 0;
		}
	}
} */

void plot_marked(int color)
{
	char image[125];
	int i, j, x, y, z, m, pmaxx, pmaxy, cross_status, color2;

	m = mouse;
	color2 = color;
	if (color == -1)
	{
		color_num++;
		switch (color_num %= 6)
		{
			case 0:
				color = 137;
				color2 = 143;
				break;
			case 1:
			case 5:
				color = 139;
				color2 = 141;
				break;
			case 2:
			case 4:
				color = 141;
				color2 = 139;
				break;
			case 3:
				color = 143;
				color2 = 137;
		}
	}

	if (mark_mask & 2)
	{
		if (color == 255)
			for (i=0; i<*mlinedefs; i++)
			{
				z = mlinedefs[i+2];
				wall_color(z);
				draw_line(z, SOLID_LINE);
			}
		else {
			setcolor(color);
			for (i=0; i<*mlinedefs; i++)
				draw_line(mlinedefs[i+2], SOLID_LINE);
		}
	}

	if (mark_mask & 1)
	{
		for (i=0; i<4; i++)
			image[i] = point_ptr[point_size-1][i];
		for (i=4; i<125; i++)
		{
			if (point_ptr[point_size-1][i])
				image[i] = color2;
			else
				image[i] = 0;
		}

		pmaxx = maxx - point_size * 2;
		pmaxy = maxy - point_size * 2;
		for (i=0; i<*mvertexes; i++)
		{
			z = mvertexes[i+2];
			x = adjvx[z] - point_size;
			y = adjvy[z] - point_size;
			if (x >= 0 && y >= 0 && x < pmaxx && y < pmaxy)
				putimage(x, y, image, 0);
		}
	}

	if (mark_mask & 4)
	{
		if (m)
			mouse_off();
		setcolor(color ^ old_mark_color);
		for (i=0; i<*mthings; i++)
		{
			z = mthings[i+2];
			for (j=0; j<lthing_count; j++)
				if (lthing_num[j] == z)
				{
					box_local_thing(j);
					break;
				}
		}
	}

	if (m)
		mouse_redraw();
	old_mark_color = color;
	return;
}
