/*
	This is a DMapEdit source code module.  Though it is copyrighted, you
	may modify it and use it for your own personal use, meaning that new
	modified code and anything derived from it (such as exe files) doesn't
	get distributed to anyone, unless you get my permission first.  Code
	from this file, or code based on ideas from this file may be used with
	other programs, provided that you give credit for it in the source code,
	documentation, and 'about' windows or screens, if one exists, for the
	programs using it.  Giving credit means something like this:

	Code from DMapEdit was used in this program

							  or

	Some code for this program was based on ideas presented in DMapEdit

	Whatever.  Just be sure to mention "DMapEdit" in such a way that it's
	self-evident how it was useful to the new program, and be sure to have
	"DMapEdit is a trademark of Jason Hoffoss" in the docs.  That's all..
*/

/* This is the old registered version code, which has now been modified
	and used now, since there is only one, non-crippled version anymore.
	The reason I had two different modules for registered and shareware was
	that, quite simply, it's a LOT harder to alter the resulting exe file
	to make it work like the registered version.
*/

#include <stdio.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>
#include "dme.h"
#include "dme2.h"

void fix_wadname(char *name);
void save_to_wad(int get_name); /* save map info to a pwad file */

extern int bypass_sw;
extern int backup;

void version_info(void)
{
	char msg[512];

/*	sprintf(msg, "DMapEdit v%d.%d", version/10, version%10);*/
	strcpy(msg, "DMapEdit v3.01"); /* kludge for this version */
	if (BETA)
		strcat(msg, " (Beta)");
	strcat(msg, "\t"
		"Written by Jason Hoffoss\t\n"
		"This program was written completely in C, using\n"
		"Borland C++ v3.1.  All the code was written from\n"
		"scratch, using no libraries, except the ones that\n"
		"came with the compiler.\n");

	window_text(msg, 1);
	window_check();
	draw_map();
	await_release();
	return;
}

void save_wad_map(int get_name) /* save map info to a pwad file */
{
	save_to_wad(get_name);
	return;
}

int write_wad_entry(char *name, char huge *farptr, long len, char far *entry)
{
	char buffer[4096];
	int i;

	if (_fstrnicmp(name, entry, 8))
		dir_error();
	while (len > 4096)
	{
		_fmemcpy(buffer, farptr, 4096);
		farptr += 4096;
		if (fwrite(buffer, 1, 4096, fp2) != 4096)
			goto err;
		len -= 4096;
	}

	_fmemcpy(buffer, farptr, len);
	if (fwrite(buffer, 1, len, fp2) != len)
		goto err;
	return 0;

err:
	error("Failed on write to backup WAD file");
	return -1;
}

/* write from a far memory location to disk.  It appears that in the
	medium memory model that only near file writting can be done.  So,
	this handles a far write.
*/

int far_write(char huge *farptr, long len)
{
	char buffer[4096];
	int i;

	if (!len) return 0;
	while (len > 4096)
	{
		_fmemcpy(buffer, farptr, 4096);
		farptr += 4096;
		if (fwrite(buffer, 1, 4096, fp) != 4096)
			return -1;
		len -= 4096;
	}

	_fmemcpy(buffer, farptr, len);
	if (fwrite(buffer, 1, len, fp) != len)
		return -1;
	return 0;
}

void sw_notice(void)
{
	char msg[4096], beta_msg[9];

	if (bypass_sw)
		return;

	*beta_msg = 0;
/*	if (BETA)
		sprintf(msg, "Welcome to beta DMapEdit v%d.%d\t\n"
			"|   Hi there!  This is a beta version of my map editor.  As such,\n"
			"|I cannot say that it has no errors.  In fact, the whole purpose of\n"
			"|of beta versions is to allow users to locate any and all bugs,\n"
			"|which are then reported to the author (me).  So, find some bugs,\n"
			"|try it out and see what you think, etc.  If you ask me, v2.1 sucks\n"
			"|compared to this version.  If you haven't yet read the \"reame.1st\"\n"
			"|file, be sure to do so.\n", version/10, version%10);
	else
		sprintf(msg, "Welcome to DMapEdit v%d.%d%s\t\n" */
		strcpy(msg, "Welcome to DMapEdit v3.01\t\n"
			"|   This program is shareware.  As such, you are free to try it out\n"
			"|and see if you like it before you pay for it.  I no longer have any\n"
			"|method of enforcing registration, so I am relying on your personal\n"
			"|sense of honor.  Registration is only $5, which is cheap enough for\n"
			"|anyone to affort.  Since this is the first shareware program I have\n"
			"|written, it also serves as a test to see how well shareware works,\n"
			"|moneywise.  The response I get will dictate how I proceed with any\n"
			"|future projects I write.  Another benefit of registering is that it\n"
			"|makes you eligible for beta testing future releases.  If you think\n"
			"|DMapEdit is worth more than $5, feel free to send me more ($5 is\n"
			"|rather a low figure, actually).  Also, if you don't have internet\n"
			"|or good BBS access, you may not have the latest version.  When you\n"
			"|register, I will send your the latest version, if you wish (let me\n"
			"|know what version you do have).  Plus, for every $2.50 extra you\n"
			"|send, I will send you a future update of DMapEdit (regular postal\n"
			"|mail.  If you would like it send any more expensive way, be sure to\n"
			"|include the money to cover it).  Send registration money (check/\n"
			"|money order/US cash) or other mail to this address:\n\n"

			"Jason Hoffoss        \t"
			"10321 110th st. N.   \t"
			"Stillwater, MN  55082\t\n"

			"|   Be sure to consult the 'dmapedit.doc' file if you have any\n"
			"|questions about anything.  You probably should read it even if you\n"
/*			"|don't, but it's your choice.\n", version/10, version%10, beta_msg); */
			"|don't, but it's your choice.\n");

	window_text1(msg, 1, 0, 4);
	mouse_on();
	while (!mouse_check())
		if (keypress)
			break;

	draw_map();
	await_release();
	return;
}

void final_screen(void)
{
	printf("\t\t\tThank you for using DMapEdit..\n\n"
		"Doom is a trademark of id Software Inc.\n"
		"DMapEdit is my trademark\n"
		"Vesa.bgi is copyright (c) 1991 Jordan Hargraphix\n"
		"Copyright (c) 1994 Jason Hoffoss.  All rights reserved.\n\n"

		"You may freely distribute this program, as long as it is distributed\n"
		"intact (all original files included and unmodified).  You may not sell\n"
		"this program, for profit or any other purpose.\n\n"

		"Remember, this program is shareware.  If you think this is a decend program\n"
		"and want to see other decend programs in the future written by me, register!\n"
		"Registering is only a one-time $5 fee.  Shareware only survives with the\n"
		"support of it's users!  My address, only again, is:\n\n"

		"\t  Jason Hoffoss                Phone: (612) 430-2768\n"
		"\t  10321 110th st. N.           EMail: hoffo002@gold.tc.umn.edu\n"
		"\t  Stillwater, MN  55082\n\n"

		"Feel free to send me comments, suggestions, bug reports, etc. too, even if\n"
		"you decide not to register.\n");

	return;
}