******************************************************************************
* PROGRAM NAME: VENDORS.PRG
*               VENDORS DATABASE SCREEN
*               SAMPLE BUSINESS APPLICATION PROGRAM
* LAST CHANGED: 09/25/89 09:26AM
* WRITTEN BY:   Borland International Inc.
******************************************************************************
*
*       FILES USED:
*       Database file    =  Vendors.dbf  (Vendors file)
*       Index file       =  Vendors.mdx
*         TAG: Vendor_id =  vendor_id  <= Master index
*       External procedure file = Library.prg
******************************************************************************

* Main procedure
PROCEDURE Vendors

   * Link to external procedure file of "tool" procedures
   SET PROCEDURE TO Library

   * Set up database environment
   DO Set_env

   SET COLOR TO &c_standard.

   * Declare variables used:
   * Database memory variables
   discount = 0
   STORE "" TO vendor_id, vendor, address1, address2, city, state
   STORE "" TO zip, phone, contact, phone_ext, terms

   * Miscellaneous variables - used to pass parameters to Library
   STORE "VENDORS" TO dbf, mlist      && Standard report & mail list available
   cust_rpt = "N/A"                   && No custom reports available
   STORE "m->vendor_id" TO key, key1
   STORE  "NONE" TO key2, key3
   keyname1 = "Vendor ID:"
   STORE "" TO keyname2, keyname3
   list_flds = "VENDOR_ID, VENDOR, PHONE"

   * Open databases files and choose active indexes
   SELECT 1
   USE Vendors ORDER Vendor_id
   GO TOP
   * Used for area code lookup
   USE Codes ORDER City IN 2

   record_num = RECNO()
   DO Load_fld

   * Show data screen
   CLEAR
   DO Dstatus
   DO Backgrnd
   DO Show_data

   * Define popup menus
   DO Bar_def

   * Activate main popup menu - execute user choices
   SET COLOR TO &c_popup.
   ACTIVATE POPUP main_mnu
   DO Sub_ret
   *
RETURN
*================= end of main procedure =====================================

*  UTILITY PROCEDURES (Proprietary to Vendors.prg)

PROCEDURE Filter
   * Filter (group) data into subset
   * Select subset to set up filter condition  (Y=turn on, N=abort selection,
   * T=turn off). If filter is already on, set default choice to T, show 
   * window. If filter is not on, set default choice to Y, show window.
   choice = IIF(filters_on,"T","Y")
   DO Filt_ans
   IF choice = "Y"
      * Start process of choosing filter condition
      STORE SPACE(15) TO city,terms
      STORE SPACE(2)  TO state
      STORE SPACE(10) TO zip
      ACTIVATE WINDOW alert
         * Get users filter condition selection(s)
         @   0,0 SAY "--------- ENTER FILTER CONDITION --------"
         @   1,1 SAY "CITY:  " GET m->city   PICTURE "!XXXXXXXXXXXXX"
         @   2,1 SAY "STATE: " GET m->state  PICTURE "!!"
         @   3,1 SAY "ZIP:   " GET m->zip
         @   4,1 SAY "TERMS: " GET m->terms  FUNCTION "!"
         READ
      DEACTIVATE WINDOW alert
      * Initialize filter condition variable to null (empty)
      PUBLIC subset1,subset2,subset3,subset4,subset5
      subset1 = ""
      * Process user's entries to build filter condition
      subset2 = subset1 + IIF([] <> TRIM(m->city), ;
                [UPPER(city) = UPPER(TRIM(m->city)) .AND. ], [])
      subset3 = subset2 + IIF([] <> TRIM(m->state), ;
                [state = TRIM(state) .AND. ], [])
      subset4 = subset3 + IIF([] <> TRIM(m->zip), ;
                [zip = TRIM(zip) .AND. ], [])
      subset5 = subset4 + IIF("" <> TRIM(m->terms), ;
                [terms = TRIM(terms) .AND. ], [])
      subset = subset5
      *
      * Check whether data entered into subset string
      IF "" = TRIM(subset)
         DO Warnbell
         filters_on = .F.
      ELSE
         * If string is not empty, truncate the .AND. from end
         subset = SUBSTR(subset, 1, LEN(subset) - 6)
         * Filter on entered filter string condition
         SET FILTER TO &subset.
         * Activate filter by moving record pointer
         GO TOP
         * Check whether filter condition matches any records (no match=EOF)
         filters_on = .NOT. EOF()   && Filter is turned on if .T.
         IF .NOT. filters_on
            * Turn off filter if no matching records found
            DO Warnbell
            DO Show_msg WITH "No Vendor records match the filter condition"
            SET FILTER TO
            GO record_num
         ENDIF
      ENDIF
   ELSE
      IF choice = "T"
         * If user selects "T", turn off filter
         SET FILTER TO
         filters_on = .F.
      ENDIF
   ENDIF
RETURN

PROCEDURE Indexer
   * Create/rebuild index
   INDEX ON vendor_id TAG Vendor_id
   GO TOP
RETURN

PROCEDURE Init_fld
   * Initialize memory variable values - for data entry
   STORE SPACE(4)  TO vendor_id,phone_ext
   STORE SPACE(30) TO vendor, address1, address2, contact
   terms    = SPACE(15)
   discount = 0
   city  = SPACE(20)
   state = "TN"                   && Could be any state or blank
   zip   = SPACE(10)
   phone = SPACE(13)
RETURN

PROCEDURE Load_fld
   * Copy field values from Vendors database record into memory variables
   vendor_id = vendor_id
   vendor    = vendor
   address1  = address1
   address2  = address2
   city      = city
   state     = state
   zip       = zip
   phone     = phone
   contact   = contact
   phone_ext = phone_ext
   terms     = terms
   discount  = discount
RETURN

PROCEDURE Repl_fld
   * Replace database fields with values of current memory variables
   REPLACE vendor_id WITH m->vendor_id,vendor WITH m->vendor, ;
           address1 WITH m->address1,address2 WITH m->address2, ;
           city WITH m->city,state   WITH m->state, ;
           zip WITH m->zip,phone WITH m->phone, ;
           contact WITH m->contact,phone_ext  WITH m->phone_ext, ;
           terms WITH m->terms,discount WITH m->discount
RETURN

PROCEDURE Backgrnd
   * Display background screen
   * Draw and fill in boxes
   @ 14, 5 TO 14,52        COLOR &c_red.
   @  1,22 TO  3,53 DOUBLE COLOR &c_blue.
   @  5, 4 TO  7,27 DOUBLE COLOR &c_red.
   @  8, 4 TO 19,53        COLOR &c_red.
   @  2,23 FILL TO  2,52   COLOR &c_blue.
   @  6, 5 FILL TO  6,26   COLOR &c_red.
   @  9, 5 FILL TO 18,52   COLOR &c_red.
   * Show data
   SET COLOR TO &c_data.
   @  2,28 SAY "VENDORS DATABASE"
   @  6, 6 SAY "VENDOR NUMBER:"
   @  9, 6 SAY "NAME:"
   @ 10, 6 SAY "ADDRESS:"
   @ 12, 6 SAY "CITY:"
   @ 13, 6 SAY "STATE:"
   @ 13,30 SAY "ZIP:"
   @ 15, 6 SAY "CONTACT:"
   @ 16, 6 SAY "PHONE:"
   @ 16,30 SAY "EXTENSION:"
   @ 17, 6 SAY "TERMS:"
   @ 18, 6 SAY "DISCOUNT:"
   @ 18,19 SAY "%"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Show_data
   * Show data
   SET COLOR TO &c_fields.
   @  6,21 SAY vendor_id
   @  9,15 SAY vendor
   @ 10,15 SAY address1
   @ 11,15 SAY address2
   @ 12,15 SAY city
   @ 13,15 SAY state
   @ 13,35 SAY zip
   @ 15,15 SAY contact
   @ 16,15 SAY phone
   @ 16,41 SAY phone_ext
   @ 17,15 SAY terms
   @ 18,16 SAY discount  PICTURE "99"
   SET COLOR TO &c_standard.
RETURN

PROCEDURE Get_data
   * Display data for entry
   SET COLOR TO &c_data.
   @  6,21 GET m->vendor_id  PICTURE  "9999" ;
           VALID Duplicat(&key.) ;
           ERROR "Invalid vendor ID number; please re-enter" ;
           MESSAGE "Enter a four digit vendor ID number, or Esc to quit"
   @  9,15 GET m->vendor    FUNCTION "!" ;
           MESSAGE "Enter vendor name"
   @ 10,15 GET m->address1  FUNCTION "!"
   @ 11,15 GET m->address2 FUNCTION "!"
   @ 12,15 GET m->city      PICTURE "!XXXXXXXXXXXXX"
   @ 13,15 GET m->state     PICTURE  "!!"
   @ 13,35 GET m->zip
   @ 15,15 GET m->contact   FUNCTION "!" ;
           MESSAGE "Enter name of vendor contact"
   @ 16,15 GET m->phone     PICTURE "(999)999-9999"
   @ 16,41 GET m->phone_ext PICTURE "9999" ;
           MESSAGE "Enter phone extension"
   @ 17,15 GET m->terms     FUNCTION "!" ;
           MESSAGE "Enter vendor's terms of sale"
   @ 18,16 GET m->discount  PICTURE "99" ;
           MESSAGE "Enter a discount rate (max. 99)"
   SET COLOR TO &c_standard.
   ON KEY LABEL F9 DO Findcode WITH m->city
RETURN

****************************  END OF VENDORS.PRG  ****************************
