******************************************************************************
*  PROGRAM NAME: BACK_RES.PRG
*                BACKUP & RESTORE PROGRAM
*                SAMPLE BUSINESS APPLICATION PROGRAM
*  LAST CHANGED: 09/25/89 09:26AM
*  WRITTEN BY:   Borland International Inc.
******************************************************************************

* Main procedure
PROCEDURE Back_res
   CLOSE DATABASES
   PUBLIC mpath
   STORE "" TO choice, answer
   * Define popup
   DO M_popdef
   SET COLOR TO &c_normal.
   CLEAR
   SET COLOR TO &c_pop.
   ACTIVATE POPUP backmenu
RETURN TO Business
*** END MAIN PROCEDURE *******************************************************

* UTILITY PROCEDURES
PROCEDURE Bbackup
   * Back up database and index files to floppy disk(s)
   ACTIVATE WINDOW backup
      @ 0,0  SAY "----------------- BACK UP DATA ------------------"
      @ 1,2  SAY "Insert a formatted floppy disk in drive A:"
      WAIT       "  Then press any key to begin backup..."
      RUN BACKUP &mpath.*.DB? A:
      RUN BACKUP &mpath.*.MDX A: /A
      ?? CHR(7)
      CLEAR
      ? "************  BACKUP PROCESS FINISHED  **********"
      WAIT
   DEACTIVATE WINDOW backup
   SET COLOR TO &c_normal.
   CLEAR
   SET COLOR TO &c_pop.
RETURN

PROCEDURE Back
   * Execute case depending on user's choice
   DO CASE
      CASE BAR() =  2
         DO Sure
         IF choice = "Y"
            DO Bbackup
         ENDIF
      CASE BAR() =  3
         DO Sure
         IF choice = "Y"
            DO Rrestore
         ENDIF
      CASE BAR() =  4
         RETURN TO Business
   ENDCASE
RETURN

PROCEDURE M_popdef
   * Defines the main popup menu
   DEFINE POPUP backmenu FROM 7,20 TO 12,59 ;
     MESSAGE "Press first letter of menu choice, " + ;
             "or highlight then press <Enter>"
   DEFINE BAR 1 OF backmenu ;
          PROMPT "======== BACKUP - RESTORE MENU =======" SKIP
   DEFINE BAR 2 OF backmenu ;
          PROMPT " Back up your data to floppy disks"
   DEFINE BAR 3 OF backmenu ;
          PROMPT " Restore your data from floppy disks"
   DEFINE BAR 4 OF backmenu ;
          PROMPT " Exit to the Main Menu"
   ON SELECTION POPUP backmenu DO Back
   DEFINE WINDOW backup FROM 14,15 TO 20,65 COLOR &c_pop.
RETURN

PROCEDURE Rrestore
   * Restore database and index files from floppy disk(s)
   ACTIVATE WINDOW backup
      @ 0,0  SAY "---------------- RESTORE DATA ------------------"
      @ 1,0  SAY "Insert first backup floppy disk in drive A:"
      WAIT       "  Then press any key to begin restoring..."
      ! RESTORE A: &mpath.*.DB?
      ! RESTORE A: &mpath.*.MDX
      ?? CHR(7)
      CLEAR
      ? "*********  RESTORE PROCESS FINISHED  **********"
      WAIT
   DEACTIVATE WINDOW backup
   SET COLOR TO &c_normal.
   CLEAR
   SET COLOR TO &c_pop.
RETURN

PROCEDURE Sure
   * Display confirming message
   SET COLOR TO &c_normal.
   CLEAR
   choice = "N"
   ACTIVATE WINDOW backup
      @ 0, 0  SAY "------------------- WARNING ---------------------"
      @ 1, 0  SAY " Are you sure you want to BACK UP or RESTORE ?"
      @ 2, 0  SAY "  Press Y to continue or N to stop."
      @ 3,10  SAY "CHOICE:" GET choice PICTURE "Y"
      ?? CHR(7)
      READ
      IF choice = "N"
         SET COLOR TO &c_pop.
         DEACTIVATE WINDOW backup
         RETURN
      ENDIF
      * Get DOS path for BACKUP or RESTORE programs
      IF UPPER(choice) = "Y"
         ?? CHR(7)
         mpath = "C:\dBASE\SAMPLES\" + SPACE(10)
         CLEAR
         @ 0, 0  SAY "---------- ENTER SAMPLE FILES PATH --------------"
         @ 1, 0  SAY " Enter disk drive and full DOS path"
         @ 2, 0  SAY "  (the drive and path your databases are on)"
         @ 3, 2  GET mpath VALID "" <> TRIM(mpath) ;
            MESSAGE "Enter a disk drive letter and full path"
         READ
         mpath = TRIM(mpath)
      ENDIF
   DEACTIVATE WINDOW backup
RETURN

*** END BACK_RES.PRG *********************************************************
